<?php
/**
 * Executado quando o plugin é desinstalado pelo utilizador (não apenas desativado).
 */

if ( ! defined('WP_UNINSTALL_PLUGIN') ) {
    exit; // segurança: evita acesso direto
}

// Nome da opção principal usada pelo plugin
$option_name = 'safo_crm_settings';

// Apagar opções guardadas
delete_option( $option_name );
delete_site_option( $option_name ); // no caso de multisite

// (Opcional) Apagar transientes ou caches relacionadas
delete_transient('safo_crm_api_token');
wp_cache_flush();

// (Opcional) Apagar logs criados pelo plugin
$uploads = wp_upload_dir();
$base    = trailingslashit( $uploads['basedir'] );

// nomes possíveis do ficheiro de log
$candidatos = [
  $base . 'safo-crm',       // sem extensão
  $base . 'safo-crm.log',   // com .log
];

foreach ($candidatos as $f) {
  if (file_exists($f)) {
    wp_delete_file( $f );
  }
}
