<?php
namespace SafoCRM;

class SafoCRM_Logger {
    private static function enabled(): bool {
        if (defined('SAFOCRM_LOGGING')) {
            return (bool) SAFOCRM_LOGGING; // constante tem prioridade
        }
        // Lê do array de settings, chave 'logging', default 0
        return (bool) SafoCRM_Settings::get('logging', 0);
    }

    private static function filePath(): string {
        $up = wp_upload_dir();
        return trailingslashit($up['basedir']) . 'safo-crm.log';
    }

    private static function write(string $level, string $msg, array $ctx = []): void {
        if (!self::enabled()) return;

        $line = '[' . gmdate('Y-m-d H:i:s') . ' UTC] [' . $level . '] ' . $msg;
        if (!empty($ctx)) $line .= ' | ' . wp_json_encode($ctx, JSON_UNESCAPED_SLASHES);
        $line .= "\n";
        @file_put_contents(self::filePath(), $line, FILE_APPEND);
    }

    public static function debug(string $msg, array $ctx = []): void { self::write('DEBUG', $msg, $ctx); }
    public static function info(string $msg, array $ctx = []): void  { self::write('INFO',  $msg, $ctx); }
    public static function error(string $msg, array $ctx = []): void { self::write('ERROR', $msg, $ctx); }
}
