<?php
/**
 * Plugin Name: SAFO CRM Connector - Business Management Software
 * Description: Integrates WordPress seamlessly with the SAFO Business Management Platform through a powerful and secure API, enabling real-time synchronization of data, clients, and operations between your website and the SAFO CRM.
 * Version: 1.0.0
 * Author: SAFO
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: safo-connector
 */


if (!defined('ABSPATH')) exit;

// Define caminhos
define('SAFOCRM_PATH', plugin_dir_path(__FILE__));
define('SAFOCRM_URL', plugin_dir_url(__FILE__));
define('SAFOCRM_VER', '1.0.0');

// Admin assets
add_action('admin_enqueue_scripts', function ($hook) {

    $icon_css = SAFOCRM_PATH . 'assets/admin-icon.css';
    if (file_exists($icon_css)) {
        wp_enqueue_style(
            'safo-crm-icon',
            SAFOCRM_URL . 'assets/admin-icon.css',
            [],
            (string) filemtime($icon_css)
        );
    }

    // Carregar só nas páginas do plugin
    // Ex.: toplevel_page_safo_crm, safo-crm_page_safo_crm_subpagina, etc.
    if (strpos($hook, 'safo_crm') === false) {
        return;
    }

    $screen = function_exists('get_current_screen') ? get_current_screen() : null;
    $page_id = $screen ? $screen->id : $hook; // enviaremos isto para o JS em vez de $_GET['page']

    $base_url  = SAFOCRM_URL . 'assets/';
    $base_path = SAFOCRM_PATH . 'assets/';

    // CSS
    $css = $base_path . 'admin.css';
    if (file_exists($css)) {
        wp_register_style(
            'safo-crm-admin',
            $base_url . 'admin.css',
            [],
            (string) filemtime($css)
        );
        wp_enqueue_style('safo-crm-admin');
    }

    // JS
    $js = $base_path . 'admin.js';
    if (file_exists($js)) {
        wp_register_script(
            'safo-crm-admin',
            $base_url . 'admin.js',
            ['jquery'],
            (string) filemtime($js),
            true
        );
        wp_script_add_data('safo-crm-admin', 'defer', true);

        // Dados para o JS sem usar $_GET
        $data = [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('safo_crm_ajax'),
            'page'    => $page_id,
            'hook'    => $hook,
        ];

        wp_enqueue_script('safo-crm-admin');
        wp_add_inline_script(
            'safo-crm-admin',
            'window.SAFOCRM = ' . wp_json_encode($data) . ';',
            'before'
        );
    }
});


// Inclui as classes principais
require_once SAFOCRM_PATH . 'src/Settings.php';
require_once SAFOCRM_PATH . 'src/AdminPage.php';
require_once SAFOCRM_PATH . 'src/ApiClient.php';
require_once SAFOCRM_PATH . 'src/SyncService.php';
require_once SAFOCRM_PATH . 'src/WebhookController.php';
require_once SAFOCRM_PATH . 'src/Logger.php';
require_once SAFOCRM_PATH . 'src/ProductImporter.php';
require_once SAFOCRM_PATH . 'src/AjaxRouter.php';

// Ativação e desativação
register_activation_hook(__FILE__, function () {
    \SafoCRM\SafoCRM_Settings::init();
    \SafoCRM\SafoCRM_Settings::ensure_schedule();
});

register_deactivation_hook(__FILE__, function () {
    wp_clear_scheduled_hook(\SafoCRM\SafoCRM_Settings::CRON_HOOK);
});

// Inicialização
// Inicialização
add_action('plugins_loaded', function(){
    // Se não tiver WooCommerce, ainda assim podes carregar Settings para evitar erros no ecrã de opções
    if (!class_exists('WooCommerce')) {
        \SafoCRM\SafoCRM_Settings::init();
        \SafoCRM\SafoCRM_Logger::warn('WooCommerce não está ativo. Funções de sincronização de stock serão ignoradas.');
        return;
    }

    \SafoCRM\SafoCRM_Settings::init();
    \SafoCRM\SafoCRM_AdminPage::init();
    \SafoCRM\SafoCRM_WebhookController::init();
    \SafoCRM\SafoCRM_SyncService::init();
    \SafoCRM\SafoCRM_AjaxRouter::init();
});


add_action(\SafoCRM\SafoCRM_Settings::CRON_HOOK, ['\SafoCRM\SafoCRM_SyncService', 'do_sync_cron']);

