function listarAcessos(cliId) {
    const fd = new FormData();
    fd.append('action','safo_router');
    fd.append('pass','list_acessos');
    fd.append('cli_id', cliId);

    fetch(SAFO_AJAX.ajaxurl, { method:'POST', body: fd })
      .then(r=>r.json())
      .then(data => console.log(data));
}

document.addEventListener('DOMContentLoaded', function () {
  var input = document.querySelector('input[name="safo_crm_settings[api_base]"]');
  if (!input) return;

  function normalize(v) {
    v = (v || '').trim();
    if (v && !/^https?:\/\//i.test(v)) v = 'https://' + v;
    return v;
  }

  // corrige ao sair do campo e quando muda
  ['blur','change'].forEach(function(ev){
    input.addEventListener(ev, function () {
      input.value = normalize(input.value);
    });
  });

  // garante correção mesmo que o utilizador não faça blur
  var form = input.closest('form');
  if (form) {
    form.addEventListener('submit', function () {
      input.value = normalize(input.value);
    });
  }
});

