<?php

namespace SAHCFWC\Libraries\Stripe\Util;

class ObjectTypes
{
    /**
     * @var array Mapping from object types to resource classes
     */
    const mapping =
        [
            \SAHCFWC\Libraries\Stripe\Collection::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Collection::class,
            \SAHCFWC\Libraries\Stripe\Issuing\CardDetails::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\CardDetails::class,
            \SAHCFWC\Libraries\Stripe\SearchResult::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SearchResult::class,
            \SAHCFWC\Libraries\Stripe\File::OBJECT_NAME_ALT => \SAHCFWC\Libraries\Stripe\File::class,
            // object classes: The beginning of the section generated from our OpenAPI spec
            \SAHCFWC\Libraries\Stripe\Account::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Account::class,
            \SAHCFWC\Libraries\Stripe\AccountLink::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\AccountLink::class,
            \SAHCFWC\Libraries\Stripe\AccountSession::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\AccountSession::class,
            \SAHCFWC\Libraries\Stripe\ApplePayDomain::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ApplePayDomain::class,
            \SAHCFWC\Libraries\Stripe\Application::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Application::class,
            \SAHCFWC\Libraries\Stripe\ApplicationFee::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ApplicationFee::class,
            \SAHCFWC\Libraries\Stripe\ApplicationFeeRefund::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ApplicationFeeRefund::class,
            \SAHCFWC\Libraries\Stripe\Apps\Secret::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Apps\Secret::class,
            \SAHCFWC\Libraries\Stripe\Balance::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Balance::class,
            \SAHCFWC\Libraries\Stripe\BalanceTransaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\BalanceTransaction::class,
            \SAHCFWC\Libraries\Stripe\BankAccount::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\BankAccount::class,
            \SAHCFWC\Libraries\Stripe\Billing\Alert::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\Alert::class,
            \SAHCFWC\Libraries\Stripe\Billing\AlertTriggered::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\AlertTriggered::class,
            \SAHCFWC\Libraries\Stripe\Billing\CreditBalanceSummary::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\CreditBalanceSummary::class,
            \SAHCFWC\Libraries\Stripe\Billing\CreditBalanceTransaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\CreditBalanceTransaction::class,
            \SAHCFWC\Libraries\Stripe\Billing\CreditGrant::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\CreditGrant::class,
            \SAHCFWC\Libraries\Stripe\Billing\Meter::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\Meter::class,
            \SAHCFWC\Libraries\Stripe\Billing\MeterEvent::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\MeterEvent::class,
            \SAHCFWC\Libraries\Stripe\Billing\MeterEventAdjustment::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\MeterEventAdjustment::class,
            \SAHCFWC\Libraries\Stripe\Billing\MeterEventSummary::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Billing\MeterEventSummary::class,
            \SAHCFWC\Libraries\Stripe\BillingPortal\Configuration::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\BillingPortal\Configuration::class,
            \SAHCFWC\Libraries\Stripe\BillingPortal\Session::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\BillingPortal\Session::class,
            \SAHCFWC\Libraries\Stripe\Capability::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Capability::class,
            \SAHCFWC\Libraries\Stripe\Card::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Card::class,
            \SAHCFWC\Libraries\Stripe\CashBalance::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CashBalance::class,
            \SAHCFWC\Libraries\Stripe\Charge::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Charge::class,
            \SAHCFWC\Libraries\Stripe\Checkout\Session::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Checkout\Session::class,
            \SAHCFWC\Libraries\Stripe\Climate\Order::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Climate\Order::class,
            \SAHCFWC\Libraries\Stripe\Climate\Product::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Climate\Product::class,
            \SAHCFWC\Libraries\Stripe\Climate\Supplier::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Climate\Supplier::class,
            \SAHCFWC\Libraries\Stripe\ConfirmationToken::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ConfirmationToken::class,
            \SAHCFWC\Libraries\Stripe\ConnectCollectionTransfer::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ConnectCollectionTransfer::class,
            \SAHCFWC\Libraries\Stripe\CountrySpec::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CountrySpec::class,
            \SAHCFWC\Libraries\Stripe\Coupon::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Coupon::class,
            \SAHCFWC\Libraries\Stripe\CreditNote::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CreditNote::class,
            \SAHCFWC\Libraries\Stripe\CreditNoteLineItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CreditNoteLineItem::class,
            \SAHCFWC\Libraries\Stripe\Customer::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Customer::class,
            \SAHCFWC\Libraries\Stripe\CustomerBalanceTransaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CustomerBalanceTransaction::class,
            \SAHCFWC\Libraries\Stripe\CustomerCashBalanceTransaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CustomerCashBalanceTransaction::class,
            \SAHCFWC\Libraries\Stripe\CustomerSession::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\CustomerSession::class,
            \SAHCFWC\Libraries\Stripe\Discount::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Discount::class,
            \SAHCFWC\Libraries\Stripe\Dispute::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Dispute::class,
            \SAHCFWC\Libraries\Stripe\Entitlements\ActiveEntitlement::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Entitlements\ActiveEntitlement::class,
            \SAHCFWC\Libraries\Stripe\Entitlements\ActiveEntitlementSummary::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Entitlements\ActiveEntitlementSummary::class,
            \SAHCFWC\Libraries\Stripe\Entitlements\Feature::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Entitlements\Feature::class,
            \SAHCFWC\Libraries\Stripe\EphemeralKey::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\EphemeralKey::class,
            \SAHCFWC\Libraries\Stripe\Event::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Event::class,
            \SAHCFWC\Libraries\Stripe\ExchangeRate::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ExchangeRate::class,
            \SAHCFWC\Libraries\Stripe\File::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\File::class,
            \SAHCFWC\Libraries\Stripe\FileLink::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FileLink::class,
            \SAHCFWC\Libraries\Stripe\FinancialConnections\Account::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FinancialConnections\Account::class,
            \SAHCFWC\Libraries\Stripe\FinancialConnections\AccountOwner::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FinancialConnections\AccountOwner::class,
            \SAHCFWC\Libraries\Stripe\FinancialConnections\AccountOwnership::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FinancialConnections\AccountOwnership::class,
            \SAHCFWC\Libraries\Stripe\FinancialConnections\Session::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FinancialConnections\Session::class,
            \SAHCFWC\Libraries\Stripe\FinancialConnections\Transaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FinancialConnections\Transaction::class,
            \SAHCFWC\Libraries\Stripe\Forwarding\Request::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Forwarding\Request::class,
            \SAHCFWC\Libraries\Stripe\FundingInstructions::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\FundingInstructions::class,
            \SAHCFWC\Libraries\Stripe\Identity\VerificationReport::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Identity\VerificationReport::class,
            \SAHCFWC\Libraries\Stripe\Identity\VerificationSession::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Identity\VerificationSession::class,
            \SAHCFWC\Libraries\Stripe\Invoice::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Invoice::class,
            \SAHCFWC\Libraries\Stripe\InvoiceItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\InvoiceItem::class,
            \SAHCFWC\Libraries\Stripe\InvoiceLineItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\InvoiceLineItem::class,
            \SAHCFWC\Libraries\Stripe\InvoiceRenderingTemplate::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\InvoiceRenderingTemplate::class,
            \SAHCFWC\Libraries\Stripe\Issuing\Authorization::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\Authorization::class,
            \SAHCFWC\Libraries\Stripe\Issuing\Card::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\Card::class,
            \SAHCFWC\Libraries\Stripe\Issuing\Cardholder::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\Cardholder::class,
            \SAHCFWC\Libraries\Stripe\Issuing\Dispute::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\Dispute::class,
            \SAHCFWC\Libraries\Stripe\Issuing\PersonalizationDesign::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\PersonalizationDesign::class,
            \SAHCFWC\Libraries\Stripe\Issuing\PhysicalBundle::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\PhysicalBundle::class,
            \SAHCFWC\Libraries\Stripe\Issuing\Token::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\Token::class,
            \SAHCFWC\Libraries\Stripe\Issuing\Transaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Issuing\Transaction::class,
            \SAHCFWC\Libraries\Stripe\LineItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\LineItem::class,
            \SAHCFWC\Libraries\Stripe\LoginLink::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\LoginLink::class,
            \SAHCFWC\Libraries\Stripe\Mandate::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Mandate::class,
            \SAHCFWC\Libraries\Stripe\PaymentIntent::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\PaymentIntent::class,
            \SAHCFWC\Libraries\Stripe\PaymentLink::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\PaymentLink::class,
            \SAHCFWC\Libraries\Stripe\PaymentMethod::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\PaymentMethod::class,
            \SAHCFWC\Libraries\Stripe\PaymentMethodConfiguration::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\PaymentMethodConfiguration::class,
            \SAHCFWC\Libraries\Stripe\PaymentMethodDomain::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\PaymentMethodDomain::class,
            \SAHCFWC\Libraries\Stripe\Payout::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Payout::class,
            \SAHCFWC\Libraries\Stripe\Person::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Person::class,
            \SAHCFWC\Libraries\Stripe\Plan::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Plan::class,
            \SAHCFWC\Libraries\Stripe\Price::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Price::class,
            \SAHCFWC\Libraries\Stripe\Product::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Product::class,
            \SAHCFWC\Libraries\Stripe\ProductFeature::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ProductFeature::class,
            \SAHCFWC\Libraries\Stripe\PromotionCode::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\PromotionCode::class,
            \SAHCFWC\Libraries\Stripe\Quote::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Quote::class,
            \SAHCFWC\Libraries\Stripe\Radar\EarlyFraudWarning::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Radar\EarlyFraudWarning::class,
            \SAHCFWC\Libraries\Stripe\Radar\ValueList::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Radar\ValueList::class,
            \SAHCFWC\Libraries\Stripe\Radar\ValueListItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Radar\ValueListItem::class,
            \SAHCFWC\Libraries\Stripe\Refund::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Refund::class,
            \SAHCFWC\Libraries\Stripe\Reporting\ReportRun::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Reporting\ReportRun::class,
            \SAHCFWC\Libraries\Stripe\Reporting\ReportType::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Reporting\ReportType::class,
            \SAHCFWC\Libraries\Stripe\ReserveTransaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ReserveTransaction::class,
            \SAHCFWC\Libraries\Stripe\Review::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Review::class,
            \SAHCFWC\Libraries\Stripe\SetupAttempt::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SetupAttempt::class,
            \SAHCFWC\Libraries\Stripe\SetupIntent::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SetupIntent::class,
            \SAHCFWC\Libraries\Stripe\ShippingRate::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\ShippingRate::class,
            \SAHCFWC\Libraries\Stripe\Sigma\ScheduledQueryRun::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Sigma\ScheduledQueryRun::class,
            \SAHCFWC\Libraries\Stripe\Source::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Source::class,
            \SAHCFWC\Libraries\Stripe\SourceMandateNotification::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SourceMandateNotification::class,
            \SAHCFWC\Libraries\Stripe\SourceTransaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SourceTransaction::class,
            \SAHCFWC\Libraries\Stripe\Subscription::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Subscription::class,
            \SAHCFWC\Libraries\Stripe\SubscriptionItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SubscriptionItem::class,
            \SAHCFWC\Libraries\Stripe\SubscriptionSchedule::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\SubscriptionSchedule::class,
            \SAHCFWC\Libraries\Stripe\Tax\Calculation::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Tax\Calculation::class,
            \SAHCFWC\Libraries\Stripe\Tax\CalculationLineItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Tax\CalculationLineItem::class,
            \SAHCFWC\Libraries\Stripe\Tax\Registration::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Tax\Registration::class,
            \SAHCFWC\Libraries\Stripe\Tax\Settings::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Tax\Settings::class,
            \SAHCFWC\Libraries\Stripe\Tax\Transaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Tax\Transaction::class,
            \SAHCFWC\Libraries\Stripe\Tax\TransactionLineItem::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Tax\TransactionLineItem::class,
            \SAHCFWC\Libraries\Stripe\TaxCode::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\TaxCode::class,
            \SAHCFWC\Libraries\Stripe\TaxDeductedAtSource::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\TaxDeductedAtSource::class,
            \SAHCFWC\Libraries\Stripe\TaxId::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\TaxId::class,
            \SAHCFWC\Libraries\Stripe\TaxRate::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\TaxRate::class,
            \SAHCFWC\Libraries\Stripe\Terminal\Configuration::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Terminal\Configuration::class,
            \SAHCFWC\Libraries\Stripe\Terminal\ConnectionToken::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Terminal\ConnectionToken::class,
            \SAHCFWC\Libraries\Stripe\Terminal\Location::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Terminal\Location::class,
            \SAHCFWC\Libraries\Stripe\Terminal\Reader::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Terminal\Reader::class,
            \SAHCFWC\Libraries\Stripe\TestHelpers\TestClock::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\TestHelpers\TestClock::class,
            \SAHCFWC\Libraries\Stripe\Token::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Token::class,
            \SAHCFWC\Libraries\Stripe\Topup::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Topup::class,
            \SAHCFWC\Libraries\Stripe\Transfer::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Transfer::class,
            \SAHCFWC\Libraries\Stripe\TransferReversal::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\TransferReversal::class,
            \SAHCFWC\Libraries\Stripe\Treasury\CreditReversal::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\CreditReversal::class,
            \SAHCFWC\Libraries\Stripe\Treasury\DebitReversal::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\DebitReversal::class,
            \SAHCFWC\Libraries\Stripe\Treasury\FinancialAccount::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\FinancialAccount::class,
            \SAHCFWC\Libraries\Stripe\Treasury\FinancialAccountFeatures::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\FinancialAccountFeatures::class,
            \SAHCFWC\Libraries\Stripe\Treasury\InboundTransfer::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\InboundTransfer::class,
            \SAHCFWC\Libraries\Stripe\Treasury\OutboundPayment::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\OutboundPayment::class,
            \SAHCFWC\Libraries\Stripe\Treasury\OutboundTransfer::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\OutboundTransfer::class,
            \SAHCFWC\Libraries\Stripe\Treasury\ReceivedCredit::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\ReceivedCredit::class,
            \SAHCFWC\Libraries\Stripe\Treasury\ReceivedDebit::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\ReceivedDebit::class,
            \SAHCFWC\Libraries\Stripe\Treasury\Transaction::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\Transaction::class,
            \SAHCFWC\Libraries\Stripe\Treasury\TransactionEntry::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\Treasury\TransactionEntry::class,
            \SAHCFWC\Libraries\Stripe\UsageRecord::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\UsageRecord::class,
            \SAHCFWC\Libraries\Stripe\UsageRecordSummary::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\UsageRecordSummary::class,
            \SAHCFWC\Libraries\Stripe\WebhookEndpoint::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\WebhookEndpoint::class,
            // object classes: The end of the section generated from our OpenAPI spec
        ];

    /**
     * @var array Mapping from v2 object types to resource classes
     */
    const v2Mapping = [
        // v2 object classes: The beginning of the section generated from our OpenAPI spec
        \SAHCFWC\Libraries\Stripe\V2\Billing\MeterEvent::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\V2\Billing\MeterEvent::class,
        \SAHCFWC\Libraries\Stripe\V2\Billing\MeterEventAdjustment::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\V2\Billing\MeterEventAdjustment::class,
        \SAHCFWC\Libraries\Stripe\V2\Billing\MeterEventSession::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\V2\Billing\MeterEventSession::class,
        \SAHCFWC\Libraries\Stripe\V2\Event::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\V2\Event::class,
        \SAHCFWC\Libraries\Stripe\V2\EventDestination::OBJECT_NAME => \SAHCFWC\Libraries\Stripe\V2\EventDestination::class,
        // v2 object classes: The end of the section generated from our OpenAPI spec
    ];
}
