<?php
/**
 * SAHCFWC_Stripe_Local_Payment_Methods_List trait.
 *
 * @package sa-hosted-checkout-for-woocommerce
 */

namespace SAHCFWC\Traits;

if ( ! trait_exists( 'SAHCFWC\Traits\SAHCFWC_Stripe_Local_Payment_Methods_List' ) ) {

	/**
	 * SAHCFWC_Stripe_Local_Payment_Methods_List trait
	 *
	 * This class create list of stipe payment method
	 *
	 * @copyright  sleekalgo
	 * @version    Release: 1.0.0
	 * @link       https://www.sleekalgo.com
	 * @package    SA Hosted Checkout for WooCommerce
	 * @since      Class available since Release 1.0.0
	 */
	trait SAHCFWC_Stripe_Local_Payment_Methods_List {

		/**
		 * Payment method list.
		 *
		 * @since 1.0.0
		 *
		 * @param  string $wc_country WooCommerce order object.
		 * @return array|result page redirect.
		 */
		public function sahcfwc_get_stripe_local_payment_methods( $wc_country = '' ) {

			$stripe_local_payment_methods = array(
				array(
					'id'             => 'us_bank_account',
					'title'          => esc_html__( 'USD bank transfers', 'sa-hosted-checkout-for-woocommerce' ),
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/usd-bank-transfers.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'us' => esc_html__( 'United States', 'sa-hosted-checkout-for-woocommerce' ),
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Keep transaction cost low with credit transfers—ideal for large, one-off transactions like B2B payments.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'For large transactions, Stripe makes it possible to accept credit transfers or wires with automated reconciliation, lowering the chance of payment failure without adding operational complexity.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'ideal',
					'title'          => esc_html__( 'iDEAL', 'sa-hosted-checkout-for-woocommerce' ),
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/iDEAL.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Increase conversion with Dutch customers by enabling iDEAL—the most popular payment method in the Netherlands, with 57% share of online payments.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'affirm',
					'title'          => 'Affirm',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/affirm.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ca' => 'Canada',
							'us' => 'United States',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let US and CA customers pay in 4 interest-free payments every 2 weeks or monthly installments up to 36 months depending on location. Affirm has over 31 million addressable customers in the US and CA. ', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Offer flexible buy now, pay later payment options that increase your customers purchasing power, leading to higher conversion and order value.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'afterpay_clearpay',
					'title'          => 'Afterpay/Clearpay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/afterpay.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'ca' => 'Canada',
							'nz' => 'New Zealand',
							'us' => 'United States',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your customers break their payment into 3 or 4 interest-free installments using Afterpay (also known as Clearpay), with 20 million active global customers', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Offer flexible buy now, pay later payment options that increase your customers’ purchasing power, leading to higher conversion and order value.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country (or in the European Union) where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'paynow',
					'title'          => 'PayNow',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/paynow.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'sg' => 'Singapore',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Offer customers the option to pay using PayNow, Singapore’s national payment scheme and the fastest growing major payment method in the country', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to pay almost instantly, 24/7 directly from their bank accounts, wallets, or other funding source, which helps increase speed and conversion—all at a low cost to your business.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'paypal',
					'title'          => 'PayPal',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/paypal.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'nl' => 'Netherlands',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Offer a trusted and familiar payment method available to customers in over 200 markets to help millions of active global PayPal users speed through checkout.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you have a legal entity registered in European Union, UK or Switzerland.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'oxxo',
					'title'          => 'OXXO',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/oxxo.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'mx' => 'Mexico',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Mexican customers pay with OXXO—a voucher-based payment method that represents more than 30% of transactions in Mexico.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Allow customers to pay bills and online purchases in-store with cash.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(

					'id'             => 'acss_debit',
					'title'          => 'Pre-authorized debits in Canada',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/preauth.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ca' => 'Canada',
							'us' => 'United States',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your customers pay with pre-authorized debits (PADs), a popular direct debit payment method in Canada.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Minimize involuntary churn and lower transaction costs by accepting direct debits for subscription or recurring charges.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'konbini',
					'title'          => 'Konbini',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/konbini.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'jp' => 'Japan',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Offer customers the option to pay at over 34,000 convenience stores in Japan through a unified Stripe integration.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Allow customers to pay bills and online purchases in-store with cash.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),

				array(
					'id'             => 'promptpay',
					'title'          => 'PromptPay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/promptpay.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'th' => 'Thailand',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let customers in Thailand pay using PromptPay, the national payment scheme supported by the Thai government.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to pay almost instantly, 24/7 directly from their bank accounts, wallets, or other funding source, which helps increase speed and conversion—all at a low cost to your business.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'p24',
					'title'          => 'Przelewy24',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/prze.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Polish customers pay with P24—a popular bank transfer method in Poland.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'Mastercard',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/master.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ar' => 'Argentina',
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'br' => 'Brazil',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'cl' => 'Chile',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'is' => 'Iceland',
							'in' => 'India',
							'id' => 'Indonesia',
							'ie' => 'Ireland',
							'il' => 'Israel',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'my' => 'Malaysia',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'kr' => 'South Korea',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'th' => 'Thailand',
							'ae' => 'United Arab Emirates',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept the dominant payment method globally with one of the largest card networks in the world.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'sepa_debit',
					'title'          => 'SEPA Direct Debit',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/sepa.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Minimize involuntary churn for subscriptions or recurring payments by debiting your customers’ bank accounts in 36 European countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Minimize involuntary churn and lower transaction costs by accepting direct debits for subscription or recurring charges.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'Visa',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/visa.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ar' => 'Argentina',
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'br' => 'Brazil',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'cl' => 'Chile',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'is' => 'Iceland',
							'in' => 'India',
							'ie' => 'Ireland',
							'il' => 'Israel',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'my' => 'Malaysia',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'kr' => 'South Korea',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'th' => 'Thailand',
							'ae' => 'United Arab Emirates',
							'gb' => 'United Kingdom',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept the dominant payment method globally with one of the largest card networks in the world.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'DinersClub',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/diners.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ca' => 'Canada',
							'jp' => 'Japan',
							'us' => 'United States',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept the popular credit card supported in over 185 countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'Discover',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/discover.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ca' => 'Canada',
							'jp' => 'Japan',
							'us' => 'United States',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept a popular US card with high authorization rates.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'eps',
					'title'          => 'EPS',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/eps.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Austrian customers pay with EPS—an online transfer payment method with over 18% market share in Austria.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'giropay',
					'title'          => 'giropay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/giropay.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let German customer’s pay with Giropay—a popular bank transfer method that accounts for over 16% of online checkouts in Germany.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),

				array(
					'id'             => 'fpx',
					'title'          => 'FPX',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/fpx.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'my' => 'Malaysia',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Malaysian customers pay with FPX, one of the most popular payment methods in Malaysia, using their bank credentials.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'grabpay',
					'title'          => 'GrabPay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/grabpay.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'my' => 'Malaysia',
							'sg' => 'Singapore',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Singapore and Malaysia customers pay with GrabPay wallets in Singapore and Malaysia respectively.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'Interac',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/inter.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ca' => 'Canada',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept the dominant payment method globally with Canada’s leading debit card.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'JCB',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/jcb.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'jp' => 'Japan',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Support nearly 140 million cardholders worldwide with the most widely accepted Japanese credit card in Japan.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'JCBI',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/jcbi.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'ca' => 'Canada',
							'nz' => 'New Zealand',
							'us' => 'United States',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Support 140 million cardholders shopping worldwide with JCBI, the one and only international payment brand from Japan.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'klarna',
					'title'          => 'Klarna',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/klarna.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'ca' => 'Canada',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gr' => 'Greece',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'lv' => 'Latvia',
							'lt' => 'Lithuania',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Offer flexible payment options that give customers more freedom to choose when and how to pay for a purchase, with 150 million consumers across 27 markets.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Offer flexible buy now, pay later payment options that increase your customers’ purchasing power, leading to higher conversion and order value.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country (or in the European Union) where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'link',
					'title'          => 'Link',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/link.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Deliver a frictionless and seamless checkout experience with Link, a 1-click checkout that autofills your customer’s payment and shipping details.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'Cartes Bancaires',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/cartes.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'is' => 'Iceland',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Expand your reach and increase conversions with France’s largest card network.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'American Express',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/american.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'ar' => 'Argentina',
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'cl' => 'Chile',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'is' => 'Iceland',
							'in' => 'India',
							'id' => 'Indonesia',
							'ie' => 'Ireland',
							'il' => 'Israel',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'kr' => 'South Korea',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept the dominant payment method globally with a popular credit card used in more than 130 countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'boleto',
					'title'          => 'Boleto',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/boleto.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'br' => 'Brazil',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Brazilian customers pay with Boleto—a voucher-based payment method that represents more than 20% of transactions in Brazil.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Allow customers to pay bills and online purchases in-store with cash.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'blik',
					'title'          => 'BLIK',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/blik.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hu' => 'Hungary',
							'is' => 'Iceland',
							'ie' => 'Ireland',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'nl' => 'Netherlands',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Increase your reach and conversion with one of Poland’s fastest growing bank-based methods.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'au_becs_debit',
					'title'          => 'BECS Direct Debit',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/becs.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept Bulk Electronic Clearing System (BECS) Direct Debit payments from customers with an Australian bank account.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Minimize involuntary churn and lower transaction costs by accepting direct debits for subscription or recurring charges.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'bacs_debit',
					'title'          => 'Bacs Direct Debit',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/bacs.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your UK customers set up one-off or recurring payments through Bacs Direct Debit.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Minimize involuntary churn and lower transaction costs by accepting direct debits for subscription or recurring charges.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'bancontact',
					'title'          => 'Bancontact',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/bancontact.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'mx' => 'Mexico',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',

						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Belgian customers pay with Bancontact—Belgium’s most popular payment method offered by over 80% of online businesses.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Increase conversion by offering customers a more convenient and secure way to pay from their bank account. By authorizing payment using the customer’s online banking credentials, bank redirects are the preferred method of paying online in many countries.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'alipay',
					'title'          => 'Alipay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/alipay.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gi' => 'Gibraltar',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'my' => 'Malaysia',
							'mt' => 'Malta',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Allow customers to pay with Alipay in 11 major currencies to reach consumers in China and overseas Chinese consumers and travelers.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'wechat_pay',
					'title'          => 'WeChat Pay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/wechat.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'ca' => 'Canada',
							'dk' => 'Denmark',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'hk' => 'Hong Kong',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'jp' => 'Japan',
							'lu' => 'Luxembourg',
							'nl' => 'Netherlands',
							'no' => 'Norway',
							'pt' => 'Portugal',
							'sg' => 'Singapore',
							'us' => 'United States',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your customers pay with WeChat Pay—the wallet inside the popular messaging app WeChat that has more than 900 million active monthly users.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'card',
					'title'          => 'China UnionPay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/china.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'au' => 'Australia',
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'ca' => 'Canada',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gr' => 'Greece',
							'hk' => 'Hong Kong',
							'hu' => 'Hungary',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'lv' => 'Latvia',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'my' => 'Malaysia',
							'mt' => 'Malta',
							'nl' => 'Netherlands',
							'nz' => 'New Zealand',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sg' => 'Singapore',
							'us' => 'United States',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Support nearly 9 billion UnionPay cards in circulation worldwide when you integrate with Stripe.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Accept all major debit and credit cards from customers in every country.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => '',
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'zip',
					'title'          => 'Zip',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/zip.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(

							'au' => 'Australia',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Give Australian customers a more flexible way to pay. Zip is a familiar payment method used by 3.2 million customers and 43,200 retailers in Australia and New Zealand.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Offer flexible buy now, pay later payment options that increase your customers’ purchasing power, leading to higher conversion and order value.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'cashapp',
					'title'          => 'Cash App Pay',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/cash.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'us' => 'United States',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Accept payments with Cash App Pay, allowing customers to pay using their Cash App balance or linked debit card.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country where you are offering the payment method', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),

				array(
					'id'             => 'revolut_pay',
					'title'          => 'RevolutPay  (Invite only)',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/rpay.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'gb' => 'United Kingdom',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Offer your customers the convenience of Revolut Pay, allowing them to pay directly through their Revolut account or to check out as a guest.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country (or in the European Union) where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'mobilepay',
					'title'          => 'MobilePay (Invite only)',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/mobile.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'gr' => 'Greece',
							'hu' => 'Hungary',
							'is' => 'Iceland',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'mt' => 'Malta',
							'nl' => 'Netherlands',
							'no' => 'Norway',
							'pl' => 'Poland',
							'pt' => 'Portugal',
							'ro' => 'Romania',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Offer customers the option to pay using MobilePay, a single-use card wallet payment method used in Denmark and Finland.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to check out faster with wallet payment methods that digitally store credit and debit cards. Wallets eliminate the need for customers to manually enter their card and billing information, offering a quick and convenient way to pay.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country (or in the European Union) where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),
				array(
					'id'             => 'swish',
					'title'          => 'Swish   (Invite only)',
					'icon_url'       => SAHCFWC_URL_ASSETS_BACKEND_LOCAL_PAYMENT_METHODS_IMAGES . '/swish.svg',
					'payment_faimly' => '',
					'countries'      => array(
						array(
							'at' => 'Austria',
							'be' => 'Belgium',
							'bg' => 'Bulgaria',
							'hr' => 'Croatia',
							'cy' => 'Cyprus',
							'cz' => 'Czech Republic',
							'dk' => 'Denmark',
							'ee' => 'Estonia',
							'fi' => 'Finland',
							'fr' => 'France',
							'de' => 'Germany',
							'is' => 'Iceland',
							'ie' => 'Ireland',
							'it' => 'Italy',
							'lv' => 'Latvia',
							'li' => 'Liechtenstein',
							'lt' => 'Lithuania',
							'lu' => 'Luxembourg',
							'nl' => 'Netherlands',
							'no' => 'Norway',
							'pl' => 'Poland',
							'ro' => 'Romania',
							'sk' => 'Slovakia',
							'si' => 'Slovenia',
							'es' => 'Spain',
							'se' => 'Sweden',
							'ch' => 'Switzerland',
						),
					),
					'use_case'       => '',
					'description'    => esc_html__( 'Let your Swedish customers pay with Swish, enabling them purchase using the Swish mobile app and the Swedish BankID mobile app.', 'sa-hosted-checkout-for-woocommerce' ),
					'help'           => esc_html__( 'Enable your customers to pay almost instantly, 24/7 directly from their bank accounts, wallets, or other funding source, which helps increase speed and conversion—all at a low cost to your business.', 'sa-hosted-checkout-for-woocommerce' ),
					'legal'          => esc_html__( 'This payment method requires you to have a legal entity registered in the country (or in the European Union) where you are offering the payment method.', 'sa-hosted-checkout-for-woocommerce' ),
					'created_at'     => current_time( 'Y-m-d H:i:s' ),
					'updated_at'     => current_time( 'Y-m-d H:i:s' ),
				),

			);

			$enabled_local_payment_methods = get_option( 'sahcfwc_stripe_payment_methodes' );
			$enabled_local_payment_methods = ( is_array( $enabled_local_payment_methods ) && count( $enabled_local_payment_methods ) > 0 ) ? $enabled_local_payment_methods : array();
			$result                        = array();
			if ( ! empty( $wc_country ) ) {
				if ( is_array( $stripe_local_payment_methods ) && count( $stripe_local_payment_methods ) > 0 ) {
					foreach ( $stripe_local_payment_methods as $key => $method ) {
						if ( is_array( $method['countries'] ) && count( $method['countries'] ) > 0 ) {
							foreach ( $method['countries'] as $country ) {
								if ( array_key_exists( $wc_country, $country ) ) {
									$staus            = ( in_array( $method['title'], array_column( $enabled_local_payment_methods, 'title' ), true ) ) ? 'enabled' : 'disabled';
									$method['status'] = $staus;
									$result[]         = $method;
									break;
								}
							}
						}
					}
				}
			} else {
				$result = $stripe_local_payment_methods;
			}

			return $result;

		}

	}
}
