// Severity enum file
const SEVERITY = {
  INFORMATION: {
    level: 1,
    color: "#1aaaed",
    text: "Information",
    textColor: "white",
  },
  LOW: { level: 2, color: "#8FCE00", text: "Low", textColor: "white" },
  MEDIUM: { level: 3, color: "#F85501", text: "Medium", textColor: "white" },
  HIGH: { level: 4, color: "#C00037", text: "High", textColor: "white" },
  CRITICAL: {
    level: 5,
    color: "#67096B",
    text: "Critical",
    textColor: "white",
  },
};

const SCAN_TYPE = {
  SINGLE_SCAN: { level: 0, text: "Single Scan" },
  FULL_SCAN: { level: 1, text: "Full Scan" },
  HALF_SCAN: { level: 2, text: "Light Scan" },
  CONTINUOUS_SCAN: { level: 3, text: "Continuous Scan" },
  API: { level: 4, text: "API" },
  CRAWL_ONLY: { level: 5, text: "Crawl Only" },
  WEB_VULN: { level: 6, text: "Web Vulnerability" },
};

// Status Names enum file
const STATUS_NAMES = {
  OPEN: { level: 0, text: "Open", className: "Open" },
  FIXED: { level: 1, text: "Fixed", className: "Fixed" },
  REQUEST_FOR_APPROVAL: {
    level: 2,
    text: "Request for approval",
    className: "Request-for-approval",
  },
  ACCEPTED_RISK: {
    level: 3,
    text: "Accepted risk",
    className: "Accepted-risk",
  },
  FALSE_POSITIVE: {
    level: 4,
    text: "False positive",
    className: "False-positive",
  },
  SUPPORT_ONGOING: {
    level: 5,
    text: "Support ongoing",
    className: "Support-ongoing",
  },
  NO_NEED_ACTION: {
    level: 6,
    text: "No need action",
    className: "No-need-action",
  },
  RE_OPENED: { level: 7, text: "Re-opened", className: "Re-opened" },
};

const AssetStatus = {
  ASSET_ADDED: 1,
  ASSET_NOT_ADDED: 0,
  ASSET_VERIFIED: 2,
  ASSET_NOT_VERIFIED: 3,
};
