<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Enqueue SweetAlert CSS and JS in WordPress
function s4esec_enqueue_sweetalert()
{
    wp_enqueue_script('sweetalert-js', plugins_url('../assets/js/sweetalert2.min.js', __FILE__), array('jquery'), '11.4.8', true);
    wp_enqueue_style('sweetalert-css', plugins_url('../assets/css/sweetalert2.min.css', __FILE__), array(), '11.4.8');
}
add_action('wp_enqueue_scripts', 's4esec_enqueue_sweetalert');

// Function to display the login form with a lock icon, token input, and verify button
function s4esec_display_login_form()
{
    ob_start();
    ?>
    <div id="s4e-login-wrapper">
        <!-- Lock Icon -->
        <div class="login-logo">
            <img src="<?php echo esc_url(plugins_url('../assets/img/s4e-logo.png', __FILE__)); ?>" alt="Logo" />
            <span class="s4e-text">S4E</span>
        </div>

        <!-- Token Input Field -->
        <div>
            <label for="s4e-api-token">Enter API Token</label>
            <input type="text" id="s4e-api-token" placeholder="API Token">
        </div>

        <!-- Verify Button -->
        <div>
            <button id="s4e-verify-button"
                style="padding: 12px 24px; background-color: #0C7DC1; color: white; border: none; border-radius: 8px; cursor: pointer; font-size: 14px;">
                Login
            </button>
        </div>

        <!-- Help Link -->
        <div class="s4e-help-link-div">
            <a href="https://app.s4e.io/api-token" class="s4e-help-link" target="_blank">Do you need any help?</a>
        </div>


        <div id="s4e-login-feedback" style="margin-top: 20px; color: red; font-size: 14px;"></div>
        <!-- Error messages if token is invalid -->
    </div>
    <?php
    return ob_get_clean();
}
?>