<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Hook for AJAX requests (both logged-in and logged-out users)
add_action('wp_ajax_s4esec_create_security_file', 's4esec_create_security_file');
add_action('wp_ajax_nopriv_s4esec_create_security_file', 's4esec_create_security_file');

function s4esec_create_security_file()
{
    // Verify nonce
    if (!isset($_POST['nonce'])) {
        wp_send_json_error('Missing security token.');
        wp_die();
    }
    
    $nonce = sanitize_text_field(wp_unslash($_POST['nonce']));
    if (!wp_verify_nonce($nonce, 's4esec_nonce')) {
        wp_send_json_error('Invalid security token.');
        wp_die();
    }

    // Check if the required POST parameters are set
    if (isset($_POST['domain']) && isset($_POST['verify_text'])) {
        $domain = sanitize_text_field(wp_unslash($_POST['domain']));
        $verify_text = sanitize_text_field(wp_unslash($_POST['verify_text']));

        // Construct the file path using ABSPATH to ensure it goes to the root of the WordPress installation
        $file_path = ABSPATH . 'security.txt';

        // Prepare the content for the security.txt file
        $file_content = "# {$domain} Vulnerability Disclosure
Contact: https://srs.s4e.io/{$domain}/report
Acknowledgments: https://srs.s4e.io/{$domain}
Preferred-Languages: en
#s4e-verify-token: {$verify_text}";

        // Write the content to the file. This will overwrite the file if it already exists.
        if (file_put_contents($file_path, $file_content) !== false) {
            // Construct the URL where the file can be accessed
            $site_url = site_url('/security.txt');

            // Return success response with the URL of the file
            wp_send_json_success(array(
                'message' => 'security.txt file created or updated successfully.',
                'url' => $site_url
            ));
        } else {
            // Return error response if file creation fails
            wp_send_json_error('Failed to create or update the security.txt file.');
        }
    } else {
        // Return error response if parameters are missing
        wp_send_json_error('Missing required parameters.');
    }

    // Always die in functions hooked to AJAX
    wp_die();
}

// Hook for AJAX requests (both logged-in and logged-out users)
add_action('wp_ajax_s4esec_create_verify_file', 's4esec_create_verify_file');
add_action('wp_ajax_nopriv_s4esec_create_verify_file', 's4esec_create_verify_file');

function s4esec_create_verify_file()
{
    // Verify nonce
    if (!isset($_POST['nonce'])) {
        wp_send_json_error('Missing security token.');
        wp_die();
    }
    
    $nonce = sanitize_text_field(wp_unslash($_POST['nonce']));
    if (!wp_verify_nonce($nonce, 's4esec_nonce')) {
        wp_send_json_error('Invalid security token.');
        wp_die();
    }

    // Check if the required POST parameters 'verify_file' and 'verify_text' are set
    if (isset($_POST['verify_file']) && isset($_POST['verify_text'])) {
        $verify_file_name = sanitize_text_field(wp_unslash($_POST['verify_file']));
        $verify_text = sanitize_text_field(wp_unslash($_POST['verify_text']));

        // Validate that the file name is safe and does not contain invalid characters
        if (preg_match('/^[a-zA-Z0-9_-]+$/', $verify_file_name)) {
            // Construct the file path using ABSPATH to ensure it goes to the root of the WordPress installation
            $file_path = ABSPATH . $verify_file_name . '.html';

            // Prepare the content for the HTML file (using the verify_text as the content)
            $file_content = $verify_text;

            // Write the content to the file. This will overwrite the file if it already exists.
            if (file_put_contents($file_path, $file_content) !== false) {
                // Construct the URL where the file can be accessed
                $site_url = site_url('/' . $verify_file_name . '.html');

                // Return success response with the URL of the file
                wp_send_json_success(array(
                    'message' => $verify_file_name . '.html created or updated successfully.',
                    'file_url' => $site_url
                ));
            } else {
                // Return error response if file creation fails
                wp_send_json_error('Failed to create or update the file: ' . $verify_file_name . '.html');
            }
        } else {
            // Return error response if the file name contains invalid characters
            wp_send_json_error('Invalid file name. Only alphanumeric characters, hyphens, and underscores are allowed.');
        }
    } else {
        // Return error response if parameters are missing
        wp_send_json_error('Missing required parameters: verify_file and/or verify_text.');
    }

    // Always die in functions hooked to AJAX
    wp_die();
}
