<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function s4esec_display_start_scan_options()
{
    ob_start();
    ?>
    <div id="start-scan-options" style="text-align: center; padding: 15px;">
        <div style="display: flex; justify-content: flex-start; margin-bottom: 10px;">
            <button id="back-to-scans" class="back-button">
                &#9664; Back
            </button>
        </div>
        <h2 style="font-weight: bold; font-size: 1.5em;">Start a New Scan</h2>
        <p style="margin-bottom: 15px; font-size: 0.9em;">You can start your scanning process by choosing one of the
            scanning options below.</p>

        <div style="display: grid; gap: 25px; justify-items: center; max-width: 900px; margin: 0 auto; padding: 0 20px;">
            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 30px; padding-top: 30px;">
                <!-- Full Scan -->
                <div class="scan-option" id="start-full-scan" style="padding: 30px 25px;">
                    <h3>Full Scan</h3>
                    <p style="font-size: 0.85em; margin: 15px 0 0 0; line-height: 1.5;">
                        Conducts a comprehensive security check on your verified assets. This scan thoroughly examines all aspects of your systems to identify and report any potential security vulnerabilities including OWASP top 10 at one time.
                    </p>
                </div>

                <!-- Light Scan -->
                <div class="scan-option" id="start-light-scan" style="padding: 30px 25px;">
                    <h3>Light Scan</h3>
                    <p style="font-size: 0.85em; margin: 15px 0 0 0; line-height: 1.5;">
                        Performs a quick and limited security check on your verified assets. This scan provides rapid insights into any immediate security issues without the depth of a full scan.
                    </p>
                </div>

                <!-- Single Scan -->
                <div class="scan-option" id="start-single-scan" style="padding: 30px 25px;"
                    onclick="window.open('https://app.s4e.io/scans/tools', '_blank');">
                    <h3>Single Scan</h3>
                    <p style="font-size: 0.85em; margin: 15px 0 0 0; line-height: 1.5;">
                        Allows you to initiate a targeted scan for a specific URL, IP, or domain. This user-initiated scan utilizes thousands of tools to identify potential vulnerabilities.
                    </p>
                </div>

                <!-- Crawler -->
                <div class="scan-option" id="start-crawler-scan" style="padding: 30px 25px;">
                    <h3>Crawler</h3>
                    <p style="font-size: 0.85em; margin: 15px 0 0 0; line-height: 1.5;">
                        Uses AI-powered web crawlers to find and list all visible URLs and user input fields on your website. This scan does not identify vulnerabilities but maps out your web structure.
                    </p>
                </div>
            </div>

        </div>
    </div>
    <?php
    return ob_get_clean();
}
?>