<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function s4esec_display_scans_tab()
{
    ob_start(); ?>
    <div id="s4e-scans-tab-content">

        <!-- Severity Summary UI -->
        <div style="display: flex; justify-content: space-between; margin-bottom: 20px;">
            <div style="text-align: center; flex: 1; margin-right: 10px;">
                <div style="background: rgba(2, 136, 209, 0.2); padding: 20px; border-radius: 8px;">
                    <span class="severity-chip-count" id="severity-info-count"
                        style="font-size: 25px; font-weight: 500; color: #212529;">0</span>
                </div>
                <div class="severity-chip-title" style="margin-top: 10px; font-weight: 500; color: #212529;">Information
                </div>
            </div>
            <div style="text-align: center; flex: 1; margin: 0 10px;">
                <div style="background: rgba(67, 160, 71, 0.2); padding: 20px; border-radius: 8px;">
                    <span class="severity-chip-count" id="severity-low-count"
                        style="font-size: 25px; font-weight: 500; color: #212529;">0</span>
                </div>
                <div class="severity-chip-title" style="margin-top: 10px; font-weight: 500; color: #212529;">Low</div>
            </div>
            <div style="text-align: center; flex: 1; margin: 0 10px;">
                <div style="background: rgba(229, 57, 53, 0.2); padding: 20px; border-radius: 8px;">
                    <span class="severity-chip-count" id="severity-medium-count"
                        style="font-size: 25px; font-weight: 500; color: #212529;">0</span>
                </div>
                <div class="severity-chip-title" style="margin-top: 10px; font-weight: 500; color: #212529;">Medium</div>
            </div>
            <div style="text-align: center; flex: 1; margin: 0 10px;">
                <div class="severity-chip-high">
                    <span class="severity-chip-count" id="severity-high-count"
                        style="font-size: 25px; font-weight: 500; color: #212529;">0</span>
                </div>
                <div class="severity-chip-title" style="margin-top: 10px; font-weight: 500; color: #212529;">High</div>
            </div>
            <div style="text-align: center; flex: 1; margin-left: 10px;">
                <div style="background: rgba(142, 36, 170, 0.2); padding: 20px; border-radius: 8px;">
                    <span class="severity-chip-count" id="severity-critical-count"
                        style="font-size: 25px; font-weight: 500; color: #212529;">0</span>
                </div>
                <div class="severity-chip-title" style="margin-top: 10px; font-weight: 500; color: #212529;">Critical</div>
            </div>
        </div>

        <!-- Search Bar for Scans with Tooltip -->
        <div class="search-bar-container">
            <input type="text" id="scan-search" placeholder="Search Scans" class="search-input">

            <!-- Tooltip Icon -->
            <div class="icon-container" aria-label="You can search by asset or scan name">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true"
                    role="img" class="MuiBox-root css-1t9pz9x iconify iconify--fluent" width="1em" height="1em"
                    viewBox="0 0 28 28">
                    <path fill="currentColor"
                        d="M15 8a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-1.75 3.75v7.5a.75.75 0 0 0 1.5 0v-7.5a.75.75 0 0 0-1.5 0M2 14C2 7.373 7.373 2 14 2s12 5.373 12 12s-5.373 12-12 12S2 20.627 2 14M14 3.5C8.201 3.5 3.5 8.201 3.5 14S8.201 25.5 14 25.5S25.5 19.799 25.5 14S19.799 3.5 14 3.5">
                    </path>
                </svg>
            </div>

            <!-- Tooltip Text -->
            <div class="tooltip-text">
                You can search by asset or scan name
            </div>
        </div>


        <!-- Table Structure for Scans -->
        <div class="wraper-s4e-table">
            <table class="s4e-table">
                <thead>
                    <tr class="header-row">
                        <th>Target</th>
                        <th>Name</th>
                        <th style="text-align: center;">Severity</th>
                        <th style="text-align: center;">Source</th>
                        <th style="text-align: center;">Status</th>
                        <th style="text-align: center;">Last Detected</th>
                    </tr>
                </thead>
                <tbody id="scan-table-body">
                    <!-- Placeholder for loading -->
                    <?php for ($i = 0; $i < 5; $i++): ?>
                        <tr class="skeleton-row">
                            <td colspan="6" style="padding: 15px;">
                                <div class="skeleton-loader"></div>
                            </td>
                        </tr>
                    <?php endfor; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination Controls -->
        <div style="display: flex; justify-content: space-between; align-items: center; margin-top: 20px;">
            <div style="display: flex;
    
    justify-content: space-between;
    gap: 10px;">
                <label for="rows-per-page-scans">Rows per page: </label>
                <div class="custom-select-wrapper">
                    <select id="rows-per-page-scans" class="custom-select">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="20">20</option>
                    </select>
                    <svg class="custom-select-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                        <path d="M6 9L12 15L18 9" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </div>
            </div>
            <div id="pagination-controls" style="display: flex; align-items: center; gap: 10px;">
                <button id="prev-scans"
                    style="padding: 5px; background-color: transparent; color: #1a4466; border: none; border-radius: 50%; cursor: pointer;"
                    disabled>
                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </button>
                <span id="page-info-scans" style="margin: 0 10px; font-size: 14px;">0-0 of 0</span>
                <button id="next-scans"
                    style="padding: 5px; background-color: transparent; color: #1a4466; border: none; border-radius: 50%; cursor: pointer;"
                    disabled>
                    <svg width="25" height="25" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Container for Start Scan Options -->
    <div id="s4e-start-scan-options" style="display: none;"></div>
    <!-- Container for Scan Content -->
    <div id="s4e-full-scan-content" style="display: none;"></div>
    <div id="s4e-light-scan-content" style="display: none;"></div>
    <div id="s4e-start-crawler-content" style="display: none;"></div>
    <?php
    return ob_get_clean();
}
?>