<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function s4esec_display_full_scan_form()
{
    ob_start();
    ?>
    <div id="s4e-full-scan-form" style="text-align: center; padding: 15px;">
        <div style="display: flex; justify-content: flex-start; margin-bottom: 10px;">
            <button id="s4e-back-to-start-scan-options" class="back-button">
                &#9664; Back
            </button>
        </div>
        <h2 style="font-weight: bold;">Full Scan</h2>

        <!-- Message container -->
        <div id="full-scan-message" style="display:none;"></div>

        <!-- Full Scan Asset Selection Field -->
        <?php
        $parsed_url = parse_url(get_option('siteurl'));
        $trimmed_site_url = $parsed_url['host'];
        ?>
        <input type="text" id="s4e-full-scan-asset-input"
            value="<?php echo esc_attr($trimmed_site_url); ?>"
            placeholder="Select Your Asset"
            style="width: 85%; padding: 10px; border-radius: 4px; border: 1px solid #ddd; margin-bottom: 20px;" disabled />

        <div style="text-align: left; margin: 20px 0;">
            <h3 style="font-weight: bold; display: flex;
                flex-wrap: wrap;
                justify-content: space-between;
                max-width: 85%; 
                margin: auto;
                font-size: 18px;
                margin-bottom: 20px;">
                Configure your full scan.
            </h3>
            <div id="s4e-full-scan-options"
                style="display: flex; flex-wrap: wrap; justify-content: space-between; max-width: 85%; margin: auto;">
                <!-- Checkboxes will be dynamically inserted here -->
            </div>
        </div>

        <button id="s4e-start-full-scan"
            style="padding: 10px; background-color: #1a73e8; color: white; border: none; border-radius: 4px; cursor: pointer;">
            Start Full Scan
        </button>
    </div>
    <?php
    return ob_get_clean();
}
?>