<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function s4esec_display_crawler_scan_form()
{
    ob_start();
    ?>
    <div id="s4e-crawler-scan-form" style="text-align: center; padding: 15px;">
        <div style="display: flex; justify-content: flex-start; margin-bottom: 10px;">
            <button id="s4e-back-to-start-scan-options" class="back-button">
                &#9664; Back
            </button>
        </div>
        <h2 style="font-weight: bold;">Crawler Scan</h2>

        <!-- Message container -->
        <div id="crawler-scan-message" style="display:none;">
            <button id="s4e-notification-close-btn"
                style="background:none; border:none; font-size:16px; cursor:pointer;">&times;</button>
        </div>

        <!-- Asset Selection Field -->
        <?php
        $parsed_url = parse_url(get_option('siteurl'));
        $trimmed_site_url = $parsed_url['host'];
        ?>
        <input type="text" id="s4e-crawler-scan-asset-input"
            value="<?php echo esc_attr($trimmed_site_url); ?>"
            placeholder="Select Your Asset"
            style="width: 80%; padding: 10px; border-radius: 4px; border: 1px solid #ddd; margin-bottom: 20px;" disabled />

        <!-- Removed the category checkboxes section -->

        <button id="s4e-start-crawler-scan"
            style="padding: 10px; background-color: #1a73e8; color: white; border: none; border-radius: 4px; cursor: pointer;">
            Start Crawler Scan
        </button>
    </div>
    <?php
    return ob_get_clean();
}
?>