function initializeCrawlerScan() {
  jQuery(document).ready(function ($) {
    // Hard-coded category slugs and slug for Crawler Scan
    const fixedCategorySlugs = ["dns-controls"];
    const scanSlug = "crawl-only";

    // Handle Start Crawler Scan button click
    $("#s4e-crawler-scan-form").on(
      "click",
      "#s4e-start-crawler-scan",
      function () {
        const assetName = $("#s4e-crawler-scan-asset-input").val().trim();

        // Remove http:// or https:// from the start of the asset name
        const trimmedAssetName = assetName.replace(/^https?:\/\//, "");
        if (!trimmedAssetName) {
          console.log("Please select an asset.");
          return;
        }

        // Prepare the data for the AJAX request
        const apiToken = localStorage.getItem("s4esec_api_token");
        if (!apiToken) {
          console.log("No API token found. Please log in again.");
          return;
        }

        // Clear previous messages
        displayError("");
        displaySuccess("");

        // Show spinner on the button
        showButtonLoader(true, "#s4e-start-crawler-scan");

        // Since category_slugs are fixed, use the fixedCategorySlugs array
        $.ajax({
          url: s4esec_ajax_object.ajax_url,
          type: "POST",
          data: {
            action: "s4esec_handle_scan",
            scan_type: "start_group_scan",
            api_token: apiToken,
            asset: trimmedAssetName,
            category_slugs: JSON.stringify(fixedCategorySlugs),
            slug: scanSlug,
            nonce: s4esec_ajax_object.nonce,
          },
          success: function (response) {
            if (response.success) {
              let responseData;
              try {
                responseData = JSON.parse(response.data);
              } catch (e) {
                console.error("Error parsing response data:", e);
                displayError("Unable to parse response data.");
                return;
              }

              if (responseData.code === 200) {
                console.log("going to fetch data");
                fetchAndSetScanActivitesAssestUrl(
                  trimmedAssetName,
                  CRAWLER_SCAN
                ).then((updatedURL) => {
                  displaySuccess("Crawler scan started successfully.");
                  $("#crawler-scan-message").append(
                    `<a href="${updatedURL}" target="_blank"> View Scan Status</a>`
                  );
                  showButtonLoader(false, "#s4e-start-crawler-scan");
                });
              } else {
                displayError(responseData.message || "Unknown error.");
                showButtonLoader(false, "#s4e-start-crawler-scan");
              }
            } else {
              displayError(response.data.message || "Unknown error.");
              showButtonLoader(false, "#s4e-start-crawler-scan");
            }
          },
          error: function (error) {
            // Hide spinner
            displayError("Unable to initiate the crawler scan at this time.");
            showButtonLoader(false, "#s4e-start-crawler-scan");
          },
        });
      }
    );

    // Function to display error messages
    function displayError(message) {
      const messageContainer = $("#crawler-scan-message");

      if (message) {
        // Add the close button dynamically with the message
        const closeButton =
          '<button id="s4e-crawler-notification-close-btn" style="background:none; border:none; font-size:16px; cursor:pointer; position:absolute; top:0px; right:10px;">&times;</button>';
        const fullMessage = `${closeButton}<span>${message}</span>`;

        // Set the message, add the close button, and show the message container with the appropriate class
        messageContainer
          .html(fullMessage)
          .css("position", "relative") // Ensure container positioning for the close button
          .removeClass("notification-box-success") // Ensure no conflicting success class
          .addClass("notification-box-error") // Add error class
          .show();

        // Attach click handler to the close button to hide the message container
        $("#s4e-crawler-notification-close-btn").on("click", function () {
          messageContainer.hide();
        });

        // Automatically hide the message after 6 seconds
        setTimeout(() => {
          messageContainer.fadeOut();
        }, 6000);
      } else {
        // Hide the message container if no message is provided
        messageContainer.hide();
      }
    }

    // Function to display success messages
    function displaySuccess(message) {
      const messageContainer = $("#crawler-scan-message");

      if (message) {
        // Add the close button dynamically with the message
        const closeButton =
          '<button id="s4e-crawler-notification-close-btn" style="background:none; border:none; font-size:16px; cursor:pointer; position:absolute; top:5px; right:10px;">&times;</button>';
        const fullMessage = `${closeButton}<span>${message}</span>`;

        // Set the message, add the close button, and apply the success class
        messageContainer
          .html(fullMessage)
          .css("position", "relative") // Ensure container positioning for the close button
          .removeClass("notification-box-error") // Ensure no conflicting error class
          .addClass("notification-box-success") // Add success class
          .show();

        // Attach click handler to the close button to hide the message container
        $("#s4e-crawler-notification-close-btn").on("click", function () {
          messageContainer.hide();
        });

        // Automatically hide the success message after 6 seconds
        setTimeout(() => {
          messageContainer.fadeOut();
        }, 6000);
      } else {
        // Hide the container if no message is provided
        messageContainer.hide();
      }
    }

    // Back button in Crawler Scan form
    $(document).on("click", "#s4e-back-to-start-scan-options", function () {
      $("#s4e-start-crawler-content").hide();
      $("#s4e-start-scan-options").show();
    });
  });
}
