jQuery(document).ready(function ($) {
  // Function to apply the theme based on the preference
  function applyTheme(theme) {
    if (theme === "dark") {
      $("#s4e-main-container").attr("data-bs-theme", "dark"); // Set dark theme
      $("#theme-toggle-checkbox").prop("checked", true); // Check the toggle
    } else {
      $("#s4e-main-container").attr("data-bs-theme", "light"); // Set light theme
      $("#theme-toggle-checkbox").prop("checked", false); // Uncheck the toggle
    }
  }

  // Function to detect the browser's default theme
  function detectPreferredTheme() {
    if (
      window.matchMedia &&
      window.matchMedia("(prefers-color-scheme: dark)").matches
    ) {
      return "dark";
    } else {
      return "light";
    }
  }

  // Check localStorage for saved theme preference
  const savedTheme = localStorage.getItem("theme");
  if (savedTheme) {
    applyTheme(savedTheme); // Apply the user's saved theme if it exists
  } else {
    const preferredTheme = detectPreferredTheme(); // Detect system/browser default theme
    applyTheme(preferredTheme); // Apply the browser's default theme if no saved theme
  }

  // Tab switching functionality
  $(".s4e-tab-button").click(function () {
    var tab = $(this).data("tab"); // Get the data-tab attribute of the clicked button

    // Remove active class from all buttons
    $(".s4e-tab-button").removeClass("active");
    // Add active class to the clicked button
    $(this).addClass("active");

    // Hide all tab content
    $(".s4e-tab-content").hide();
    // Show the content corresponding to the clicked tab
    $("#s4e-" + tab + "-tab").show();
    // Step 2: Show skeleton loaders for specific elements
    if (tab === "profile") {
      showSkeletonLoaderUserInfo();
      // Step 3: Fetch the latest data and populate user info
      fetchLatestData();
      initializeEventHandlers();
    }

    if (tab === "scans") {
      // show loader and hit api: get_severites and report list
    }
  });

  jQuery(document).ready(function () {
    // On clicking the close button, hide the notification with a fade-out effect
    $("#notification-close").on("click", function () {
      $("#notification-box").fadeOut(300, function () {
        $(this).remove(); // Remove from DOM after fade-out
      });
    });
  });

  // Theme toggle functionality
  $("#theme-toggle-checkbox").change(function () {
    const currentTheme = this.checked ? "dark" : "light";
    applyTheme(currentTheme); // Apply the selected theme
    localStorage.setItem("theme", currentTheme); // Save theme preference
  });
});
