jQuery(document).ready(function ($) {
  // Function to create and display the initial user info HTML
  // Function to create and display the initial user info HTML
  function displayUserInfo() {
    var userInfoHTML = `
            <div id="s4e-user-info-wrapper" class="user-info-wrapper">
                <div class="profile-icon-container">
                    <div class="profile-icon">
                        <i class="fas fa-user profile-icon-img"></i>
                    </div>
                    <div class="package-badge"></div> <!-- Placeholder for package -->
                </div>

                <h2 class="user-name"></h2> <!-- Placeholder for user name -->
                <p class="user-email"></p> <!-- Placeholder for email -->

                <div id="s4e-user-info-wrapper-buttons">
                    <button id="s4e-clear-token" class="logout-button">Logout</button>
                </div>
                <div id="s4e-asset-manager" class="user-info-wrapper">
                    <div class="s4e-asset-loader-box" id="s4e-asset-loader-box" style="display: none;">
                        <div class="s4e-asset-loader-spinner"></div>
                    </div>
                    <div class="asset-input-section">
                        <input type="text" id="new-asset-input" value="${s4eParams.site_url}" disabled>
                        <button class="asset-button-style" id ="verify-asset-button" style="display: none;">Verify Asset</button>
                        <button class="asset-button-style" id ="check-asset-button" style="display: none;">Add Asset</button>
                         <div id="asset-info-text" style="display:none;"></div>
                    </div>
                    <div id="verify-asset-popup-container"></div>
                     <div id="asset-check-error">
                     </div>
                </div>
            </div>
        `;
    // Inject the initial HTML into the container
    $("#s4e-user-info-container").html(userInfoHTML);
  }

  // Step 1: Display the initial HTML structure
  displayUserInfo();

  // Step 2: Show skeleton loaders for specific elements
  showSkeletonLoaderUserInfo();

  // Step 3: Fetch the latest data and populate user info
  fetchLatestData();

  // Logout functionality (unchanged)
  $("#s4e-user-info-container").on("click", "#s4e-clear-token", function () {
    showButtonLoader(true, "#s4e-clear-token");

    $.ajax({
      url: s4esec_ajax_object.ajax_url,
      type: "POST",
      data: {
        action: "s4esec_clear_token", // Correct AJAX action for clearing session
        nonce: s4esec_ajax_object.nonce,
      },
      success: function (response) {
        if (response.success) {
          localStorage.removeItem("s4esec_api_token");
          localStorage.removeItem("s4esec_user_info");
          localStorage.removeItem("s4esec_package_id");
          location.reload(); // Reload the page
        } else {
          console.log("Failed to log out. Please try again.");
        }
      },
      error: function (xhr, status, error) {
        console.log(error);
      },
      complete: function () {
        showButtonLoader(false, "#s4e-clear-token");
      },
    });
  });
});
