jQuery(document).ready(function ($) {
  // Handle "Start a New Scan" button click
  $("#s4e-main-container").on("click", "#start-new-scan", function () {
    $("#start-new-scan").hide();
    $.ajax({
      url: s4esec_ajax_object.ajax_url,
      type: "POST",
      data: {
        action: "s4esec_display_start_scan_options",
      },
      success: function (response) {
        // Hide the scans table and show the scan options
        $("#s4e-scans-tab-content").hide();
        $("#s4e-start-scan-options").html(response).show();
      },
      error: function () {
        console.log("Error loading scan options.");
      },
    });
  });

  // Handle "Back" button click to return to the scans tab
  $("#s4e-main-container").on("click", "#back-to-scans", function () {
    // Hide the scan options and show the scans table
    $("#s4e-start-scan-options").hide().html("");
    $("#s4e-scans-tab-content").show();
    $("#start-new-scan").show();

    // Re-initialize the scans data
    if (typeof loadScanResults === "function") {
      loadScanResults(); // Re-fetch scan results and populate the table
    }
  });
});
