jQuery(document).ready(function ($) {
  // Fetch severities data from the API
  function fetchSeverities() {
    const token = localStorage.getItem("s4esec_api_token");
    if (!token) {
      console.error("No API token found. Please log in again.");
      return;
    }

    $.ajax({
      url: s4esec_ajax_object.ajax_url,
      type: "POST",
      data: {
        action: "s4esec_handle_scan",
        scan_type: "get_severities",
        api_token: token,
        nonce: s4esec_ajax_object.nonce,
      },
      success: function (response) {
        if (response.success && response.data) {
          let parsedData;

          try {
            parsedData = JSON.parse(response.data);
          } catch (e) {
            console.error("Error parsing the response data:", e);
            return;
          }

          if (parsedData && parsedData.value) {
            const severities = parsedData.value;

            // Set default values
            let infoCount = 0;
            let lowCount = 0;

            // Iterate through severities to find and assign counts
            severities.forEach(function (severity) {
              switch (severity.severity) {
                case 1:
                  infoCount = severity.count;
                  break;
                case 2:
                  lowCount = severity.count;
                  break;
              }
            });

            // Update UI elements
            $("#severity-info-count").text("0");
            $("#severity-low-count").text(lowCount);
          } else {
            console.error(
              "Failed to fetch severities data:",
              parsedData.message
            );
          }
        } else {
          console.error("Failed to fetch severities data:", response.message);
        }
      },
      error: function (xhr, status, error) {
        console.error("Error fetching severities:", error);
      },
    });
  }

  // Call the function to fetch data on document ready
  // fetchSeverities();
});
