jQuery(document).ready(function ($) {
  $("#s4e-verify-button").click(function () {
    var token = $("#s4e-api-token").val();
    var $button = $("#s4e-verify-button");

    if (!token) {
      Swal.fire({
        icon: "error",
        title: "Oops...",
        text: "Please enter the API token.",
      });
      return;
    }

    // Show the loader with SweetAlert
    Swal.fire({
      title: "Verifying...",
      text: "Please wait while we verify your API token.",
      allowOutsideClick: false,
      didOpen: () => {
        Swal.showLoading();
      },
    });

    // Disable the button while the request is being processed
    $button
      .prop("disabled", true)
      .addClass("button-disabled")
      .html("Verifying...");

    // Make an AJAX call to verify the token
    $.ajax({
      url: s4esec_ajax_object.ajax_url,
      type: "POST",
      data: {
        action: "s4esec_handle_scan",
        scan_type: "user_info",
        api_token: token,
        nonce: s4esec_ajax_object.nonce,
      },
      timeout: 30000,
      success: function (response) {
        Swal.close();

        if (response.success) {
          var data = JSON.parse(response.data);
          if (data.code === 200) {
            var userInfo = data.value;

            // Store token and user info in localStorage
            localStorage.setItem("s4esec_api_token", token);
            localStorage.setItem("s4esec_user_info", JSON.stringify(userInfo));

            // Show success alert
            Swal.fire({
              icon: "success",
              title: "Login Successful!",
              text: "You have successfully logged in.",
              iconColor: "#4292D4",
              fontFamily: "inter",
              timer: 1000,
              showConfirmButton: false,
            }).then(() => {
              location.reload(); // Reload the page to reflect the login state
            });
          } else {
            // Show invalid token message
            Swal.fire({
              icon: "error",
              title: "Invalid Token",
              text: "The API token you entered is invalid. Please try again.",
            });
          }
        } else {
          // Show general error message
          Swal.fire({
            icon: "error",
            title: "Error",
            text: "There was an error. Please try again.",
          });
        }
      },
      error: function (xhr, status, error) {
        Swal.close(); // Close the loader

        // Show error message
        Swal.fire({
          icon: "error",
          title: "Error",
          text: "Please check your API Token: " + error,
        });
      },
      complete: function () {
        // Re-enable the button after request is completed
        $button
          .prop("disabled", false)
          .removeClass("button-disabled")
          .html("Login");
      },
    });
  });
});
