# S4E: Effortless & Continuous Cybersecurity

**Contributors:** s4ee  
**Tags:** cybersecurity, threat, detection, vulnerability, continuous
**Requires at least:** 5.8  
**Tested up to:** 6.8  
**Stable tag:** 1.0.0  
**Requires PHP:** 7.4  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html

Integrate S4E API with WordPress to provide comprehensive security scanning capabilities for your website.

## Description

S4E: Effortless & Continuous Cybersecurity is a powerful WordPress plugin that seamlessly integrates with the S4E scan API to provide comprehensive security scanning capabilities for your website. This plugin offers a user-friendly interface to trigger various types of security scans and view detailed reports.

### Key Features

* User-friendly interface with light/dark theme support
* Multiple scan types:
  * Full Scan
  * Light Scan
  * Single Scan
  * Crawler Scan
* Real-time scan progress tracking
* Detailed scan reports
* Secure API integration
* Responsive design

### How to Use

**Step 1: Create an S4E Account**
1. Visit [S4E Signup](https://app.s4e.io/sign-up) and create a free account
2. Verify your email address
3. Login to your S4E dashboard

**Step 2: Get Your API Token**
1. In your S4E dashboard, navigate to [API Token page](https://app.s4e.io/api-token)
2. Generate a new API token
3. Copy the token (you'll need this for the plugin)

**Step 3: Install and Configure the Plugin**
1. Install and activate the plugin in WordPress
2. The plugin will automatically create a new "S4E Security" menu item in your WordPress admin sidebar

**Step 4: Access the Plugin**
1. In your WordPress admin area, navigate to "S4E Security" in the sidebar menu
2. You'll see a login form where you can enter your S4E API token
3. Enter your S4E API token in the login field
4. Click "Login" - you'll be redirected to your profile dashboard

**Step 5: Add Your Asset for Auto-Verification**
1. In the Profile tab, you will see your WordPress site's domain automatically detected.
2. To enable auto-verification, add this asset to your S4E account by clicking "Add Asset".
3. After adding the asset, you will see a popup to choose a verification method. Both security.txt and HTML file methods are available for verification.
4. When you choose a verification method, a file will be automatically created in the root of your domain (e.g., wordpress.net/security.txt or wordpress.net/s4e-ft6PdLzawaNM.html).
5. Click the "Verify Asset" button to complete verification. For successful verification, the security.txt file must be accessible at your base domain (e.g., wordpress.net/security.txt).
6. Your asset will be verified automatically once the file is detected.

**Step 6: Start Your First Scan**
1. Go to the "Reports" tab
2. Click "Start a new scan"
3. Choose your scan type:
   - **Full Scan**: Comprehensive security analysis (recommended for first scan)
   - **Light Scan**: Quick security check
   - **Single Scan**: Redirects to S4E web interface for advanced scanning
   - **Crawler**: Maps your website structure
4. Click "Start Scan"

**Step 7: View Results**
1. Scan progress will be displayed in real-time with status updates.
2. Once every scan is completed, detailed reports will be available in the Reports tab.
3. Click on any report to view vulnerability details and remediation recommendations in the S4E web interface.

**Demo Credentials:**
For review purposes, you can contact S4E support at support@s4e.io for a demo token.

### Requirements

* WordPress 5.8 or higher
* PHP 7.4 or higher
* Active S4E account and API credentials

## Installation

### Automatic Installation

1. Login to your WordPress admin panel
2. Navigate to Plugins > Add New
3. Search for "S4E: Effortless & Continuous Cybersecurity"
4. Click "Install Now" and then "Activate"

### Manual Installation

1. Download the plugin zip file
2. Upload the plugin files to the `/wp-content/plugins/s4e` directory, or upload the zip file through the WordPress plugins screen (Plugins > Add New > Upload Plugin)
3. Activate the plugin through the 'Plugins' screen in WordPress

### After Installation

1. The plugin automatically adds a "S4E Security" menu item to your WordPress admin sidebar
2. Navigate to "S4E Security" in your WordPress admin area
3. You should see the S4E security scanning interface
4. Follow the "How to Use" section to set up your S4E account and start scanning

### Troubleshooting Installation

* **Plugin not displaying**: Make sure the plugin is activated and look for "S4E Security" in your WordPress admin sidebar
* **No admin menu**: Check that your user account has administrator privileges (manage_options capability)
* **Blank page**: Check if JavaScript is enabled in your browser and no JavaScript errors in browser console
* **Styling issues**: The plugin styles are isolated to the admin area and should not conflict with your theme
* **Login issues**: Verify your API token is correct and your S4E account is active

## Frequently Asked Questions

### Do I need an S4E account to use this plugin?

Yes, you need an active S4E account and API credentials to use this plugin. You can create a free account at [S4E.io](https://s4e.io).

### Is the S4E account free?

Yes, S4E offers free accounts with limited scanning capabilities. Paid plans are available for more advanced features and higher scan limits.

### What types of scans are available?

The plugin supports four types of scans:
* **Full Scan**: Comprehensive security analysis covering OWASP Top 10 vulnerabilities and advanced security checks
* **Light Scan**: Quick security check for immediate threats and common vulnerabilities
* **Single Scan**: Redirects to the S4E web interface for advanced scanning options and custom vulnerability tests
* **Crawler Scan**: Maps your website structure and finds all URLs and input fields without security testing

### How do I view scan results?

Scan results are displayed in the Reports tab of the plugin interface. You can access them after logging in with your S4E credentials. Results include vulnerability details and severity levels. Click on any report to view comprehensive details in the S4E web interface.

### How do I verify domain ownership?

After adding a domain in the Profile tab, you can choose from multiple verification methods. The plugin supports security.txt and HTML file verification methods. When you select a method, the verification file will be automatically created in the root of your domain (e.g., wordpress.net/security.txt or wordpress.net/s4e-ft6PdLzawaNM.html).

### Can I scan any domain or only my own?

You can only scan the domain where your WordPress site is hosted. The plugin automatically detects your WordPress site's domain and allows you to add it as a verified asset for scanning. You cannot scan external domains through this plugin. You can scan your other domains through the S4E web interface.

### What data does the plugin send to S4E?

The plugin sends your API token, domain information, and scan parameters to S4E's servers. No WordPress user data or content is transmitted. See the "External Services" section for full details.

### Is my scan data secure?

Yes, all communication with S4E servers is encrypted via HTTPS. Your scan results are stored securely and are only accessible through your authenticated account.

### What should I do if a scan fails?

If a scan fails, please check the following:
1. **Domain Verification**: Ensure your domain is properly verified with the security.txt or HTML file accessible at your base domain
2. **API Token**: Verify your API token is valid and not expired by checking your S4E dashboard
3. **Domain Accessibility**: Confirm your domain is accessible from the internet and not behind authentication
4. **Scan Credits**: Check that you have sufficient scan credits remaining in your S4E account
5. **Network Connectivity**: Ensure your server can make outbound HTTPS connections to api.s4e.io

## Screenshots

1. Login interface - login_interface.png
2. User profile section - profile.png
3. Scan results view - reports.png
4. Start scan interface - start_scan.png

## Changelog

### 1.0.0
* Initial release

## Upgrade Notice

### 1.0.0
Initial release of the plugin.

## External Services

This plugin connects to external services to provide security scanning capabilities. The following external services are used:

### S4E API (https://api.s4e.io/api)

**What the service is and what it is used for:**
The S4E API is a comprehensive security scanning service that provides vulnerability assessment and reporting capabilities for websites and web applications.

**What data is sent and when:**
- **API Token**: Sent with every request for authentication
- **User Information**: Sent when retrieving user profile and package information
- **Asset Information**: Sent when adding, checking ownership, or retrieving details about domains/URLs to be scanned
- **Scan Parameters**: Sent when initiating various types of security scans (Full Scan, Light Scan, Single Scan, Crawler Scan)
- **Scan History Requests**: Sent when retrieving scan history and reports
- **Activity Logs**: Sent when retrieving scan activity and progress information

**Service Provider Information:**
- **Service Provider**: S4E (Security 4 Everyone)
- **Terms of Service**: [https://s4e.io/terms-of-use](https://s4e.io/terms-of-use)
- **Privacy Policy**: [https://s4e.io/privacy-policy](https://s4e.io/privacy-policy)

### S4E SRS Service (https://srs.s4e.io)

**What the service is and what it is used for:**
The S4E SRS (security.txt Reporting Service) is used to generate security.txt files for domains, providing contact information for security researchers and vulnerability disclosure.

**What data is sent and when:**
- **Domain Information**: Sent when generating security.txt files for vulnerability disclosure

**Service Provider Information:**
- **Service Provider**: S4E (Security 4 Everyone)
- **Terms of Service**: [https://s4e.io/terms-of-use](https://s4e.io/terms-of-use)
- **Privacy Policy**: [https://s4e.io/privacy-policy](https://s4e.io/privacy-policy)

## Additional Information

For more information about S4E and its services, please visit [S4E.io](https://s4e.io)
