# RW WebP Converter Lite

![WordPress Plugin Version](https://img.shields.io/badge/Version-1.0.0-blue)
![WordPress](https://img.shields.io/badge/WordPress-6.6%2B-green)
![PHP](https://img.shields.io/badge/PHP-8.2%2B-purple)
![License](https://img.shields.io/badge/License-GPLv3%2B-orange)

A lightweight WordPress plugin that converts JPG and PNG images to WebP format in bulk and automatically converts newly uploaded images.

## ✨ Features

- 🔄 **Bulk Conversion** - Convert existing JPG and PNG images in your media library
- ⚡ **Automatic Processing** - Automatically convert newly uploaded images
- 🎛️ **Flexible Settings** - Enable/disable auto-conversion as needed
- 🚀 **Lightweight Design** - Minimal footprint, maximum performance
- 📊 **Media Library Integration** - Seamless WordPress integration

## 📋 Requirements

- WordPress 6.6 or higher
- PHP 8.2 or higher

## 🚀 Installation

### From WordPress Plugin Directory
1. Go to **Plugins → Add New** in your WordPress admin
2. Search for "RW WebP Converter Lite"
3. Click **Install Now** and activate the plugin

### Manual Installation
1. Download the plugin zip file
2. Go to **Plugins → Add New → Upload Plugin** in WordPress admin
3. Upload the zip file
4. Click **Install Now** and activate the plugin

## ⚙️ Configuration

After activation:
1. Go to **Tools → RW WebP Converter Lite**
2. Configure your conversion settings
3. Save changes

The plugin will now handle image conversion based on your preferences.

## ❓ Frequently Asked Questions

### Does this plugin replace my original images?
The plugin converts images to WebP format. Depending on your settings, original images may be kept alongside WebP versions for compatibility.

### Can I disable automatic conversion on upload?
Yes. Automatic image conversion can be enabled or disabled from the plugin settings page.

### Does this plugin support existing images?
Yes. You can bulk convert existing JPG and PNG images in the media library using the built-in conversion tool.

### Does the Lite version have limitations?
The Lite version includes core WebP conversion features. Additional advanced features may be available in the Pro version.

## 📸 Screenshots

1. **Plugin Settings Page** - Configure conversion options and preferences
2. **Bulk Conversion Interface** - Convert existing images in batches
3. **Media Library Status** - View WebP conversion status for each image

## 📝 Changelog

### 1.0.0
* Initial release with core WebP conversion features
* Bulk conversion tool for existing images
* Automatic conversion for new uploads
* Configurable settings page

## 🔗 Documentation

For detailed documentation including usage instructions for both Lite and Pro versions, visit:
[Full Documentation](https://docs.robertwp.com/rw-webp-converter-pro/)

## 💝 Support

If you find this plugin helpful, consider supporting its development:

[![Support on Ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/robertsouth)

## 👥 Contributing

Contributions are welcome! Please feel free to submit issues or pull requests on GitHub.

## 📄 License

This plugin is licensed under the [GPL v3 or later](https://www.gnu.org/licenses/gpl-3.0.html).

## 👤 Author

**Robert South**
- Website: [robertwp.com](https://robertwp.com)
- Ko-fi: [ko-fi.com/robertsouth](https://ko-fi.com/robertsouth)

---

*RW WebP Converter Lite - Optimize your images, accelerate your site*