<?php
/**
 * Plugin Name: RSS to Post Generator
 * Description: Generate blog posts from RSS feeds using AI content generation
 * Version: 1.1.3
 * Author: Samuel Bezerra Gomes
 * License: GPL v2 or later
 * Text Domain: rss-to-post-generator
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('RSS2POST_VERSION', '1.1.3');
define('RSS2POST_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('RSS2POST_PLUGIN_URL', plugin_dir_url(__FILE__));
define('RSS2POST_BACKEND_URL', 'https://rss2post.fly.dev'); // Update with your Fly.io URL

// Include required files
require_once RSS2POST_PLUGIN_DIR . 'includes/class-rss2post.php';
require_once RSS2POST_PLUGIN_DIR . 'includes/class-admin.php';
require_once RSS2POST_PLUGIN_DIR . 'includes/class-api.php';

// Initialize the plugin
if (!function_exists('rss2post_init')) {
    function rss2post_init() {
        new RSS2Post_Admin();
        new RSS2Post_API();
    }
}
add_action('plugins_loaded', 'rss2post_init');

// Activation hook
register_activation_hook(__FILE__, 'rss2post_activate');
if (!function_exists('rss2post_activate')) {
    function rss2post_activate() {
        $default_settings = array(
            'backend_url' => RSS2POST_BACKEND_URL,
            'api_timeout' => 180,
            'user_tier' => 'free', // Default to free tier
            'user_credits' => 10,   // Default credits for free tier
            'automated_posting_enabled' => false,
            'automated_rss_feeds' => array(),
            'last_processed_item_guids' => array(),
            'attach_images_automated' => true, // Default for automated image attachment
            'content_language' => 'en', // Default language
            'rss2post_cron_username' => '', // User should set these manually for security
            'rss2post_cron_app_password' => '',
            'convert_to_webp' => true, // Default to enable WebP conversion
            'user_openai_key' => '', // User's OpenAI API key for lifetime tier
            'user_pexels_key' => '' // User's Pexels API key for lifetime tier
        );
        
        $current_settings = get_option('rss2post_settings', array());
        
        // Merge default settings with current settings, giving precedence to current settings
        // This ensures existing settings are not overwritten, but new ones are added.
        $settings_to_save = wp_parse_args($current_settings, $default_settings);

        // Ensure specific defaults if they are critical and might be missing
        if (!isset($settings_to_save['user_tier'])) {
            $settings_to_save['user_tier'] = 'free';
        }
        if ($settings_to_save['user_tier'] === 'free' && (!isset($settings_to_save['user_credits']) || $settings_to_save['user_credits'] === 0)) {
            $settings_to_save['user_credits'] = 10;
        } elseif ($settings_to_save['user_tier'] === 'pro') {
            // Pro users might not use the 'user_credits' field in the same way, or it could be set to a high/infinite number
            // For now, let's ensure it exists but perhaps isn't strictly enforced like free tier.
            // Or, remove it if it's confusing for pro: unset($settings_to_save['user_credits']);
        } elseif ($settings_to_save['user_tier'] === 'lifetime') {
            // Lifetime users don't need credits - they have unlimited access with their own API keys
            unset($settings_to_save['user_credits']);
        }

        update_option('rss2post_settings', $settings_to_save);
    }
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'rss2post_deactivate');
function rss2post_deactivate() {
    // Cleanup if needed
}
?>
