<?php
if (!defined('ABSPATH')) {
    exit;
}

class RSS2Post {
    
    public static function get_backend_url() {
        $settings = get_option('rss2post_settings', array());
        return isset($settings['backend_url']) ? $settings['backend_url'] : RSS2POST_BACKEND_URL;
    }
    
    public static function log($message, $level = 'info') {
        if (WP_DEBUG && WP_DEBUG_LOG) {
            // No direct output to error_log to comply with WordPress standards.
            // Logging can be re-enabled with a dedicated logging library if needed.
        }
    }
    
    public static function sanitize_url($url) {
        return esc_url_raw($url);
    }
    
    public static function validate_rss_url($url) {
        if (!filter_var($url, FILTER_VALIDATE_URL)) {
            return false;
        }
        
        // Use fetch_feed to validate the RSS feed. This is more reliable than a simple HEAD request.
        $rss = fetch_feed($url);
        
        if (is_wp_error($rss)) {
            // Log the error for debugging purposes
            self::log("Failed to fetch RSS feed from {$url}: " . $rss->get_error_message(), 'warn');
            return false;
        }
        
        // Check if the feed has items. An empty feed is technically valid but not useful.
        return $rss->get_item_quantity() > 0;
    }
}
?>
