# RSS2Post

**Contributors:** samuelgomes
**Tags:** rss, feed, post generator, content, automation
**Requires at least:** 5.6
**Tested up to:** 6.8
**Stable tag:** 1.0.6
**License:** GPLv2 or later
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html

Automatically generate WordPress posts from RSS feeds with AI-powered content generation.

## Description

RSS to Post Generator allows you to automatically create WordPress posts from RSS feeds. The plugin fetches content from your specified RSS feeds and generates high-quality, unique posts that you can publish directly to your WordPress site.

### Key Features

*   Fetch and parse multiple RSS feeds
*   Generate unique content using AI
*   Automatic posting on a schedule
*   Support for featured images
*   Free and Pro tier options
*   Easy-to-use interface

### Pro Features

*   Unlimited article generation
*   Automated posting
*   Priority support
*   No credit limits

## Installation

### With Composer

1.  Navigate to your WordPress plugins directory: `cd wp-content/plugins`
2.  Clone the repository: `git clone https://github.com/your-username/rss2post.git`
3.  Navigate into the plugin directory: `cd rss2post`
4.  Install dependencies with Composer: `composer install`
5.  Activate the plugin through the 'Plugins' menu in WordPress.
6.  Go to the RSS to Post settings page to configure your feeds.

### Manual Installation

1.  Download the latest release from the [GitHub repository](https://github.com/your-username/rss2post/releases).
2.  Upload the `rss2post` folder to the `/wp-content/plugins/` directory.
3.  Activate the plugin through the 'Plugins' menu in WordPress.
4.  Go to the RSS to Post settings page to configure your feeds.

## Frequently Asked Questions

### How do I get started?

After activating the plugin, go to the RSS to Post settings page in your WordPress admin panel and follow the setup wizard.

### Is there a free version?

Yes, the plugin offers a free tier with limited features. You can upgrade to Pro for unlimited access to all features.

## To the WordPress Review Team:

Thank you for reviewing "RSS to Post Generator." We have developed this plugin to be fully compliant with the WordPress.org guidelines, particularly those concerning "Serviceware" (Guideline #6). Our goal is to be completely transparent about our plugin's functionality. This plugin is not Trialware; it does not lock or hide any of its own code. Instead, it serves as an interface to an external content generation service, and all code included in the plugin is GPL-compliant and human-readable.

Our plugin connects to our backend service at `https://rss2post.fly.dev`, which handles the AI-powered article generation. This service operates with a free tier that allows for a limited number of posts per month, while the Pro tier, available via a secure Stripe subscription, offers unlimited generation and additional features like automated posting. This "Serviceware" approach ensures that while the service has a paid component, the plugin itself adheres to the WordPress guidelines for code availability.

We are committed to user privacy and transparency. The plugin only communicates with our external service upon explicit user action. To publish posts, users must provide their WordPress username and an Application Password, which are used solely for that purpose. We have designed the plugin's interface to be non-intrusive and have ensured our public-facing pages are free of spam. We believe this model provides a valuable service while adhering to the letter and spirit of the WordPress guidelines.

## Screenshots

1.  Main plugin interface
2.  Feed configuration
3.  Article selection
4.  Settings page

## Changelog

### 1.0.6

*   **Implemented round-robin article distribution**: Automated posting now fairly distributes articles across all RSS feeds
*   Fixed issue where high-frequency feeds would dominate the posting queue
*   Articles are now selected in rotation: Feed1→Feed2→Feed3→Feed1→Feed2→Feed3, ensuring equal representation
*   Enhanced logging to show which feed each article comes from
*   Maximum 6 articles per automated run, distributed evenly across all configured feeds

### 1.0.5

*   **Fixed automated posting RSS feed sync bug**: Automated posting now correctly processes all RSS feed URLs, not just the first one
*   Added automatic RSS feed synchronization when feeds are modified while automation is enabled
*   Improved feed management with real-time updates to automated posting configuration
*   Enhanced logging for automated feed updates to help with debugging

### 1.0.4

*   Fixed Stripe payment redirect security issue
*   Replaced nonce-based validation with proper Stripe session verification
*   Improved payment flow reliability

### 1.0.3

*   Fixed WordPress.org review compliance issues
*   Upgraded Stripe PHP library to latest version
*   Enhanced security with proper nonce verification

### 1.0.2

*   WebP image conversion support
*   Enhanced Pexels integration

### 1.0.1

*   Bug fixes and improvements

### 1.0.0

*   Initial release

## Upgrade Notice

### 1.0.6

Critical update for users with multiple RSS feeds! Implements fair round-robin distribution so all feeds get equal representation in automated posting. If you have multiple feeds (e.g., politics, entertainment, sports), this ensures each feed gets posts, not just the most frequently updated one.

### 1.0.5

Important fix for automated posting: If you're using automated posting with multiple RSS feeds, this update ensures all feeds are processed, not just the first one. Update recommended for all Pro/Lifetime users using automation.

### 1.0.4

Critical fix for Stripe payment redirects.

### 1.0.0

Initial release of RSS2Post.
