<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.marcin-mrowiec.pl/
 * @since             1.0.0
 * @package           Rsrpp
 *
 * @wordpress-plugin
 * Plugin Name:       Really Simple Related Posts Plugin
 * Description:       Simple plugin to display related posts with shortcodes.
 * Version:           1.0.0
 * Author:            Marcin Mrowiec
 * Author URI:        https://www.marcin-mrowiec.pl/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       rsrpp
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'RSRPP_VERSION', '1.0.0' );
define('RSRPP_DIR', dirname(__FILE__));
/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-rsrpp-activator.php
 */
function activate_rsrpp() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-rsrpp-activator.php';
	Rsrpp_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-rsrpp-deactivator.php
 */
function deactivate_rsrpp() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-rsrpp-deactivator.php';
	Rsrpp_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_rsrpp' );
register_deactivation_hook( __FILE__, 'deactivate_rsrpp' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-rsrpp.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_rsrpp() {

	$plugin = new Rsrpp();
	$plugin->run();

}
run_rsrpp();
