<?php
/**
 * Robot-speed SEO Agent Uninstall
 *
 * Fired when the plugin is deleted (not deactivated).
 * Removes all plugin data from the database.
 *
 * @package RobotSpeed_SEO_Agent
 */

// If uninstall not called from WordPress, exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Remove all plugin options
delete_option( 'robotspeed_api_token' );
delete_option( 'robotspeed_connected' );
delete_option( 'robotspeed_connected_email' );
delete_option( 'robotspeed_connected_site' );
delete_option( 'robotspeed_connection_token' );
delete_option( 'robotspeed_stats' );

// Clean up any remaining rate limit transients
global $wpdb;
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
        $wpdb->esc_like( '_transient_robotspeed_rate_' ) . '%'
    )
);
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
        $wpdb->esc_like( '_transient_timeout_robotspeed_rate_' ) . '%'
    )
);
