(function($) {
    $(document).ready(function() {
        const { __ } = wp.i18n;
    	

        
        //////////////////////////////////////////////////////////////////////
        // Creation d'un compte Robonobo
        //////////////////////////////////////////////////////////////////////

        // Ouvrir le modal de creation de compte
        $(document).on('click', '#robonobo-create-account', function(e){
            e.preventDefault();
            setTimeout(function(){
                $('#robonobo-create-account-modal').fadeIn();
            }, 10);
        });

        // Fermer le modal de creation de compte
        $(document).on('click', '#robonobo-close-modal, .robonobo-modal-overlay', function() {
            $('#robonobo-create-account-modal').fadeOut(function() {
                window.onbeforeunload = null;
                location.reload(); // recharge la page pour que PHP regénère les settings fields
            });
        });

        // Soumission AJAX du formulaire de creation de compte
        $(document).on('submit', '#robonobo-create-account-form', function(e) {
            e.preventDefault();

            let pass = $(this).find('input[name="password"]').val();
            let pass2 = $(this).find('input[name="password_confirm"]').val();

            if (pass !== pass2) {
                jQuery('#robonobo-create-account-result').html(
                    `<div style="color:red;">${__( 'Les mots de passe ne correspondent pas.', 'robonobo-shipping' )}</div>`
                );
                return;
            }
            
            let apiLogin = "api" + new Date().getTime();
            let companyName = $(this).find('input[name="companyName"]').val();
            let companyAddress = $(this).find('input[name="companyAddress"]').val();

            var data = {
                action: 'robonobo_create_account',
                nonce: robonobo_settings_ajax.create_account_nonce,
                companyName: companyName,
                companyAddress: companyAddress,
                email: $(this).find('input[name="email"]').val(),
                password: pass,
                geoCoords: $(this).find('input[name="geoCoords"]').val(),
                street: $(this).find('input[name="street"]').val(),
                city: $(this).find('input[name="city"]').val(),
                postCode: $(this).find('input[name="postCode"]').val(),
                country: $(this).find('input[name="country"]').val(),
                apiLogin : apiLogin,
                apiKey: btoa(unescape(encodeURIComponent(apiLogin + ";" + companyName + ";" + companyAddress)))
            };

            $('#robonobo-create-account-result').html(__( 'Création en cours...', 'robonobo-shipping' ));

            $.post(robonobo_settings_ajax.ajax_url, data, function(response) {
                if(response.success) {
                    $('#robonobo-create-account-result').html('<span style="color:green;">' + response.data.message + '</span>');
                    $('#robonobo_company_name').val(response.data.values.companyName);
                    $('#robonobo_company_address').val(response.data.values.companyAddress);
                    $('#robonobo_login').val(response.data.values.login);
                    $('#robonobo_secret').val(response.data.values.password);
                    $('#robonobo_api_key').val(response.data.values.apiLKey);
                    $('#robonobo_api_secret').val(response.data.values.apiPassword);
                    $('#robonobo_webhook_password').val(response.data.values.webhookPassword);
                } else {
                    $('#robonobo-create-account-result').html('<span style="color:red;">' + response.data.message + '</span>');
                }
            });
            

            
            $(document).on('click', '.toggle-password', function () {
                const input = jQuery(this).prev('input');
                const type = input.attr('type') === 'password' ? 'text' : 'password';

                input.attr('type', type);

                // Alterner l’icône
                $(this).toggleClass('dashicons-visibility');
                $(this).toggleClass('dashicons-hidden');
            });
        });

        

        //////////////////////////////////////////////////////////////////////
        // Bouton de connexion au compte Robonobo Planner
        //////////////////////////////////////////////////////////////////////
        $('#robonobo-connection-account').on('click', function(){
            // Récupérer les valeurs des champs
            var companyName = $('#robonobo_company_name').val();
            var companyAddress = $('#robonobo_company_address').val();
            var login = $('#robonobo_login').val();
            var password = $('#robonobo_secret').val();

            // Créer la chaîne pour le token
            var tokenString = companyName + ';' + companyAddress + ';' + login + ';' + password;
            
            // Encoder en base64
            var tokenBase64 = btoa(unescape(encodeURIComponent(tokenString)));

            // Construire l'URL
            var url = 'https://www.robonoboplanner.fr/app.html#/login?token=' + tokenBase64;

            // Ouvrir dans un nouvel onglet
            window.open(url, '_blank');
        });
        
        
        
        
        //////////////////////////////////////////////////////////////////////
        // Bouton de test de connexion a l'api Robonobo Planner
        //////////////////////////////////////////////////////////////////////
        $('#robonobo-test-connection').on('click', function(e) {
            e.preventDefault();

            const $button = $(this);
            const $result = $('#robonobo-connection-result');
            const apiKey = $('#robonobo_api_key').val();
            const apiSecret = $('#robonobo_api_secret').val();

            // ⚠ Vérification des champs requis
            if (!apiKey || !apiSecret) {
                $result.html(`<span style="color:red;">❌ ${__( 'Merci de remplir la clé API et le mot de passe API.', 'robonobo-shipping' )}</span>`);
                return;
            }

            // Spinner + désactivation
            $button.prop('disabled', true).html(`${__( 'Connexion en cours...', 'robonobo-shipping' )} <span class="spinner is-active" style="float:none;margin:0;"></span>`);
            $result.html('');

            $.ajax({
                url: robonobo_settings_ajax.ajax_url,
                type: 'POST',
    			dataType: 'json',
                data: {
                    action: 'robonobo_test_connection',
                    _ajax_nonce: robonobo_settings_ajax.test_connection_nonce,
                    api_key: apiKey,
                    api_secret: apiSecret
                },
                success: function(response) {
                    if (response.success) {
                        $result.html('<span style="color: green;">✅ ' + response.data.message + '</span>');
                    } else {
                        $result.html('<span style="color: red;">❌ ' + response.data.message + '</span>');
                    }
                },
                error: function() {
                    $result.html(`<span style="color:red;">❌ ${__( 'Une erreur est survenue.', 'robonobo-shipping' )}</span>`);
                },
                complete: function() {
                    $button.prop('disabled', false).html(__( 'Tester la connexion', 'robonobo-shipping' ));
                }
            });
        });

        
        
        
        
        //////////////////////////////////////////////////////////////////////
        // Bouton de test du webhook
        //////////////////////////////////////////////////////////////////////
        $('#robonobo-test-webhook').on('click', function(e) {
            e.preventDefault();

            const $button = $(this);
            const $result = $('#robonobo-webhook-result');
            const apiKey = $('#robonobo_api_key').val();
            const apiSecret = $('#robonobo_api_secret').val();
            const webhookSecret = $('#robonobo_webhook_password').val();

            // ⚠ Vérification des champs requis
            if (!apiKey || !apiSecret) {
                $result.html(`<span style="color:red;">❌ ${__( 'Merci de remplir la clé API et le mot de passe API.', 'robonobo-shipping' )}</span>`);
                return;
            }
            if (!webhookSecret) {
                $result.html(`<span style="color:red;">❌ ${__( 'Merci de remplir le mot de passe du webhook. Il doit être identique à celui indiqué dans les paramètres de Robonobo Planner dans la section compte api / callback à côté du mot clé Bearer', 'robonobo-shipping' )}</span>`);
                return;
            }

            // Spinner + désactivation
            $button.prop('disabled', true).html(`${__( 'Connexion en cours...', 'robonobo-shipping' )} <span class="spinner is-active" style="float:none;margin:0;"></span>`);
            $result.html('');

            $.ajax({
                url: robonobo_settings_ajax.ajax_url,
                type: 'POST',
    			dataType: 'json',
                data: {
                    action: 'robonobo_test_webhook',
                    _ajax_nonce: robonobo_settings_ajax.test_webhook_nonce,
                    api_key: apiKey,
                    api_secret: apiSecret,
                    webhook_secret: webhookSecret
                },
                success: function(response) {
                    if (response.success) {
                        $result.html('<span style="color: green;">✅ ' + response.data.message + '</span>');
                    } else {
                        $result.html('<span style="color: red;">❌ ' + response.data.message + '</span>');
                    }
                },
                error: function() {
                    $result.html(`<span style="color:red;">❌ ${__( 'Une erreur est survenue.', 'robonobo-shipping' )}</span>`);
                },
                complete: function() {
                    $button.prop('disabled', false).html(__( 'Tester le webhook', 'robonobo-shipping' ));
                }
            });
        });
        
        
        
        
        
        
        
        
        

        //////////////////////////////////////////////////////////////////////
        // Ajout des icônes toggle password sur les champs du formulaire WooCommerce
        //////////////////////////////////////////////////////////////////////
        const passwordFields = [
            '#robonobo_secret',
            '#robonobo_api_secret',
            '#robonobo_webhook_password'
        ];

        passwordFields.forEach(function (selector) {
            const field = $(selector);

            if (field.length && !field.parent().hasClass('robonobo-password-wrapper')) {
                field.wrap('<div class="robonobo-password-wrapper robonobo-settings-inline"></div>');
                field.after('<span class="toggle-password dashicons dashicons-visibility"></span>');
            }
        });

        // Toggle show/hide
        $(document).on('click', '.toggle-password', function() {
            const input = $(this).prev('input');
            const type = input.attr('type') === 'password' ? 'text' : 'password';
            input.attr('type', type);

            // Change icon
            $(this).toggleClass('dashicons-visibility dashicons-hidden');
        });
        
        
        
        
        


        //////////////////////////////////////////////////////////////////////
        // Geocoding
        //////////////////////////////////////////////////////////////////////
        const $addressInput = $('input[name="companyAddress"]');
        const $geoInput = $('input[name="geoCoords"]');
        const $streetInput = $('input[name="street"]');
        const $cityInput = $('input[name="city"]');
        const $postCodeInput = $('input[name="postCode"]');
        const $countryInput = $('input[name="country"]');
        const $resultContainer = $('<ul class="robonobo-address-suggestions"></ul>').insertAfter($addressInput);

        let timeout = null;
        let lastResults = []; // stocke les dernières coordonnées proposées
        
        function fillHiddenGeoFields(geoItem) {
            const coords = geoItem.geometry.location;
            $geoInput.val(coords.lng + ':' + coords.lat);
        	
            let addressComponents = geoItem.address_components;
            let street = "";
        	let city = "";
        	let postCode = "";
        	let country = "";
        	
            if(undefined !== addressComponents) {
				for(var i=0; i<addressComponents.length; i++) {
					var ac = addressComponents[i];
					
					if(ac.types[0] === "street_number") {
						street = ac.long_name + " " + street;
					} else if(ac.types[0] === "route") {
						street += " " + ac.long_name;
					} else if(ac.types[0] === "locality") {
						city = ac.long_name;
					} else if(ac.types[0] === "postal_code") {
						postCode = ac.long_name;
					} else if(ac.types[0] === "country") {
						country = ac.short_name;
					}
				}
			}
            $streetInput.val(street);
            $cityInput.val(city);
            $postCodeInput.val(postCode);
            $countryInput.val(country);
        }

        $addressInput.on('input', function() {
            const query = $(this).val();
            clearTimeout(timeout);

            if (query.length < 3) {
                $resultContainer.empty().hide();
                lastResults = [];
                return;
            }

            timeout = setTimeout(() => {
                fetch(`https://maps.googleapis.com/maps/api/geocode/json?address=${encodeURIComponent(query)}&key=${robonobo_settings_ajax.googleMapsApiKey}`)
                    .then(response => response.json())
                    .then(data => {
                        $resultContainer.empty();
                        lastResults = [];

                        if (data.status === 'OK') {
                            lastResults = data.results;

                            data.results.slice(0, 5).forEach(result => {
                                const $item = $('<li class="robonobo-address-item"></li>');
                                $item.text(result.formatted_address);

                                $item.on('click', function() {
                                    $addressInput.val(result.formatted_address);
                                    fillHiddenGeoFields(result);
                                    $resultContainer.empty().hide();
                                });

                                $resultContainer.append($item);
                            });

                            $resultContainer.show();
                        } else {
                            $resultContainer.hide();
                        }
                    })
                    .catch(err => console.error(err));
            }, 300);
        });

        // Si clic en dehors → cacher
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.robonobo-form-field').length) {
                $resultContainer.hide();
            }
        });

        // Si l'utilisateur sort du champ sans cliquer → prendre la 1ère suggestion
        $addressInput.on('blur', function() {
            setTimeout(() => { // délai pour laisser le temps au clic sur suggestion
                if (lastResults.length > 0) {
                    fillHiddenGeoFields(lastResults[0]);
                }
            }, 200);
        });

        
        
        //////////////////////////////////////////////////////////////////////
        //Autocomplétion nom + adresse de société
        //////////////////////////////////////////////////////////////////////

        const $companyInput = $('#robonobo_company_name');
        const $companyAddressInput = $('#robonobo_company_address');

        const $companyResultContainer = $('<ul class="robonobo-company-suggestions"></ul>')
        		.insertAfter($companyInput);

        let companyTimeout = null;
        let lastCompanyResults = [];

        $companyInput.on('input', function () {

        	const query = $(this).val();
        	clearTimeout(companyTimeout);

        	if (query.length < 2) {
        		$companyResultContainer.empty().hide();
        		lastCompanyResults = [];
        		return;
        	}

        	companyTimeout = setTimeout(() => {

        		fetch('https://api.robonoboplanner.fr/api/customer/list')
        		.then(response => response.json())
        		.then(data => {

        		    $companyResultContainer.empty();
        		    lastCompanyResults = [];

        		    if (Array.isArray(data) && data.length > 0) {

        		        const lowerQuery = query.toLowerCase();

        		        const filteredResults = data.filter(company => {
        		            return company.name &&
        		                company.name.toLowerCase().includes(lowerQuery);
        		        });

        		        lastCompanyResults = filteredResults;

        		        filteredResults.slice(0, 5).forEach(company => {

        		            const $item = $('<li class="robonobo-company-item"></li>');
        		            $item.text(company.name + ' - ' + company.address);

        		            $item.on('click', function () {
        		                $companyInput.val(company.name);

        		                if (company.address) {
        		                    $companyAddressInput.val(company.address);
        		                }

        		                $companyResultContainer.empty().hide();
        		            });

        		            $companyResultContainer.append($item);
        		        });

        		        if (filteredResults.length > 0) {
        		            $companyResultContainer.show();
        		        } else {
        		            $companyResultContainer.hide();
        		        }

        		    } else {
        		        $companyResultContainer.hide();
        		    }
        		})
        		.catch(err => console.error(err));

        	}, 300);
        });

        //Clic hors du champ → cacher
        $(document).on('click', function (e) {
        	if (!$(e.target).closest('#robonobo_company_name, .robonobo-company-suggestions').length) {
        		$companyResultContainer.hide();
        	}
        });

        //Blur → prendre la première suggestion
        $companyInput.on('blur', function () {
        	setTimeout(() => {
        		if (lastCompanyResults.length > 0) {
        			const company = lastCompanyResults[0];
        			$companyInput.val(company.name);

        			if (company.address) {
        				$companyAddressInput.val(company.address);
        			}
        		}
        	}, 200);
        });

        
        
        
        
        
    });
})(jQuery);
