jQuery(document).ready(function ($) {
    const { __ } = wp.i18n;

    const container = $('#robonobo-weight-rates-ui');
    const input = $('<input type="hidden" id="robonobo_weight_rates" name="robonobo_weight_rates">');
    const nonce = $('<input type="hidden" name="robonobo_weight_rates_nonce" id="robonobo_weight_rates_nonce">').val(window.robonobo_weight_rates_nonce || '');

    container.after(input, nonce);

    let rates = window.robonobo_weight_rates;
    if (!Array.isArray(rates)) {
        rates = [{ min: 0, max: 50, price: 7 }];
    }

    function renderTable() {
        let html = `
            <table class="widefat">
                <thead>
                    <tr>
                        <th>${__( 'Poids min (kg)', 'robonobo-shipping' )}</th>
                        <th>${__( 'Poids max (kg)', 'robonobo-shipping' )}</th>
                        <th>${__( 'Tarif (€)', 'robonobo-shipping' )}</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
        `;

        if (rates) {
            rates.forEach((row, index) => {
                html += `
                    <tr>
                        <td><input type="number" step="0.01" class="min" value="${row.min}" /></td>
                        <td><input type="number" step="0.01" class="max" value="${row.max}" /></td>
                        <td><input type="number" step="0.01" class="price" value="${row.price}" /></td>
                        <td>
                            <button class="remove button" title="${__( 'Supprimer', 'robonobo-shipping' )}">
                                ✖
                            </button>
                        </td>
                    </tr>
                `;
            });
        }

        html += `
                </tbody>
            </table>
            <button class="add button">
                + ${__( 'Ajouter une tranche', 'robonobo-shipping' )}
            </button>
        `;

        container.html(html);
        input.val(JSON.stringify(rates));
    }

    container.on('click', '.add', function (e) {
        e.preventDefault();
        rates.push({ min: 0, max: 0, price: 0 });
        renderTable();
    });

    container.on('click', '.remove', function (e) {
        e.preventDefault();
        const index = $(this).closest('tr').index();
        rates.splice(index, 1);
        renderTable();
    });

    container.on('input', 'input', function () {
        const row = $(this).closest('tr').index();
        const field = $(this).attr('class');
        rates[row][field] = parseFloat($(this).val()) || 0;
        input.val(JSON.stringify(rates));
    });

    renderTable();
    
});

