<?php

namespace WBCR\Factory_Templates_134\Pages;

/**
 * Step
 *
 * @version 1.0
 */
class Step_Custom extends Step {

	public function get_title() {
		return 'Custom step';
	}

	public function render_button( $continue = true, $skip = false, $custom_title = null, $align = 'right' ) {
		$this->set_button_handler();
		$button_title = ! empty( $custom_title ) ? $custom_title : __( 'Continue', 'robin-image-optimizer' );

		if ( ! $this->get_next_id() ) {
			$button_title = __( 'Finish', 'robin-image-optimizer' );
		}

		if ( ! in_array( $align, [ 'center', 'left', 'right' ] ) ) {
			$align = 'right';
		}

		?>
		<form method="post" id="w-factory-templates-134__setup-form-<?php echo $this->get_id(); ?>" class="form-horizontal">
			<div class="w-factory-templates-134__form-buttons" style="text-align: <?php echo esc_attr( $align ); ?>">
				<?php if ( $skip ) : ?>
					<input type="submit" name="skip_button_<?php echo $this->get_id(); ?>" class="button-primary button button-large w-factory-templates-134__skip-button" value="<?php _e( 'Skip', 'robin-image-optimizer' ); ?>">
				<?php endif; ?>
				<?php if ( $continue ) : ?>
					<input type="submit" name="continue_button_<?php echo $this->get_id(); ?>" class="button-primary button button-large w-factory-templates-134__continue-button" value="<?php echo $button_title; ?>">
				<?php endif; ?>
			</div>
		</form>
		<?php
	}

	protected function set_button_handler() {
		if ( isset( $_POST[ 'continue_button_' . $this->get_id() ] ) ) {
			$this->continue_step();
		}

		if ( isset( $_POST[ 'skip_button_' . $this->get_id() ] ) ) {
			$this->skip_step();
		}
	}

	public function html() {
		// nothing
	}
}