<?php

	/**
	 * Dropdown List Control
	 *
	 * Main options:
	 *  name            => a name of the control
	 *  value           => a value to show in the control
	 *  default         => a default value of the control if the "value" option is not specified
	 *  items           => a callback to return items or an array of items to select
	 *
	 * @package core
	 * @since 1.0.0
	 */
class Wbcr_FactoryForms480_GoogleFontControl extends Wbcr_FactoryForms480_FontControl {

	public $type = 'google-font';
	const APIKEY = 'AIzaSyB-3vazYv7Q-5QZA04bmSKFrWcw_VhC40w';

	public function __construct( $options, $form, $provider = null ) {
		parent::__construct( $options, $form, $provider );
		$this->addCssClass( 'factory-font' );

		$option_google_font_data = [
			'name'     => $this->options['name'] . '__google_font_data',
			'cssClass' => 'factory-google-font-data',
		];

		$this->google_font_data = new Wbcr_FactoryForms480_HiddenControl( $option_google_font_data, $form, $provider );
		$this->inner_controls[] = $this->google_font_data;
	}

	/**
	 * @return array|mixed
	 */
	public function getDefaultFonts() {

		$cache_fonts = get_transient( 'wbcr_factory_google_fonts' );

		if ( ! empty( $cache_fonts ) ) {
			return $cache_fonts;
		}

		$google_fonts = $this->getGoogleFonts();

		$fonts = [
			[ 'inherit', '(' . __( 'Use default website font', 'robin-image-optimizer' ) . ')' ],
		];

		$fontsCommon = [
			'group',
			__( 'Standard:', 'robin-image-optimizer' ),
			[

				[ 'Arial, "Helvetica Neue", Helvetica, sans-serif', 'Arial' ],
				[ '"Helvetica Neue", Helvetica, Arial, sans-serif', 'Helvetica' ],
				[ 'Tahoma, Verdana, Segoe, sans-serif', 'Tahoma' ],
				[ 'Verdana, Geneva, sans-serif', 'Verdana' ],

			],
		];

		$fontsGoogleFonts = [ 'group', __( 'Google Fonts:', 'robin-image-optimizer' ), [] ];

		foreach ( $google_fonts->items as $item ) {

			$alt_font = $item->category;
			if ( in_array( $alt_font, [ 'handwriting', 'display' ] ) ) {
				$alt_font = 'serif';
			}

			$listItem = [
				'title' => $item->family,
				'value' => $item->family . ', ' . $item->category,
				'hint'  => '<em>Google Font</em>',
				'data'  => [
					'google-font' => true,
					'family'      => $item->family,
					'variants'    => $item->variants,
					'subsets'     => $item->subsets,
				],
			];

			$fontsGoogleFonts[2][] = $listItem;
		}

		$fonts[] = $fontsCommon;
		$fonts[] = $fontsGoogleFonts;

		set_transient( 'wbcr_factory_google_fonts', $fonts, 60 * 60 * 6 );

		return $fonts;
	}

	/**
	 * @return array|mixed|object
	 */
	protected function getGoogleFonts() {

		$body = get_transient( 'wbcr_factory_google_fonts_raw' );
		if ( ! empty( $body ) ) {
			return $body;
		}

		$response = wp_remote_get( sprintf( 'https://www.googleapis.com/webfonts/v1/webfonts?key=%s', self::APIKEY ) );

		$this->error          = false;
		$this->defailed_error = false;

		if ( is_wp_error( $response ) ) {

			$this->error          = __( 'Unable to retrieve the list of Google Fonts.', 'robin-image-optimizer' );
			$this->defailed_error = $response->get_error_message();

			return $body;
		}

		if ( ! isset( $response['body'] ) ) {

			$this->error          = __( 'Invalid response from the Google Fonts API.', 'robin-image-optimizer' );
			$this->defailed_error = $response['body'];

			return $body;
		}

		$body = json_decode( $response['body'] );

		if ( empty( $body->items ) ) {

			$this->error = __( 'Unexpected error. The list of Google Fonts is empty.', 'robin-image-optimizer' );

			return $body;
		}

		set_transient( 'wbcr_factory_google_fonts_raw', $body, 60 * 60 * 6 );

		return $body;
	}

	public function afterControlsHtml() {
		?>
		<?php $this->google_font_data->html(); ?>
		<?php
	}
}
