The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

= 3.7.22 - 7 Jan 2026 =
* Fixed : Create Revision link was displayed on Category Archive screen
* Fixed : Multisite - Super admins were unable to perform some revision management operations without an Administrator role on the site
* Compat : PublishPress Permissions - Revision approval was not allowed based on post-specific editing Permissions
* Compat : PublishPress Permissions - Option to prevent Submit Revision exceptions from implicitly enabling Revision creation
* Compat : PublishPress Permissions, Statuses - Permissions Pro activation caused revision creation to be allowed for all posts with a custom status
* Compat : Work around a conflict with corrupt "wpas" postmeta

= 3.7.21 - 17 Nov 2025 =
* Fixed : Recaption "New Revision" to "Create Revision" to disambiguate from "New Revisions"
* Fixed : Scheduled Revisions did not work correctly if "Site uses custom trigger" option is enabled
* Fixed : Scheduled Revision preview top bar did not have a distinct color
* Fixed : On multisite install, Network Defaults screen did not load correctly
* Fixed : On multisite install, Upgrade to Pro menu link loaded invalid settings screen
* Change : Option to disable revisioning of post Author
* Change : Option to autho-submit revisions without publishing capability
* Fixed : PHP Warning on Compare Revisions screen under some conditions
* Fixed : PHP Warnings on Edit Posts screen under some conditions

= 3.7.20 - 12 Nov 2025 =
* Change : Relabel Revision Queue as New Revisions
* Change : Relabel Revision Archive as Past Revisions
* Fixed : Fatal error on New Revisions screen for non-Administrators
* Fixed : Past Revisions screen could be viewed by users lacking the view_revision_archive capability
* Fixed : Classic Editor - Don't display Compare, View Saved Revision buttons until revision has been saved
* Fixed : A few strings were not translatable
* Lang: ES, FR, IT translations

= 3.7.19 - 30 Oct 2025 =
* Fixed : Post Editor - Captioning of New Revision / Schedule Revision button based on time selection did not factor in time zone difference
* Fixed : Revision Editor - When editing a revision that's already scheduled, Publish Now button was mislabeled as Schedule
* Fixed : Extra caption shown after clicking Submit / Approve Revision button
* Fixed : Pending Revisions metabox was displayed too low in Post Editor to be easily noticed
* Fixed : Pending Revisions metabox displayed "Requested publication" caption even if date is past
* Fixed : Javascript error on Revision Submission for undefined function "dispatch"
* Fixed : Revisions Settings - Visibility of Legacy Email options was not toggled correctly based on Legacy Email Notifications checkbox selection
* Fixed : Some post types were inappropriately enabled by default until Revision Settings are updated

= 3.7.18 - 9 Oct 2025 =
* Fixed : Revision editor did not redisplay submit, approve buttons after update
* Fixed : Submit Revision button did not work if Status, Schedule elements hidden by another plugin
* Compat : Advanced Custom Fields - Custom post type revisions could not be updated under some configurations

= 3.7.17 - 2 Oct 2025 =
* Fixed : Submit / Approve Revision button was disabled until page reload under some revision editing conditions
* Fixed : Classic Editor: Update Revision button changes to Save Draft after being clicked
* Compat : Revisions of Custom Posts cannot be updated under some conditions
* Compat : Rank Math SEO : Classic Editor - Update Revision button fails on first click
* Change : Disable Rank Math SEO by default for revision edit (can enable by Revisions > Settings > Options)
* Lang : ES, FR, IT translations

= 3.7.16 - 25 Sep 2025 =
* Fixed : Plugin defines DOING_CRON prior to publishing scheduled revisions
* Fixed : Revision metaboxes on Post edit screen output duplicate column label for Actions
* Fixed : Captioning of Approve / Schedule button based on time selection did not apply time zone offset correctly 
* Change : PublishPress Planner link on settings screen pops up plugin info / install screen
* Change : Use thickbox frame for PublishPress Planner install link on Settings screen
* Compat : PublishPress Permissions - list, list_other capabilities caused non-functional edit links to be displayed in Posts listing under some conditions
* Feature : Support manage_revision_queue capability
* Feature : Copy button for content on Compare Revisions screen

= 3.7.15 - 18 Sep 2025 =
* Compat : PublishPress Permissions - Non-revisions were listed in Revision Queue under some configurations
* Fixed : Edit link on Posts / Pages screen is suppressed on some sites
* Fixed : Admin notice for disabled WP Cron had invalid plugin settings link
* Change : Clarify admin notice text for disabled WP Cron
* Change : Support link directly to sub-tab of Revisions > Settings > New Revisions
* Fixed : Fatal error opening revision editor with WP versions older than 6.4
* Fixed : Revision editor hid submit, approve buttons immediately on some installations
* Feature : Support separate approval capabilities for Revisions
* Compat : PublishPress Capabilities - Capability tab for Approve Revision (also requires Capabilities 2.20.1)
* Fixed : Multisite - Error on Network Settings, Network Defaults screens
* Fixed : Multisite - Revision Queue empty if Permissions Compat mode setting is controlled network-wide 
* Fixed : Multisite - Compatibility Mode setting change left sub-site revisions with invalid post_status value
* Fixed : Multisite - Plugin setting tabs were blank until a tab is clicked

= 3.7.14 - 11 Sep 2025 =
* Fixed : New Revision button in editor did not work unless configured to open a new tab

= 3.7.13 - 9 Sep 2025 =
* Feature : Option for New Revision in editor to open a new tab
* Fixed : Misspelling in caption on Revisions > Settings
* Compat : Rank Math panel was not displayed when editing a revision
* Lang : Some plugin strings had wrong text domain

= 3.7.12 - 3 Sep 2025 =
* Fixed : Legacy Notifications could not be enabled if Revisions Pro is active without PublishPress Planner
* Change : Clarify tool tip text for revisions submitted for a future publication date
* Change : Re-order post type checkboxes in Revisions > Settings > Features

= 3.7.11 - 2 Sep 2025 =
* Fixed : Plugin checkboxes were all displayed as unchecked, and updating plugin settings caused unchecked selections to be stored

= 3.7.10 - 28 Aug 2025 =
* Compat : Rank Math SEO - Revision update failed under some conditions
* Change : Display a spinner during revision creation when editing a post in Classic Editor
* Change : Change Settings tab promos to text-based
* Change : Adjust some capability descriptions
* Change : Revision Edit - Ensure submit, approve buttons remain disabled after editor tab switch
* Change : Default-disable legacy notifications for new installations
* Change : Support extended Approve button captions in Post Editor
* Change : Revision Queue - tool tip to clarify revisions submitted for a future publication date, but not yet scheduled
* API : New function rvy_create_revision()

= 3.7.9 - 14 Aug 2025 =
* Compat : PublishPress Permissions - Permissions assigned directly to revisions were not applied (also requires Permissions 4.4.3)
* Compat : PublishPress Permissions - Option for Post Permissions to be applied to revisions (also requires Permissions 4.4.3)
* Fixed : Posts listing did not show Has Revision caption if Revisions compatibility mode set to Enhanced Revision access control
* Fixed : Revision metadata "_rvy_has_revisions" (and Has Revision caption) was not cleared after revision publication
* Compat : Multiple Authors - Revision Queue was incorrectly filtered on author queries
* Fixed : Some custom post types had non-functional edit links displayed to Revisors
* Change : Styling and content adjustments to Revisions > Settings > Integration tab
* Change : Right sidebar on Revisions > Settings was too wide
* Change : Display Pro Settings tabs last

= 3.7.8 - 31 Jul 2025 =
* Change : Improvements to Settings > Integration tab contents
* Change : Settings screen includes more descriptive contextual promo nudges for Pro plugin

= 3.7.7 - 29 Jul 2025 =
* Change : Settings > Integration tab detailing active or available third party plugin compatibility

= 3.7.6 - 24 Jul 2025 =
* Fixed : Scheduled Revisions publication failed if asynchronous setting enabled

= 3.7.5 - 21 Jul 2025 =
* Fixed : Scheduled Revision publication failed under some configurations
* Fixed : Revision Preview of Current Revision had an extra trailing bullet after Edit link
* Fixed : Unnecessary database queries on Edit Tags screen
* Change : Edit Revision - If revision submit / approve buttons are disabled, display explanatory tooltip
* Change : Edit Revision - Don't disable submission buttons prior to post save if Divi plugin is active

= 3.7.4 - 8 Jul 2025 =
* Compat : WooCommerce - Edit links on Products screen (and other Woo post types) were hidden under some conditions
* Compat : Various third party plugins - invalid data output on posts listing screen for custom post type

= 3.7.3 - 7 Jul 2025 =
* Compat : WooCommerce - Administrators and Editors did not have Edit links on Products screen
* Compat : CMS Tree Page View - JSON output on Page Tree View screen

= 3.7.2 - 3 Jul 2025 =
* Compat : Better support for custom post types registered as non-public
* Fixed : PHP Warnings on Edit Posts screen for Revisors and other roles which cannot edit published posts
* Change : Revisions > Settings > Compare tab removed, options moved to other tabs
* Change : wordpress-version-notices 2.1.4

= 3.7.1 - 23 Jun 2025 =
* Feature : Setting to control maximum Past Revisions per post
* Feature : Setting to disable Archive by post type
* Change : Improve styling of Features tab tool tips

= 3.7.0 - 19 Jun 2025 =
* Change : Rearranged Settings to highlight distinction between Past Revisions and New Revisions
* Change : Settings - Clarify captions for capability requirement settings
* Change : Settings - Improve mobile styling
* Change : Use new Capabilities plugin filter to show capability descriptions
* Change : Archive settings moved to a dedicated tab
* Change : Compare settings moved to a dedicated tab
* Change : Revision Creation, Submission and Scheduling settings combined onto a shared "New Revisions" tab
* Change : Post Editor - Remove "Preview Revision" button after revision creation
* Fixed : Revision Archive menu and screen were displayed to Subscribers

= 3.6.8 - 4 May 2025 =
* API : Improve support or Pro plugin's Planner Notifications integration

= 3.6.7 - 1 May 2025 =
* Fixed : Submit Revision button caption was missing for Revisors
* Feature : Revision Archive - option to archive past updates of Pending / Scheduled Revisions, even after publication
* Feature : Archive - Include action link "Edit Parent"
* Feature : Archive - "Edit Parent" tool tip provides context by specifying "Parent post" or "Parent revision"
* Change : Archive - Recaption "Method" to "Action"
* Change : Archive - Clarify Action captions for "Revision Publication" and "Scheduled Revision Publication"
* Change : Archive - For direct edits, show same user in Revised By and Approved By fields
* Change : Archive - Hide Count column, which is redundant in this context
* Fixed : Archive - Action caption for past updates of Submitted / Scheduled revisions: "Edit of Submitted Revision", etc.
* Fixed : Archive - Published Date was displayed for past updates of Submitted / Scheduled revisions even though the revision has not been published
* Fixed : Archive - Wrong publication date listed for direct edits
* Fixed : Archive - Wrong publication date displayed for published revisions under some conditions
* Fixed : Archive - Bulk deletion checkbox was displayed even if revision archive deletion is disabled 
* Compat : Prevent PHP Notice if another plugin calls wp_schedule_event() too early

= 3.6.6 - 15 Apr 2025 =
* Fixed : Updating a post caused post status to be cleared if some prior revisioning operations were performed. This may have only occurred on WPML sites.
* Fixed : Revision Preview showed "Approve" button if Revision is already scheduled
* Change : When editing a Revision, recaption "Approve" button to "Schedule" if a future date is selected
* API : Allow "Decline Revision" status to be filtered to a value other than draft-revision
* Change : Adjust implementation of "revisionary_unrevisioned_postmeta" filter to prevent third party code from accidentally forcing invalid fields back into comparison display

= 3.6.5 - unreleased =
* Pro : PublishPress Planner - default Notifications for Post creation / update were triggered by Revision creation / update
* Pro : PublishPress Planner - support Notification validation safeguards in Planner 4.7.2

= 3.6.4 - 18 Mar 2025 =
* Compat : PublishPress Planner 3.7.0 - Revisions Pro prevented Planner from creating its standard default Notification Workflows

= 3.6.3 - 14 Mar 2025 =
* Feature : Option to clear Plugin data on plugin deletion
* Fixed : After Revision creation in editor, Edit link goes to Queue
* Fixed : Revision bulk deletion failed with fatal error
* Fixed : Revision Queue - Database error with some third party plugins
* Change : Revisions > Settings - Minor changes and clarifications to captions on Revision, Queue, Preview tabs

= 3.6.2 - 24 Feb 2025 =
* Fixed : Revisions listed on main Posts / Pages screen under some configurations

= 3.6.1 - 20 Feb 2025 =
* Feature : Support view-only Revision Queue through 'preview_others_revisions' capability (Permissions plugin compatibility requires v4.1.2)
* Fixed : Previews of home page revisions did not display correctly
* Fixed : Compare Revisions: Slider movement did not reload comparison correctly
* Fixed : Revision Queue: Fatal error if Revision Submission was disabled in plugin settings 
* Fixed : Revision Queue: Revisors could not see own revisions in queue from View link in post editor, or after clicking filtering by Published Post column
* Compat : PublishPress Authors: If Permissions plugin is active, Revisors could not view revisions in queue if published post has multiple authors
* Compat : PublishPress Authors: Revisors could not list their own revision after updating it, if "Editing others' revisions requires role capability" setting enabled
* Compat : W3 Total Cache: Clean cache after revision publication

= 3.6.0 - 29 Jan 2025 =
* Compat : PublishPress Planner - Fix Revision Status display and selection in Calendar, Content Board, Overview (requires Planner 4.6)
* Compat : PublishPress Statuses Pro (Custom Revision Statuses)
* Compat : PublishPress Permissions Pro - Option for Access Circle restrictions to apply to Revisions
* Fixed : Page Parent revision was not applied to published page
* Fixed : Revision Archive - Schedule Revision approver was not recorded
* Fixed : Revision Archive - Scheduled Revisions did not show scheduling time
* Fixed : Revision Archive - Recent entries had incorrect time display
* Feature : Revision Archive - Option to store custom fields from submitted, scheduled revisions

= 3.5.16 - 19 Nov 2024 =
* Security : Under some plugin configurations, Revisors could view other users' revisions (draft, submitted or scheduled) inappropriately
* Fixed : Revision read capabilities did not limit slider positions on Compare Revisions screen
* Fixed : WP 6.7 - Avoid early loading of plugin textdomain under some conditions

= 3.5.15 - 8 Oct 2024 =
* Fixed : Editing a post did not refresh its "Has Revisions" flag
* Change : Setting to work around cache plugin conflicts by refreshing "Has Revisions" flag before suppressing a "New Revision" link on Posts / Pages screen
* Change : Hardened security within wp-admin by adding a few missing nonce checks and output escapes
* Change : PHP Code Sniffer rule compliance - flagged false positives for meaningful pre-release scans

= 3.5.14 - 26 Sep 2024 =
* Fixed : New Revision link on Posts screen failed due to plugin conflict on some sites
* Change : New setting (with disclaimer) to disable new unfiltered_html check. Useful on sites where any custom html is unintended and can be stripped out.

= 3.5.13 - 26 Sep 2024 =
* Fixed : Revision creation by a user with default Revisor capabilities caused custom html tags to be stripped out of post content. Now prevent revision, requiring unfiltered_html capability. 
* Fixed : Classic Editor - Revisors editing a revision could not select a future date
* Fixed : Revision approval in "Publish by Revision" mode caused page to be published without a URL
* Fixed : Revision History - PHP Warning for preg_replace parameter
* Fixed : Link Whisper plugin postmeta data caused fatal error on revision creation
* Fixed : Duplicate revision creation on some sites
* Change : When user clicks into a custom field in Post / Revision editor, disable Submit / Approve / Schedule Revision button until changes are saved 

= 3.5.12 - unreleased =
* Fixed : Classic Editor - Schedule Revision / New Revision button captioning did not account for time zone difference between server and site
* Fixed : Notifications were not sent for auto-submitted revisions
* Fixed : Fatal error if function rvy_revision_statuses() or rvy_revision_base_statuses() is called with non-standard arguments by third party code

= 3.5.11 - 26 Jun 2024 =
* Compat : PublishPress Permissions - Revision Queue listed some editable posts without edit link
* API : Filter revisionary_mail supports headers customization

= 3.5.10 - 18 Jun 2024 =
* Fixed : With plugin option to limit to one revision per post, revision submission could be inappropriately blocked under some conditions
* Fixed : Edit Revision screen - Delete Revision button functions incorrectly after toggling from Block panel back to publishing panel
* Fixed : Non-Administrators could not decline revisions
* Fixed : Block / Classic Editor usage was not correctly detected under some conditions
* Fixed : Post Editor - "Schedule Revision" button captioning following date selection did not account for time zone difference between site and editing user
* Fixed : Post Editor - "Schedule Revision" button captioning following date selection was not applied with recent Gutenberg versions
* Compat : Gutenberg 18.5 - Revision UI was not correctly displayed for revision edit
* Compat : Disable Gutenberg - Classic Editor mode was not detected under some configurations
* Compat : WooCommerce - After revision creation in post editor, preview button redirected to dashboard
* Compat : WP Rocket - Clean post cache on revision publication
* API : New action hook to support custom columns in Revision Queue table
* Lang : Removed obsolete German translation, which caused errors on some pages

= 3.5.9 - 7 May 2024 =
* Fixed : After new revision creation in post editor, View / Edit links fail with PHP warnings on some installations
* Fixed : Classic Editor - When editing a published post, future date selection followed by "Schedule Revision" button click failed to schedule revision
* Fixed : Classic Editor (Revision) - Changing Category, Tag, Featured Image or other Meta box did not disable Approve button
* Fixed : Classic Editor (Revision) - Changing or removing Featured Image did not disable Submit, Approve button
* Fixed : Revision Queue: Decline link nonce failure ("link expired")
* Fixed : PHP Warning on revision submission if published page is the child of a parent that has been trashed
* Compat : PublishPress Authors - Revisors could not submit revisions correctly if role has ppma_edit_post_authors capability
* Compat : PublishPress Permissions - API to apply Specific Permissions to Revision Queue listing
* Lang : Various plugin settings captions and one error message were not translated

= 3.5.8.2 - 25 Apr 2024 =
* Fixed : Nonce failure on revision decline attempts
* Fixed : Saving with a future date in Classic Editor saves post as Published instead of Scheduled, under some conditions
* Fixed : With Limit to One Revision option enabled, approving a revision caused a fatal error, under some conditions
* Fixed : Revision Queue - If multiple bulk actions are applied, confirmation notice from previous actions is repeated
* Compat : Some plugins conflicted with Edit / Preview links for newly created revision
* Compat : Nested Pages - Fatal error on bulk deletion of revisions

= 3.5.8.1 - 16 Apr 2024 =
* Fixed :  If limiting to one active revision per post, deleting a revision before saving it did not restore creation ability on some sites

= 3.5.8 - 12 Apr 2024 =
* Fixed : Revision Editor hid category selection checkboxes
* Fixed : New Revision button was missing from Revision Editor sidebar
* Fixed : Revision Editor did not display Preview Revision button
* Fixed : Revision Preview top bar styling broken by external CSS on some sites
* Fixed : Revision Preview top bar styling stuck in cache on some sites
* Fixed : If limiting to one active revision per post, deleting that revision did not restore ability to create a new one
* Fixed : Revision Queue - Bulk Decline failed with "link expired" message
* Fixed : New revisions could become orphaned from main post on WordPress VIP

= 3.5.7 - 4 Apr 2024 =
* Compat : WordPress 6.5 - Revision editor sidebar did not display date, template UI
* Feature : Decline link in Revision Queue row, Revision Preview top bar
* Fixed : Preview of front page revision was not displayed correctly
* Fixed : Previews of archived revisions did not display custom fields, multiple authors
* Fixed : Revision preview styling broke third party javascript on some installations
* Fixed : Classic Editor - Custom Fields metabox was unavailable while editing a revision
* Fixed : WP-defined revision limit (for past revisions) was not imposed when saving current content as a past revision at pending / scheduled revision publication
* Fixed : If "Limit to one active revision per post" setting is enabled, deleting a revision on a cached site did not restore ability to create a new revision to replace it
* Fixed : Possible memory leaks in javascript on Revision edit with Gutenberg editor
* API : New filter "revisionary_preview_link_type"

= 3.5.6 - 4 Jan 2024 =
* Feature : New setting Revisions > Settings > Preview > "Modify preview link for better theme compatibility". Some themes require one setting, some require the other.
* Fixed : ACF - Revision update, preview fails if ACF plugin is active
* Fixed : Edit Revision - Approve, Submit buttons missing in Gutenberg 17
* Fixed : PHP 8.2: Warning for dynamic property declaration

= 3.5.5 - 12 Dec 2023 =
* Compat : Advanced Custom Fields - Prevent invalid filtering of revision ID
* Fixed : Front page template was not loaded for revision previews of front page
* Fixed : Revision previews were not loaded correctly on some sites
* Fixed : Pagination setting on Queue, Archive screens was not stored
* Fixed : Pagination on Archive screen not applied if Revision Deletion option disabled
* Fixed : Classic Editor - Revision Status no longer displayed after changing publish time
* Fixed : Classic Editor - Modified publish time discarded if Submit / Approve clicked before Update Revision
* Fixed : Classic Editor - Revision Submit button was still (mal)functional when disabled
* Change : Classic Editor - Separate buttons to Preview changes in progress, View / Approve Saved Revision

= 3.5.4 - 17 Oct 2023 =
* Fixed : Past Revision previews did not display (since 3.5.3)
* Fixed : Scheduled Revisions were not published under some configurations
* Fixed : Custom fields with multiple values stored to the same key were not revisioned correctly
* Fixed : Improve html validation of Revisions Settings screens, possibly resolving rendering issue on some browsers
* Change : Screen Options on Revision Queue and Revision Archive to set Revisions per Page (previously used setting from Pages screen)
* Compat : PublishPress Authors - Default author setting overrides actual revision author

= 3.5.3 - 30 Aug 2023 =
* Feature : Option to enable deletion of revisions in Revision Archive 
* Fixed : Category / taxonomy changes were cleared by revision preview, not applied at revision approval
* Fixed : Revision Archive included autosaves
* Fixed : PHP 8.1 - Warning for dynamic property creation in revision preview

= 3.5.2 - 17 Aug 2023 =
* Fixed : Pro - Fatal error on activation if plugin settings were not previously saved (packaging error reverted fix in 3.5.1)
* Fixed : Revision Edit - No progress caption was shown after Submit button click
* Fixed : Options screen - html markup error (missing closing div tag)
* Lang : Updated Spanish, French, Italian translations

= 3.5.1 - 11 Aug 2023 =
* Fixed : Bedrock - Unable to activate plugin due to three internal libraries missing from GitHub commit

= 3.5 - 10 Aug 2023 =
* Fixed : Unscheduling a revision using bulk edit in Revision Queue caused it to become inaccessible
* Compat : Permalink Manager plugin - Suppress permalink modification in Revision edit
* Change : Change revision deletion captions to clarify that only the revision is deleted
* Change: Modified internal vendor library structure for shorter paths (lib/vendor)
* Change: Free plugin is loaded through internal vendor library

= 3.4.1 - 29 Jun 2023 =
* Fixed : Incorrect admin menu item display if revision submission is disabled for all post types

= 3.4 - 29 Jun 2023 =
* Feature : Revision Archive screen

= 3.3 - 19 Jun 2023 =
* Feature : Revisions > Settings > Revision Creation > "Limit to one active revision per post"
* Fixed : Plugin compat - dashboard_glance_items was improperly filtered
* Fixed : Revisions were incorrectly attributed to original page author under some conditions
* Compat : Revision Queue - Work around unidentified plugin conflict inserting inappropriate clauses into our posts query
* Compat : PublishPress Authors - Author changes in revision were not applied at revision publication
* Compat : PublishPress Authors - Revision Queue "Revised By" column always showed original post author
* Compat : Permissions + WordFence - Add Media query was not filtered based on Permissions settings
* Fixed : Multisite - Some settings UI were not displayed when plugin on network installations when plugin is not activated network-wide 
* Fixed : Multisite - Settings previously configured for network-wide activation were not displayed on sub-site settings screen even after network deactivation
* Change : Bump WordPress version requirement to 5.5
* Change : Bump PHP version requirement to 7.2.5
* Change : Update vendor libraries based on revised PHP version support, using new internal-vendor structure

= 3.1.13 - 30 Mar 2023 =
* Fixed : Posts screen - Has Revision caption was not displayed unless "Revision Submission for Unpublished Posts" setting is enabled  
* Fixed : Settings > Notifications > "Show Notification Log / Buffer" link did not redirect back to Notifications tab
* Change : Minimum PHP version 7.2.5

= 3.1.12 - 23 Mar 2023 =
* Fixed : Posts were left with invalid "Has Revision" links after publication or deletion of all their revisions
* Fixed : If Revision Submission for Unpublished Posts is disabled but revisions of draft posts were previously created, those caused a "Has Revisions" label without displaying the revisions in Queue
* Fixed : Links to Revision Queue for a specific published post (including "Has Revision" links from Posts listing) failed to list unsubmitted revisions
* Fixed : Revision Compare > Manage : Non-rendered html tags, incorrect table formatting 
* Fixed : Compare Past Revisions - invalid link on Preview / Restore button
* Fixed : Request Deletion link was displayed even if revisions are not enabled for post type

= 3.1.11 - 9 Feb 2023 =
* Fixed : Revision preview failure under some conditions
* Fixed : Avoid PHP Warning on Revision Preview if requested revision cannot be loaded
* Fixed : On Network-wide multisite activations, Settings screen displayed an unrendered html tag 
* Lang : Update Spanish, French, Italian translations

= 3.1.10 - 22 Dec 2022 =
* Perf : Improve performance of post revision count, dropdown pages queries
* Fixed : Revisions were not correctly declined on some cached sites

= 3.1.9 - 15 Dec 2022 =
* Fixed : Scheduled Revisions missed by WP-Cron were not rescheduled. To disable auto-reschedule, define constant REVISIONARY_DISABLE_WP_CRON_RESTORATION
* Fixed : Revisions Queue table was missing a "check all" box
* Fixed : Fatal error on revision approval on some sites
* Compat : Relevanssi - If filtering is enabled for admin searches, Submitted / Scheduled Revisions are included in search results 
* Compat : PublishPress Future - Attempted revision of post expiration settings caused unexpected behavior; disable for now
* API : Classic Editor revision editor supports filter revisionary_submit_revision_metabox_classic

= 3.1.8 - 3 Nov 2022 =
* Fixed : PHP 8 - Unresponsive elements in post editor due to Javascript loading failure
* Fixed : Avoid fatal error on plugin activation if loading sequence is non-standard
* Compat : WP Buddy Rich Snippets - PHP error "The script tried to modify a property on an incomplete object" on revision creation

= 3.1.7 - 12 Oct 2022 =
* Feature : Revision submission and approval handles author selection
* Fixed : Plugin review request dismissal was not applied
* Fixed : Gutenberg Editor - for non-English locales, future date selection did not enable Scheduled Revision creation
* Fixed : Gutenberg Editor - when editing an existing Scheduled Revision, publish date caption shows "Immediately"
* Fixed : PHP Notice "Trying to get property 'post_type' of non-object" when another plugin hooks into "use_block_editor_for_post" filter
* Lang : Update Spanish, French, Italian translations

= 3.1.6 - 31 Aug 2022 =
* Change : Support detection / indication of custom WP-Cron implementations when DISABLE_WP_CRON is set true

= 3.1.5 - 30 Aug 2022 =
* Fixed : Revision Submission from Gutenberg editor failed on some sites
* Fixed : Bulk-deleted revisions were not removed from revision count
* Fixed : PHP Warning for invalid regex if post type's REST registration or request has an invalid route string

= 3.1.4 - 17 Aug 2022 =
* Fixed : Approve Revision button in Gutenberg editor did not work
* Fixed : Submit Revision button in Gutenberg editor failed under some conditions
* Fixed : Detection of DISABLE_WP_CRON constant
* Fixed : Administrators did not receive revisions submission notifications under some configurations
* Fixed : Revision Queue column ordering / filtering links didn't work as expected in some use cases
* Fixed : When previewing a scheduled revision that has been published, "Edit" link in top bar had invalid URL
* Fixed : If Pro plugin is activated, deactivation of free plugin hides all revisions
* Compat : Yoast SEO: PHP Notices on revision creation / submission
* Lang : Update Spanish, Italian translations

= 3.1.2 - 7 Jul 2022 =
* Fixed : Filter 'use_block_editor_for_post' was not recognized in detecting block editor disable
* Fixed : Revision Edit in Gutenberg: Enable non-Editors to set requested publish date
* Fixed : Scheduled revisions were not published on some installations
* Change : Allow WP-Cron publication method to be disabled for scheduled revisions
* Feature : Option to Delete Editorial Comments on revision approval
* Feature : Option to disable revisions per post type
* Feature : Instance protection library warns about non-standard plugin folder, unnecessary free plugin activation
* Feature : Plugin review request
* Feature : Pro promo sidebar on settings screen

= 3.1.1 - 8 Jun 2022 =
* Fixed : Revision scheduling left a future date selection in editor. If the post is updated again without reloading the editor, it is unpublished until the selected date

= 3.1 - 1 Jun 2022 =
* Feature : Revision Edit - Administrators and editors have approval button for unsubmitted revisions
* Feature : Revision Queue - Bulk Edit includes "Decline" action to return "Submitted" revisions back to "Not Submitted"
* Feature : Revision Queue - New "Copy" row action
* Compat : PublishPress Permissions - fatal error loading Customizer
* Compat : PublishPress Authors - Revision submission failed
* Compat : PublishPress Permissions - Fatal error loading Customizer (also requires Permissions 3.7.6)
* Fixed : Scheduled Revisions fail on some sites
* Fixed : Editors could not manage unsubmitted revisions without manage_unsubmitted_revisions capability, even if "Additional role capability required" setting disabled
* Fixed : Non-public Post types had non-functional revision preview links, revision publication redirects
* Fixed : Edit Revision - alignment and spacing in revision status sidebar
* Fixed : Edit Revision - submit / approve buttons were re-enabled after toggle from Block to Post tab
* Fixed : Revision Queue - checkbox column did not have a "select all" box

= 3.0.16 - 20 Apr 2022 =
* Fixed : Post Editor - New Revision button was not displayed 
* Lang : Some translations did not load
* Fixed : Edit Revision with Classic Editor - submit button not displayed for some custom post types

= 3.0.15 - 31 Mar 2022 =
* Fixed : Scheduled Revisions failed on WP 5.9 if WP Cron scheduling was disabled in Revisions settings

= 3.0.14 - 30 Mar 2022 =
* Fixed : Output variable escaping, other coding standard improvements

= 3.0.13 - 21 Mar 2022 =
* Fixed : Revision submission in Classic Editor caused "Undefined" link next to "Preview" link
* Fixed : New revisions created with "Auto-submit" option had wrong date (and listing order) in Revision Queue
* Fixed : PHP error on revision approval under some configurations
* Fixed : Dashboard Activity widget: Scheduled revisions were not included in Publishing Soon list
* Fixed : API: wp_after_insert_post action was not applied at revision publication
* Compat : Divi - Revision preview bar not visible on front end
* Compat : Divi - Classic Editor setting did not trigger correct Revisions UI
* Compat : Custom post types - revision submission button not displayed in some configurations
* API: New filters pp_revisions_option_pending_revision_update_post_date, ​pp_revisions_option_pending_revision_update_modified_date, ​pp_revisions_option_scheduled_revision_update_post_date​, ​pp_revisions_option_scheduled_revision_update_modified_date

= 3.0.12 - 3 Mar 2022 =
* Feature : Edit link in post editor after revision creation / scheduling
* Change : Option to auto-submit revisions created by users who can publish the main post
* Change : Option to publish scheduled revisions using WP-Cron
* Fixed : Scheduled publication of revisions fails on WP Engine if caching enabled (fix by enabling WP Cron scheduling)
* Fixed : WP 5.9 - After editing a revision, approval button remained disabled after revision update
* Fixed : New revisions were not listed in Revision Queue or linked to Preview button under some conditions
* Fixed : Compare Revisions: error if ACF is active on a PHP 8 installation
* Fixed : Revision Queue - column headers (to set sort field) had a bad link

= 3.0.10 - 10 Feb 2022 =
* Fixed : WordPress 5.9 - When editing a submitted revision, Save button was hidden
* Fixed : Revision Compare did not load on some sites
* Fixed : Option "Editing others' revisions requires role capability" was not applied

= 3.0.9 - 27 Jan 2022
* Compat : WordPress 5.9 - Revisions could not be updated using Gutenberg editor

= 3.0.8 - 26 Jan 2022
* Compat : WordPress 5.9 - Fatal error adding / editing posts (work around WP hooking late-defined function _disable_block_editor_for_navigation_post_type)

= 3.0.7 - 5 Jan 2022 =
* Fixed : Revision status changes not updated on sites running an object cache
* Fixed : Revision deletion from within editor left an inaccessible trashed revision and redirected to Edit Posts. Now deletes revision and redirects to Revision Queue.
* Fixed : manage_unsubmitted_revisions capability was required without any hint in plugin settings; Now not required unless configured in Revisions > Settings
* Fixed : Classic Editor - Javascript error breaks plugin compatibility
* Fixed : Gutenberg Editor - Top margin for Preview button following revision submission
* Fixed : Compare screen - could not approve revisions
* Fixed : Compare screen - ampersands in user display name were displayed with html encoding
* Fixed : Revision Queue - Revisions from deactivated post types were listed with invalid Edit, Delete links and a blank Post Type
* Fixed : Compare Revisions - Preview / Restore button for past revisions linked back to Compare screen
* Fixed : Input sanitization consistency
* Change : Revision preview top bar styling
* Compat : LifterLMS - LLMS query filters broke Revision Queue
* Compat : WPML - Database error in Revision Queue
* Fixed : Revision Queue: PHP error on bulk action under some site configurations

= 3.0.6 - 29 Nov 2021 =
* Fixed : Edit Revision - revisions could not be updated unless SCRIPT_DEBUG is enabled on the site
* Fixed : Revisions could not be scheduled if Settings > Revisions > Revision Submission is disabled

= 3.0.5 - 23 Nov 2021 =
* Fixed : Published custom post types not listed to Revisors under some configurations (Permissions integration requires Permissions 3.6.4)
* Fixed : Multisite - network-wide settings screens were non-functional

= 3.0.4 - 19 Nov 2021 =
* Fixed : New Revision button not displayed in Admin Bar
* Fixed : Revision Queue: revisions not listed in My Activity view

= 3.0.3 - 18 Nov 2021 =
* Fixed : Revisions Queue empty on sites with a large number of published posts
* Compat : WooCommerce - Hide Product Variations, Linked Products tabs when editing a Product Revision

= 3.0.2 - 15 Nov 2021 =
* Compat : PublishPress Permissions - Revisions Submission permissions did not correctly adjust Edit Posts / Pages listing in some configurations (also requires Permissions 3.6.3)
* Compat : The Events Calendar - Revisions could not be submitted in Classic Editor
* Fixed : Classic Editor - Schedule button was incorrectly displayed (leading to failed scheduling attempt) if a single time element is changed followed by OK button
* Fixed : Scheduled Revisions could not be updated in Gutenberg editor
* Fixed : Admin Bar button "New Revision" was displayed even if Submitted Revisions are disabled
* Fixed : Revision Queue: bulk deletion did not reduce revision counts
* Fixed : Duplicate page selection dropdown in Quick Edit and other instances of wp_dropdown_pages()
* Fixed : Invalid page hierarchy and broken Pages admin if a past revision that was originally submitted through the Revisions plugin is restored 
* Fixed : Revision Preview was missing "Approve" button caption if revision is of an unpublished post
* Change : Revisions Settings - clarify some captions

= 3.0.1 - 10 Nov 2021 =
* Fixed : Revisions created using Revisions 2.x were not listed in Revision Queue until plugin de/re-activation
* Fixed : Front Page setting was cleared at revision submission on some sites
* Fixed : Front Page setting dropdown in Settings > Reading included revisions
* Fixed : Classic Editor : Schedule Revisions could not be submitted
* Fixed : Classic Editor : Schedule button was displayed incorrectly while selecting a future date for scheduled revision
* Compat : Gutenberg plugin - Edit Revision screen crashed on update attempt
* API: Allow redirect to be disabled on revision creation

= 3.0 - 9 Nov 2021 =
* Feature : New revision submission mechanism: create an unsubmitted revision first instead of editing existing post. Edit revision directly, then submit for scheduling or publication.
* Change : Revisions UI in Post / Revision editor
* Feature : Admin Bar includes "New Revision" button
* Change : Revision Queue filter captions
* Compat : Permissions - revise_others_posts, revise_others_pages, etc. capabilties are equivalent to list_others capabilities in allowing uneditable items to be listed
* Change : Include upload_files capability in the Revisor role

= 2.6.3 - 11 Oct 2021 =
* Fixed : Classic Editor - Error submitting a pending or scheduled revision

= 2.6.2 - 7 Oct 2021 =
* Change : Maintenance queries run at plugin activation to convert version 3.0 revisions back to 2.6 encoding
* API : Support for WPML Translation Management support in Pro version

= 2.6.1 - 15 Jul 2021 =
* Fixed : Pending / Scheduled Revisions could become disassociated from main post due to third party plugin interactions
* Compat : Permissions - Specific Permissions were not applied for editing / approval of custom post types under some conditions 
* Fixed : Revision Update triggered redirect back to Revision Queue even if "Confirmation redirect on Revision Update" setting disabled
* Fixed : Users without full editing capabilities could not submit a pending revision with a future date selection
* Fixed : Revision Previews were cached on some browsers
* Fixed : Preview of front page revisions did not trigger front page template display
* Fixed : Bulk Approval of revisions failed / caused PHP Notice on some sites due to post type not being registered early enough
* Fixed : Pending Revision checkbox default selection from 'revisionary_default_pending_revision' filter application did not trigger revision submission 
* Lang : Revision Queue - Remove sample English translation "My Revisionz"

= 2.6 - 23 Jun 2021 =
* Fixed : Background fatal error on some sites on revision scheduling
* Fixed : Scheduled Page Revisions - If published page has a non-default template which was not changed in the revision, the Compare and Edit Revision screens indicated a change to default template. This change was not actually applied unless the stored revision was updated prior to publication.   
* Feature : Option to send notifications on Revision Update
* Feature : Option to redirect to confirmation screen after Revision Update
* Compat : Custom Permalinks plugin
* API : New filters allow submission confirmation message to be customized: revisionary_submit_message_links, revisionary_submit_message, revisionary_schedule_message_links, revisionary_schedule_message

= 2.5.5 - 26 May 2021 =
* Compat : Google Web Stories - Loss of story data due to clearance of post_content_filtered column
* Fixed : Fatal error in post editor on sites that apply filter "rest_{$post_type}_collection_params" incorrectly (Uncaught ArgumentCountError: Too few arguments to function)
* Fixed : PHP Warning on rvy_is_full_editor() call under some configurations
* Change : Revision Queue - Standard link coloring (like Edit Posts)

= 2.5.4 - 6 May 2021 =
* Fixed : Database error on Revision approval - Unknown column 'filter' in 'field list' for query UPDATE `wp_posts` SET `post_author` = 
* Compat : TablePress - Tables could not be updated by non-Administrators

= 2.5.3 - 6 Apr 2021 =
* Compat : WP Rest Cache - Revision submission from Gutenberg failed
* Compat : PublishPress Permissions - Edit Category / Term: Permissions metaboxes were not displayed
* Compat : PublishPress Permissions - Pending Revision Monitors group ineffective; notifications were sent to all Editors and Administrators (also requires PublishPress Permissions 3.5.1)
* Compat : Enable revisioning of non-public post types if they have type-specific capabilities defined

= 2.5.2 - 30 Mar 2021 =
* Fixed : Fatal error due to incorrect vendor library load request

= 2.5.1 - 30 Mar 2021 =
* Fixed : Revisors could not preview other users' pending revisions, even if they are listed in Revision Queue (Permissions integration requires 3.5.1)
* Fixed : Post Title changes were not applied at revision publication
* Fixed : Database error on revision publication, on some installations
* Fixed : Compare Revisions - uneven column widths with WordPress 5.7
* Feature : Option to update modified date on revision publication
* Compat : PublishPress - Custom Status dropdown was hidden in post editor
* Compat : Kinsta object cache - Revision submission using "Save as Revision" checkbox failed
* Compat : Kinsta object cache - Revision submission clears Featured Image from published post

= 2.5 - 4 Mar 2021 =
* Fixed : After a Pending Revision is published, Compare Revisions screen for past revisions did not order it correctly
* Fixed : Revisors could not access Compare Revisions screen unless PublishPress Permissions was active
* Fixed : Some attachment fields implemented by third party plugins were not saved to Pending Revisions
* Fixed : Revision submission - "submit another revision" link (following future date selection) led to submission failure on some sites
* Compat : Advanced Custom Fields - attachment image fields were cleared out of new revision
* Compat : REST API Cache - "Save as Revision" checkbox ineffective on some installations
* Compat : PublishPress - Editing a revision caused it to be converted to a non-revision draft
* Compat : PublishPress - Custom Status module interfered with Revisions scripts on Edit Revision screen
* Compat : PublishPress - Adding an Editorial Comment on the Edit Revision screen, then updating, caused revision to become inaccessible 
* Compat : Some third party plugin interactions could cause Revision publication to fail, leaving published page unreadable
* Change : Display a Revisions link (for past revisions) in Classic Editor for Revisor
* Lang : Add Swedish translation

= 2.4.9 - 14 Jan 2021 =
* Compat : REST API Cache - REST caching failed for attachments
* Fixed : Non-public post types displayed ineffective preview link. Now suppress link or link to Compare Revisions screen instead.
* Fixed : Error loading Revisions > Settings page if nullstring license key is stored, on some installations
* Fixed : Deprecated jQuery event handlers
* Feature : Display notice to Revisor if they have already submitted a revision (in Gutenberg only if constant REVISIONARY_GUTEN_NOTICE defined)
* Change : Enable Compare Revisions link (for past revisions) in page editor for Revisor

= 2.4.8 - 17 Dec 2020 =
* Compat : WPML - Revision Queue was not filtered by WPML language selector
* Compat : WPML - Hide non-revisionable Languages settings in Revision editor
* Compat : TablePress - Tables could not be updated by non-Administrators
* Fixed : Revision Queue - PHP Notice if no revisions listed

= 2.4.7 - 15 Dec 2020 =
* Fixed : WP 5.6 - Pending Revision submission failed (since 2.4.6)
* Fixed : Compare Pending Revisions always credited assigned post author for Current Revision, now shows user who created the last published update. To revert to previous behavior, define constant RVY_LEGACY_COMPARE_REVISIONS_AUTHOR_DISPLAY.
* Change : Clarify captions for permissions-related checkboxes in Revisions > Settings > Revision Queue
* Compat : PublishPress Capabilities - organize Revisions capabilities into own area

= 2.4.6 - 8 Dec 2020 =
* Lang: Include a .pot file (translation template)
* Fixed : If no revisions are accessible to user, all revisions were listed in Revision Queue
* Fixed : Post deletion triggered revision submission redirect under some conditions
* Compat : REST API Cache plugin - "Save as Revision" checkbox was ineffective
* Compat : PublishPress Authors - revision submission failed under some conditions

= 2.4.5 - 30 Nov 2020 =
* Compat : WP Engine, Kinsta object cache - "Pending Revision" checkbox was ineffective
* Compat : PublishPress Permissions - Revision editing or deletion was improperly blocked under some configurations
* Fixed : Revision submission by Administrator or Editor caused corruption of published block content (by slash removal) on some installations
* Fixed : Edit Revision screen did not display Approve Revision button to users who cannot delete the revision
* Fixed : Revision Queue - other plugin / theme filters could cause all revisions to be listed when a requested published post has no accessible revisions
* Fixed : Revision Queue - filter links worked, but had original URL reconstructed incorrectly
* Fixed : Revision Queue - pagination links had badly formatted arguments if a filtering argument is active
* Fixed : Revisors had non-applicable elements hidden in post editor, but orphaned labels for those elements remained visible
* API : New filter 'revisionary_notify_publishers_eligible' to modify eligible "Publishers to Notify" when Email Notification is optional
* API : New filter 'revisionary_notify_publisher_default_ids' to modify default "Publishers to Notify" when Email Notification is optional

= 2.4.4 - 18 Nov 2020 =
* Fixed : Revision submission caused Post Thumbnail to be cleared from the published post
* Fixed : Revision submission by a Revisor caused corruption of published block content (by slash removal) on some installations
* Fixed : Compare Past Revisions - Editors did have "Preview / Restore" or "Manage" buttons

= 2.4.3 - 5 Nov 2020 =
* Compat : Polylang - language settings were not stored to revision (Fix also applies to other plugins using hidden taxonomies)
* Compat : Project Nami (Microsoft SQL Server / ODBC) - No confirmation redirect on revision submission
* Lang : Added .pot file

= 2.4.2 - 26 Oct 2020 =
* Compat : PublishPress Permissions - Users assigned Revise permissions for specific pages or categories could not compare Pending Revisions
* Compat : PublishPress Permissions Pro - With Status Control module active, Edit Revision screen had invalid "Workflow" button (also requires Permissions Pro 3.3.8)
* Compat : Public Post Preview - Author selector was hidden in post editor
* Compat : Public Post Preview - Make public post previews of published posts redirect to the published post
* Change : Revision Settings - Revision Queue section, includes "Compatibility Mode" setting to prevent revisions from being hidden from the queue in the case of plugin integration issues
* Fixed : "Prevent Revisors from editing others' revisions" setting was not applied
* Fixed : Error when Revision submission includes a template setting
* Fixed : Custom plugins path caused PHP error
* Fixed : Revison Queue - PHP Notice "Undefined variable: post_id" when URL includes published_post argument
* Feature : If Revisors are blocked from editing other users' drafts, those can now be included (unclickable) in Edit Pages if the list_others_pages capability is granted 
* Feature : Support constant definitions REVISIONARY_DISABLE_SUBMISSION_REDIRECT, REVISIONARY_DISABLE_SCHEDULE_REDIRECT
* Feature : New filters "revisionary_do_submission_redirect", "revisionary_do_schedule_redirect"

= 2.4.1 - 9 Oct 2020 =
* Compat : PublishPress Permissions - On new post creation, Revisors get a Publish button instead of a Submit button. Publishing fails; the only way to submit successfully is Save Draft, then Submit for Review.
* Compat : PublishPress Permissions - Revisions were not listed in Queue under some configurations with PublishPress Permissions active
* Fixed : With pre-Publish checks enabled in Gutenberg, after first save "Pending Revision" checkbox was moved off of pre-Publish Panel

= 2.4 - 1 Oct 2020 =
* Fixed : Revisors and other limited editors had editor elements hidden when adding a new post, under some site configurations
* Fixed : Revision publication always set post publish date to current time. Now does only with enabled setting Revisions > Settings > Pending Revisions > Update Publish Date
* Fixed : Classic Editor - after Preview Changes is clicked, limited editors see "Submit Revision" button recaptioned to "Update"
* Compat : PublishPress Authors - Authors could not be changed on Edit Revision screen with Gutenberg editor if PublishPress is also active
* Compat : Gutenberg Ramp - Revision submission UI did not load for post types that have Gutenberg enabled

= 2.3.12 - 27 Aug 2020 =
* Fixed : WP 5.5 - Post previews did not display correctly for Revisors
* Fixed : Pending, Scheduled revisions not listed in Revision Queue following mirroring of posts database table from another installation (or possibly under other conditions) 
* Fixed : Editorial Comments added on "Edit Revision" screen did not trigger email notification to post author or revision author
* Feature : Option to copy revision's editorial comments over to published post (at revision publication)

= 2.3.11 - 13 Aug 2020 =
* Compat : WP 5.5 - "Pending Revision" checkbox sometimes ineffective
* Compat : WP 5.5 - Posts with pending or scheduled revisions stored had misplaced links in Gutenberg editor sidebar
* Compat : WP 5.5 - With Classic Editor, javascript errors in post editor
* Compat : WP 5.5 - PHP warning on post edit (deprecated function escape_attribute)
* Compat : WP 5.5 - Edit Revision screen - Duplicate Preview link, misaligned
* Compat : WP 5.5 - Edit Revision screen - View / Approve link misaligned
* Fixed : "Has Revision" post state displayed for posts that have comments but no revisions (since 2.3.10)
* Fixed : Scheduled revisions were not published under some conditions (since 2.3.9)
* Fixed : In some conditions, fatal error on Plugins screen

= 2.3.10 - 10 Aug 2020 =
* Fixed : Revisions submitted without modifying tags had tags removed
* Feature : Edit Posts screen - display "Has Revision" as a post state after post title

= 2.3.9 - 6 Aug 2020 =
* Fixed : Featured Image was removed from pending revision at creation
* Fixed : Scheduled revision publication failed under some conditions, caused post to be unpublished
* Fixed : Scheduled revisions could not be published ahead of schedule using "Publish Now" link on preview (since 2.3.4)
* Lang : Add German translation
* API : New filter 'revisionary_apply_revision_data' to adjust standard revision fields prior to publication

= 2.3.8 - 30 Jul 2020 =
* Feature : Revision Queue - new bulk action to Unschedule selected revisions
* Lang : Add Spanish translation
* Fixed : Revisors could not preview changes prior to submitting a pending revision
* Fixed : Classic Editor plugin - when "Edit (Classic)" link is used, Revisors did not have Update button recaptioned to "Submit Revision"
* Fixed : API - revisionary_enabled_post_types filter was not fully effective
* Compat : Public Post Preview - support preview link generation on Edit Revision screen

= 2.3.6 - 10 Jun 2020 =
* Fixed : After revision submission, preview link was not always to latest revision
* Fixed : Preview button on editor screen loaded preview with invalid thumbnail under some conditions
* Fixed : When network-activated, Network Settings menu item loaded site-specific settings screen

= 2.3.5 - 29 May 2020 =
* Fixed : Compare link on Editor screen linked to Edit Posts screen instead of Compare Revisions 

= 2.3.4 - 29 May 2020 =
* Fixed : Duplicate email notifications to users who have more than one WordPress role
* Change : Suppress email notification when an Administrator or Editor creates a pending revision, if constant REVISIONARY_LIMIT_ADMIN_NOTIFICATIONS is defined
* Compat : Relevanssi - Scheduled revisions were not published with Relevanssi active
* Fixed : Scheduled revision publication caused other scheduled revisions (for the same post) to be hidden from Revision Queue
* Fixed : has_revisions postmeta flag was not cleared when a post's last revision was deleted
* Fixed : Revision Queue - Search function did not work
* Fixed : Revision Queue link in Edit Posts / Edit Pages row was not removed after post's last pending or scheduled revision published or deleted

= 2.3.3 - 14 May 2020 =
* Compat : PublishPress Permissions - Fatal error on post creation

= 2.3.2 - 12 May 2020 =
* Fixed : Post meta flag "_rvy_has_revisions" was not cleared after last remaining pending / scheduled revision was published or deleted, affecting Revision Queue performance
* Fixed : Revision Queue listed uneditable revisions under some conditions
* Fixed : My Published Posts count was wrong under some conditions
* Fixed : Dashboard At a Glance link for Pending Post Revisions linked to Revision Queue without filtering display to Posts only
* Compat : PublishPress Permissions - suppress Permissions metaboxes on Edit Revision screen
* Fixed : Published post content cleared on pending revisions submission, on a minority of installations

= 2.2.4 - 6 Apr 2020 =
* Fixed : Possible fatal error loading Revisions screen on a small percentage of installations

= 2.2.3 - 3 Apr 2020 =
* Fixed : Classic Editor - Category and Post Tag revisions were not applied

= 2.2.2 - 2 Apr 2020 =
* Feature : Option to disable revision preview links for non-Administrators (to work around themes that force a 404 Not Found response) 
* Fixed : Inline styles were stripped or modifield on scheduled revision publication
* Fixed : Possible fatal error loading Revisions screen on a small percentage of installations
* Fixed : PHP Notice for deprecated function contextual_help_list()
* Change : Standardize sanitization of database queries 
* API: revisionary_enabled_post_types filter was not applied consistently
* Compat : CMS Tree Page View - Suppress Pending Revisions and Scheduled Revisions from Page Tree View

= 2.2.1 - 16 Mar 2020 =
* Fixed : Page Template was cleared on revision submission in some installations
* Fixed : Revision Queue - "Filter" link was ineffective in showing only revisions of the selected published post. This also applies to "View Revision Queue" link after revision creation.
* Fixed : Edit Revision - Move to Trash button did not work (and created new pending revision)
* Fixed : Duplicate email notifications for scheduled revision publication on some installations
* Fixed : Safeguard to prevent duplicate email notifications
* Feature : Plugin API - new filter 'revisionary_mail' allows adjustment to notification email address, title or message (or blockage of a particular email)
* Change : Pro top banner on Revisions screens
* Compat : New setting "Revision publication triggers API actions to mimic post update" causes save_post and transition_post_status actions to fire on revision publication
* Compat : Yoast SEO - Revision submission stripped accented characters and emojis out of FAQ block
* Compat : On revision publication, trigger 'transition_post_status' action, for plugins that use it

= 2.2 - 12 Feb 2020 =
* Feature : Email Notification - option to notify Editors and Administrators when a Pending Revision is approved
* Fixed : Block Editor - Custom Taxonomies, if unchanged, were not saved to revision. Publication of revision cleared custom taxonomies for published post.
* Fixed : Block Editor - Error setting Featured Image
* Fixed : Revisions submitted by Administrators or Editors using "Pending Revision" checkbox caused published post title and content to be cleared if a future publish date was also selected
* Compat : PublishPress Permissions Status Control - "Prevent Revisors from editing other users' drafts" setting also prevented other non-Editors from editing posts of a custom workflow status that uses custom capabilities (also requires PP Permissions Pro 2.9.1)
* Compat : Block data from some plugins had html formatting tags displayed as unicode character codes
* Fixed : Edit Revision screen - Date selector was displayed even if scheduled revisions feature disabled
* Fixed : Compare Pending Revisions - Non-administrators could not edit Scheduled Revisions
* Fixed : Compare Pending Revisions - for page slug change, original published slug was not displayed 
* Fixed : 'revisionary_skip_taxonomies' filter triggered a database error
* Fixed : PHP Notice if third party code registers a post type without defining the edit_published capability
* Fixed : PHP Notices on revision submission notification
* Change : By default, enable "Prevent Revisors from viewing others'" setting
* Change : Apply possible workaround for Revision Queue capability issues on some sites

= 2.1.8 - 15 Jan 2020 =
* Fixed : Custom Post Types did not have Pending Revisions or Scheduled Revisions available (since 2.1.7)
* Lang : Correct textdomain on numerous translation calls
* Lang : Improve translation string construction
* Lang : Support translation of Revisor role name
* Lang : Updated language files

= 2.1.7 - 13 Jan 2020 =
* Fixed : Excessive resource usage with some caching solutions
* Fixed : Multisite - Super Administrators without a site role could not access Revision Queue 
* Fixed : Classic Editor - After updating a revision, "View Post" message linked to published post instead of revision preview
* Feature : New filter 'revisionary_enabled_post_types', unset post types by key to disable PP Revisions involvement

= 2.1.6 - 23 Dec 2019 =
* Fixed : Edit Revision - Classic Editor "Approve" button ineffective
* Fixed : Edit Revision - Classic Editor "View / Approve" button loaded live preview (of unsaved changes) instead
* Compat : By default, prevent third party post query filtering on Revision Queue (to avoid non-display of Revisions)
* Compat : PressPermit Pro - Updating a saved revision caused it to be changed to a regular pending post

= 2.1.5 - 11 Dec 2019 =
* Compat : PressPermit Pro - Pending revision previews could be viewed by any user (including anonymous) if "Prevent Revisors from viewing others' revisions" disabled (since 2.1.4)
* Fixed : Contributors had other users' uneditable, unreadable revisions listed in Revision Queue
* Fixed : Revision Preview - Under some configurations, users with read-only access to revisions had no top bar in revision preview display
* Fixed : Revision Preview - Under some role configurations, users saw an ineffective "Publish" button in preview top bar
* Fixed : PHP warning for undefined index 'preview'

= 2.1.4 - 10 Dec 2019 =
* Fixed : Revision previews were not displayed to Editors under some configurations
* Feature : Separate settings for "Prevent Revisors from editing others'" and "Prevent Revisors from viewing others'"

= 2.1.3 - 6 Dec 2019 =
* Compat : Classic Editor plugin - View / Approve buttons missing on Edit Revision screen if Classic Editor active but settings default to Block Editor
* Compat : Classic Editor plugin - Javascript errors on Edit Post / Edit Revision screen if Classic Editor active but currently using Block Editor
* Compat : Thin Out Revisions plugin broke Preview / Approval buttons on Compare Pending Revisions screen
* Compat : Multiple Authors - Revision Queue "Post Author" links did not work for secondary authors
* Compat : Multiple Authors - Revision Queue "Post Author" links did not filter Revision Queue
* Compat : JReviews - Live preview from Edit Revision screen failed if JReviews plugin active
* Fixed : Preview Top Bar blocks admin bar dropdown menu if another fixed-position element on the page (other than #wpadminbar) has a z-index of 99999 or higher

= 2.1.2 - 4 Dec 2019 =
* Fixed : Scheduled Revisions were not published (since 2.1)
* Fixed : Edit Revision - Preview of unsaved revision did not work from Gutenberg
* Change : Edit Revision - Display "View / Approve" button if editor is unchanged from saved revision, otherwise "Preview" button for unsaved changes
* Fixed : Classic Editor - Preview caused "Update Revision" button to be recaptioned to "Save Draft"
* Feature : Support Post Slug revision
* Fixed : Other users' revisions were not listed in Revision Queue even if "Prevent Revisors from editing others' revisions" disabled
* Fixed : With "Prevent Revisors from editing others' revisions" setting enabled, Revisors and Authors could edit others' revisions by direct URL access
* Feature : Support list_others_revisions capability to grant read access to other users' revisions (applies if "Prevent Revisors from editing others' revisions" is enabled)
* Compat : PressPermit Pro - Revisors could not submit Beaver Builder revisions
* Compat : PressPermit Pro - Revision Exceptions ("Also these" category / taxonomy assignments) assigned to Authors were not applied correctly
* Compat : JReviews plugin

= 2.1.1 - 26 Nov 2019 =
* Compat : Multiple Authors - Fatal error on revision creation (since 2.1)

= 2.1 - 26 Nov 2019 =
* Feature : Bulk Approval / Publishing in Revision Queue
* Feature : Revision Edit: Approve Button on Editor screen
* Feature : Option for Approve, Edit buttons on Compare Revisions screen (instead of Preview button)
* Feature : Email Notification Buffer to avoid failures due to exceeding server send limits
* Fixed : Email Notification - For pending revision submission, submitter was misidentified on some sites
* Fixed : Revisors could restore previous revisions through manual URL access
* Fixed : Fatal error when WP_Privacy_Policy_Content::text_change_check() is triggered
* Fixed : "Pending Revision" checkbox was displayed in Gutenberg editor, even for unpublished posts
* Fixed : After clicking "Pending Revision" checkbox, unchecking did not prevent revision save
* Fixed : Revision Preview - unsaved changes to saved revision could not be previewed with WP 5.3
* Fixed : Revision Preview - top bar for edit / approval was not displayed on some sites
* Change : Revision Preview URL - Default to using published post slug with revision page_id argument, for better theme compatibility. Option to use Revision slug or ID only.
* Fixed : Edit Revision screen links to published post discarded customized slug
* Fixed : Classic Editor - "View / Approve" link from Edit Revision screen loaded wrong preview URL and no top bar display for approval
* Fixed : Classic Editor - No preview button was available to Revisors
* Fixed : Classic Editor - Invalid Revisions > Browse link displayed to Revisors
* Compat : Classic Editor plugin - with "Allow users to switch editors" enabled, non-default editor did not have correct javascript loaded for Revisions
* Compat : On themes that use a fixed position header, display preview top bar above header
* Compat : PressPermit Pro - revision preview could not be viewed by Contributors under some configurations
* Fixed : On standard Compare Revisions screen (for past revisions), Preview and Manage button links did not update with slider selection change
* Fixed : Pending, Schedule Revision notification - invalid preview link in some emails
* Fixed : Trashed revisions were not identified as revisions in Edit Posts listing
* Fixed : Trashed revisions were not deleted on parent post deletion
* Fixed : Trashed revisions showed an invalid comment count value in Edit Posts listing
* Fixed : PHP Warning in Gutenberg editor when editing is not being limited to revision submission
* Compat : Multiple Authors - Compare Pending Revisions screen showed revisor as original post author under some conditions 
* Compat : Multiple Authors - Revision submission / approval caused published post author to be changed to revisor, under some conditions
* Compat : Plugin interaction caused published post permalink custom slug to be replaced with default permalink structure at revision publication, on some sites
* Change : Revision Queue - recaption "My Posts" to "My Published Posts"

= 2.0.12 - 29 Oct 2019 =
* Fixed : Fatal error on Post Preview

= 2.0.11 - 28 Oct 2019 =
* Fixed : Classic Editor - Post Preview showed last stored copy, not unsaved changes
* Fixed : Revision Preview top bar covered admin menu dropdown
* Fixed : Revision Edit - live preview showed revision author instead of published author (if Multiple Authors plugin not active)

= 2.0.10 - 25 Oct 2019 =
* Fixed : Post Preview showed last stored copy, not unsaved changes
* Fixed : Post Preview (to view unsaved changes) was not available when editing a revision
* Fixed : Revision Preview - Buttons were not clickable with some themes
* Fixed : Filter revisionary_default_pending_revision was not effective in Gutenberg (check Save as Revision checkbox by default)
* Compat : Multiple Authors - Incorrect author display in revision previews on some sites
* Compat : PressPermit - Database error on Revision Queue screen under some configurations

= 2.0.9 - 18 Oct 2019 =
* Fixed : Compare Pending Revisions screen - link redirected to Edit Posts screen for some post types

= 2.0.8 - 18 Oct 2019 =
* Change : PostMeta Failsafe: to avoid the possibility of accidental clearance, Featured Image removal is not revisioned, until further testing. API filter available for experimental usage with specified meta keys.
* Fixed : Featured Image, Page Template revisioning failed under some conditions
* Fixed : Scheduled Revisions created with Gutenberg stored selected terms to published post, previous terms to revision
* Fixed : Scheduled Revisions - If "Update Publish Date" enabled, 404 Not Found redirect after manually publishing a scheduled revision if the post type uses post date in permalink structure
* Fixed : Revision Preview - Buttons were not clickable with some themes
* Fixed : Settings - Disabling Pending or Scheduled Revisions did not remove UI from post editor
* Fixed : Settings - If Pending Revisions disabled, Revisor could still edit published posts

= 2.0.7 - 17 Oct 2019 =
* Fixed : Scheduled Revisions - published post tags and categories were stripped out on scheduled revision publication
* Fixed : Scheduled Revisions - manually publishing prior to scheduled time caused published post status to be set to Future (unpublished)

= 2.0.6 - 17 Oct 2019 =
* Fixed : Featured Image and Page Template revisions were not applied (but did work in PublishPress Revisions Pro)
* Fixed : Publishing a revision imported from Revisionary 1.x caused tags and categories to be stripped out

= 2.0.5 - 16 Oct 2019 =
* Fixed : Import script for Revisionary 1.x revisions did not run on plugin activation 
* Fixed : Administrators, Editors and Authors were blocked from Quick Edit
* Compat : Multiple Authors plugin
* Fixed : Pending Revisions - Published post date was not updated even if "Update Publish Date" setting enabled
* Change : Pending Revision Notification - Include link to Revision Queue
* Fixed : Pending Revision Notification - If enabled for author only, email was sent with a blank title and message
* Fixed : Empty Revision Queue was displayed to Subscribers with no Revision capabilities
* Fixed : PHP notices on Revision Queue screen

= 2.0.4 - 9 Oct 2019 =
* Change : On installation over Revisionary 1.x, display a "heads up" notice about plugin name change, admin menu and Revision Queue
* Fixed : Classic Editor - Revision Preview did not always include top bar (for Edit / Compare / Publish) if PressPermit Pro active
* Fixed : Revision Preview - Edit url did not work on installations with non-conventional admin paths, due to hardcoded /wp-admin
* Fixed : Schedule Revision notifications sent redundantly under some conditions
* Change : On Revision Edit, recaption Preview button to "View" to clarify that it's a preview of the saved revision, not unsaved changes. (Future release will make it a true preview).

= 2.0.3 - 3 Oct 2019 =
* Fixed : Revisionary settings could not be changed
* Fixed : Pending / Scheduled Revisions were listed in Revision Queue even if feature disabled in Revisions > Settings 
* Fixed : On post edit for revision, Revisors could not see the current or newly selected Featured Image
* Fixed : On revision edit, Administrators and Editors did not have Trash button available
* Fixed : Revisors could edit or delete their scheduled revisions
* Fixed : Scheduled revision publication did not work with "Asynchronous publishing" setting enabled
* Fixed : After revision publication reloading, the old revision preview returned "Not Found". Now redirects to published post and marks as "Current Revision"
* Fixed : PHP Notices throughout wp-admin when WP_DEBUG enabled
* Change : Revision Queue headline indicates when results are being filtered by post type, revision status, revision author or post author

= 2.0.2 - 2 Oct 2019 =
* Fixed : On post date change in Gutenberg editor, Publish button was recaptioned to "Schedule Revision" even on a past date selection (unless SCRIPT_DEBUG enabled)

= 2.0.1 - 2 Oct 2019 =
* Fixed : Fatal error if another copy of Revisionary already active

= 2.0.0 - 1 Oct 2019 =
* Feature : Submit revisions to Categories, Tags, Custom Terms, Page Parent, Featured Image, Page Template
* Feature : Revisions editable in Gutenberg, Classic Editor
* Feature : Voluntary pending revision submission by unrestricted editors in Gutenberg
* Feature : Revision Queue screen is a sortable, filterable list of pending and scheduled revisions for all post types
* Feature : Revision Queue screen includes "My Revisions" and "My Posts" filtering links
* Feature : Revision Queue - Published Posts have "History" link to compare past revisions
* Feature : Compare Revisions - for past revisions, add button links for "Preview / Restore" and "Manage"
* Feature : Compare Pending Revisions using standard WordPress UI (link from Editor or Revision Queue)
* Feature : Compare Scheduled Revisions using standard WordPress UI (link from Editor or Revision Queue)
* Feature : Compare Pending / Scheduled Revisions shows changes to Categories, Tags, Terms, Page Parent, Featured Image, Page Template
* Change : Improved styling for revision preview / approval top bar
* Feature : "Update Publish Date" setting for Pending Revisions (defaults to disabled)

= 1.3.8 - 30 Aug 2019 =
* Fixed : Revisors could Quick Edit published posts (changing post title, slug, author, date, parent or template) since version 1.3. This could be used to unpublish (but not publish) posts. Sites also running PressPermit Pro were not affected.
* Compat : PressPermit Pro - Under some configurations, Revisors were not allowed appropriate access (due to publish capability check)

= 1.3.7 - 24 May 2019 =
* Feature : Filter 'revisionary_default_pending_revision', return true to select "Send to Approval Queue" in Classic Editor by default

= 1.3.6 - 30 Apr 2019 =
* Fixed : Scheduled Revision publication updated post date even if "Update Publish Date" option disabled
* Fixed : Gutenberg: Pending, Scheduled Revisions did not work for post types with show_in_rest property set false 
* Fixed : PHP Notice if REST Posts query executed without a corresponding rest_base property set for post type 
* Fixed : Better hiding of non-applicable sidebar metaboxes when post is being edited for Pending Revision

= 1.3.5 - 3 Apr 2019 =
* Fixed : With Classic Editor, Revision submission reset Page Template

= 1.3.4 - 2 Apr 2019 =
* Fixed : Pending Revision Notifications were not sent from Gutenberg editor if configured to send "by default" (selectable recipients)

= 1.3.3 - 2 Apr 2019 =
* Fixed : Scheduled Revision preview: "Publish Now" link failed with a fatal error
* Change : Settings link in Plugins Row

= 1.3.2 - 29 Mar 2019 =
* Fixed : Email notifications were missing "Post" / "Page" caption
* Fixed : PHP notices with Classic Editor
* Fixed : With Classic Editor, revision approval from preview did not redirect back to Edit Posts / Pages screen
* Fixed : In Classic Editor, setting a future date did not recaption Publish button to "Schedule Revision" if post has private visibility

= 1.3.1 - 29 Mar 2019 =
* Fixed : Scheduled Revision publication stripped out categories and tags, if "Update Publish Date" setting enabled
* Fixed : Publish button was not recaptioned to Submit Revision under some conditions
* Change : With Gutenberg active, revision approval defaults to front end preview
* Feature : Better redirect logic following revision approval, scheduling or restoration (returns to screen that preview was linked from)
* Feature : Preview link in Notification Emails
* Feature : Previews of Scheduled Revisions and Pending Revisions with a future publish date include link to Revisions Manager to edit date
* Change : Dismissable welcome message: To allow a user to submit Revisions to your published posts, set their role to "Revisor" 

= 1.3.0 - 28 Mar 2019 =
* Feature : Gutenberg editor compatibility for Pending Revision, Scheduled Revision creation
* Feature : By default, Scheduled Revisions also update publish date. New checkbox on Revisions > Settings to restore previous behavior of leaving publish date unchanged.
* Feature : List Scheduled Revisions of any post type on Publishing Soon list in Activity dashboard widget
* Fixed : If Scheduled Revision was first site access after scheduled publication time, changes were not displayed until page reload
* Fixed : Scheduled post Revisions on Publishing Soon list in Activity dashboard widget had incorrect link
* Fixed : Past Revisions list on Revision Manager screen had invalid preview links
* Fixed : Better formatting for Publish Now / Schedule Now link
* Fixed : Editing revision publication date updated revision author, even if post content not changed
* Change : Use 12 hour format for revision dates
* Change : Pending Revision lists show submission date
* Change : Pending Revision lists show requested publication date if applicable 

= 1.2.7 - 13 Mar 2019 =
* Fixed : Pending Revision Notification on Multisite installations. Due to failure to apply settings, e-mail notifications defaulted to "By default" option, which failed for Pending Revisions prior to version 1.2.6.  
* Fixed : Multisite - If network-activated, Revisionary settings screens unavailable. Last stored network-wide settings (or hardcoded defaults) applied instead.
* Fixed : Multisite - If not network-activated, Revisionary settings screen was ineffective. Site-specific settings were stored, but network-wide settings or defaults applied instead.
* Fixed : "Display Hints" setting had no checkbox on Settings screen
* Change : Improved settings captions

= 1.2.6 - 13 Mar 2019 =
* Fixed : "Publishers to Notify" checkboxes were not displayed, and notifications not sent, if Email notification for Pending Revisions set to "By default"
* Fixed : Revision previews - PHP Warning and failure to output "Publish Now" header
* Change : Improved styling in "Publishers to Notify" metabox

= 1.2.5 - 25 Feb 2019 =
* Compat : TinyMCE Advanced - Failed to display editor on revision management screen
* Compat : Multisite - Incorrect site switching, prevents Yoast SEO from saving post meta 

= 1.2.4 - 20 Feb 2019 =
* Compat : PublishPress - publish button was hidden
* Change : Capitalize "Save as Pending Revision" checkbox caption
* Lang : Update .po file

= 1.2.3 - 19 Feb 2019 =
* FIXED : Scheduled revision publication failure, massive redundant email notifications (since 1.2)

= 1.2.2 - 19 Feb 2019 =
* Fixed : Temporarily disable scheduled revision publication emails, due to recently reported issue
* Compat : PHP / coding standards - removed needless byref variable assignments
* Fixed : PHP notices when viewing revision differences

= 1.2.1 - 14 Feb 2019 =
* Compat : Fatal error when another plugin hooks into 'user_has_cap' filter

= 1.2 - 13 Feb 2019 =
* Compat : PHP 7.2
* Compat : WordPress 5.0.3
* Fixed : Revision approval reset page template setting to default
* Team : Revisionary is now owned and developed by PublishPress. The original author (Kevin Behrens) is excited to join forces in building and supporting effective tools for publishing teams.

= 1.1.13 - 13 May 2015 =
* Fixed : Previewing a Page revision from Revisions Manager screen caused fatal error / white screen
* Fixed : When Previewing a revision, Publish Now link was not formatted properly on TwentyFifteen theme
* Fixed : Pending Revision counts, links were not displayed in Dashboard At a Glance if PP Collaborative Editing plugin is not active
* Compat : Jetpack Markdown - publishing a revision caused post content to be stripped
* Compat : various caching plugins - post cache was not cleared after publishing a revision

= 1.1.12 - 23 Dec 2013 =
* WP 3.8 - Fixed Revisionary > Settings styling
* Fixed : Email notifications were not sent on Pending Revision submission under some configurations
* Fixed : Email notifications were not sent upon Scheduled Revision publishing unless Press Permit / Role Scoper active and Scheduled Revision Monitors group populated
* Change : On network installations, email notifications to administrators will include super admins if constant RVY_NOTIFY_SUPER_ADMIN is defined
* Fixed : Network-wide Revisionary Options could not be modified
* Fixed : Revisions on Edit Posts screen were displayed with stored post title, ignoring modifications by previous filters (such as translations)
* Fixed : Administrator did not have "save as pending revision" option when post is currently scheduled for publishing
* Fixed : Revision Diff formatting (column alignment)
* Fixed : Revision preview from Revisions Manager screen not displayed correctly under some configurations
* Change : Revisions Manager screen marks a revision as "Current" only if it is published
* Change : Better consistency with standard Revisions Manager behavior: post-assigned Revisor role is sufficient to edit others' revisions, but post-assigned Contributor role is not
* Change : Better consistency with standard Revisions Manager behavior: prevent diff display of unreadable revisions
* Change : When comparing revisions, if only one of the revisions is past, force it to left
* Change : On Revisions Manager screen, add margins to Update Revision button
* Fixed : PHP Notices for non-static function calls
* Compat : Role Scoper - when Pending Revision Monitors group is used and notification is "by default", recipient checkboxes missing on Edit Post form and TinyMCE broken
* Compat : Duplicate Right Now links on dashboard if Role Scoper or Press Permit active

= 1.1.11 - 18 Aug 2013 =
* WP 3.6 - Revisors could not submit revisions
* WP 3.6 - Don't modify native WP revision links
* WP 3.6 - In Publish metabox, re-caption Revisions as "Publication History" to distinguish from Pending Revisions (prevent this by defining constant RVY_PREVENT_PUBHIST_CAPTION)
* WP 3.6 - Post Title metabox was unformatted on Revisions Manager screen
* Fixed : Publishers to Notify metabox was displayed even if no selections available (when notification for both Publishers and Author is set to Always or Never)
* Fixed : PHP warning in Publishers to Notify metabox when a user has a very long name
* Change : If Press Permit or Role Scoper are active but Monitors group does not contain any users who can publish the post, notifications go to all WP Administrators and Editors who have sufficient site-wide capabilities (prevent this by defining constant RVY_FORCE_MONITOR_GROUPS)
* Change : On Revisionary Settings screen, expand caption to clarify email notification behavior
* Fixed : Revisors could not select desired publish date on Edit Post screen, even if Scheduled Revisions enabled
* Fixed : "save as pending" checkbox caused poor layout of adjacent UI in Publish metabox
* Perf : Eliminate some redundant queries on back-end for non-Administrators (especially with Press Permit or Role Scoper active)
* Compat : Edit Flow - don't offer to revise EF Metadata

= 1.1.10 - 29 May 2013 =
* SECURITY FIX : Revisions could be viewed by any registered user
* Feature : Option to prevent Revisors from viewing other user's drafts and regular pending posts (imposes edit_others_drafts cap requirement)
* Fixed : Other users' revisions were viewable in Revisions Manager even if option to prevent is enabled
* Fixed : "Publishers to Notify" metabox not displayed under some configurations
* Fixed : "Publishers to Notify" metabox was displayed with checkboxes even if Revisionary settings are for both editors and author to always receive notification
* Fixed : Email Notification for Pending Revision was not sent under some configurations
* Fixed : Monitor Groups (with Press Permit or Role Scoper activated) did not regulate email notifications
* Fixed : Users who cannot approve a revision received email notification under some configurations
* Fixed : PHP warnings for deprecated WP function calls
* Fixed : PHP warnings when "previewing" current revision
* Fixed : Invalid notifications were sent on revision submission error
* Fixed : JS warning on Edit Post form
* Compat : Press Permit Core
* Compat : Press Permit - revision previews could not be viewed by revisor (also requires PP Collaborative Editing 2.0.14-beta)
* Compat : CForms (and possibly other plugins) - tinyMCE buttons were suppressed

= 1.1.9 - 18 Jan 2012 =
* Compat : Press Permit - PP roles were not applied under some configurations
* Compat : Role Scoper - RS roles were not applied under some configurations (related fixes in RS 1.3.52)
* Fixed: PHP Warning for mysql_get_server_info()

= 1.1.8 - 20 Dec 2011 =
* Compat : Role Scoper - duplicate Pending counts in Dashboard Right Now
* API : new filter - rvy_hidden_meta_boxes
* API : new action: - rvy-revisions_sidebar
* API : new action - rvy-revisions_meta_boxes
* API : new action - revision_approved
* API : new action - post_revision_update

= 1.1.7 - 11 Nov 2011 =
* Compat : WP 3.3 - Revision Editor displayed redundantly, didn't work
* Compat : Press Permit integration
* Feature : By default, Revisor role does not enable editing other users' revisions (option to re-enable)
* Fixed : If Visual Editor is disabled, html entities not displayed or updated correctly in Revisions Manager
* Fixed : About Revisionary screen (linked from help menu) failed to display
* Fixed : Revision previews used wrong template under some configurations
* Fixed : Various PHP Notices

= 1.1.6 - 7 Sep 2011 =
* Fixed : Quick Edit was not disabled for Page Revisions, usage resulted in invalid revision data
* Fixed : Revisionary Options were not available when plugin activatated per-site on a Multisite installation
* Fixed : For Multisite installation, Revisionary Options on Sites menu caused a fatal error
* Change : For Multisite installation, Revisionary Options Blog/Site captions changed to Site/Network
* Fixed : Revised Post Title was not displayed in Revisions Manager
* Fixed : Various PHP Notices

= 1.1.5 - 29 June 2011 =
* Fixed : Markup error in Revisions Manager for Administrators / Editors, especially noticeable in WP 3.2
* Fixed : "save as pending revision" checkbox in Publish metabox caused formatting error with IE9
* Fixed : Previews did not display post thumbnail or other meta data
* Fixed : Previews could not be displayed for past revisions
* Compat : WP 3.2 - revision previews did not work
* Compat : WP 3.2 - preview link not displayed for Pending Revisions in edit.php listing
* Compat : Builder theme - previews of page revisions could not be displayed
* Compat : Events Calendar Pro - filtering fails when WP database prefix is non-default
* Change : Better styling for revision approval link displayed above preview
* Change : Remove Asynchronous Email option
* Change : Change all require and include statements to absolute path to work around oddball servers that can't handle relative paths
* Change : jQuery syntax change for forward compatibility

= 1.1.4 - 5 Apr 2011 =
* Fixed : Role Options, Role Defaults menu items were not available on 3.1 multisite
* Fixed : Pending / Scheduled Revisions could not be previewed by Revisors
* Fixed : "Submit Revision" button caption changed to "Update" or "Schedule" following publish date selection
* Fixed : PHP Warning on post creation / update
* Change : Hide Preview button from Revisors when editing for pending revision submission

= 1.1.3 - 3 Dec 2010 =
* Fixed : Autosave error message displayed while a revisor edits a published post prior to submitting a pending revision
* Fixed : Email notifications failed on some servers if Asynchronous option enabled
* Compat : Role Scoper - With RS 1.3 to 1.3.12, if another plugin (Events Manager) triggers a secondary edit_posts cap check when a Revisor attempts to edit another user's unpublished post, a pending revision is generated instead of just updating the unpublished post

= 1.1.2 - 29 Nov 2010 =
* Compat : Role Scoper - Post-assigned Revisor role was not honored to update another users' revision with RS 1.3+
* Fixed : While in Revisions Manager, invalid "Revisions" submenu link was displayed in Settings menu

= 1.1.1 - 5 Nov 2010 =
* Fixed : Fatal Error if theme displays post edit link on front end
* Fixed : Did not observe capability definitions for custom post types (assumed capability_type = post_type)
* Compat : Event Calendar Pro - revisions of sp_events were not included in Edit Posts listing due to postmeta clause applied by ECP

= 1.1 - 2 Nov 2010 =
* Fixed : Revision Approval notices were not sent if "always send" option enabled
* Feature : "save as pending revision" option when logged user has full editing capabilities in Edit Post/Page form

= 1.1.RC3 - 29 Oct 2010 =
* Fixed : Revision preview link returned 404 (since 1.1.RC)
* Fixed : Revision Approval emails were not sent reliably with "Asynchronous Email" option enabled (since 1.0)
* Fixed : Custom taxonomy selection UI was not hidden when submitting a revision
* Fixed : In Quick Edit form, Published option sometimes displayed inappropriately

= 1.1.RC.2 - 11 Oct 2010 =
* Fixed : Listed revisions in Revision Editor were not linked for viewing / editing (since 1.1.RC)

= 1.1.RC - 8 Oct 2010 =
* Feature : Support Custom Post Types
* Change : Better internal support for custom statuses
* Fixed : On Options page, links to "Pending Revision Monitors" and "Scheduled Revision Monitors" were reversed
* Fixed : Revision Edit link from Edit Posts/Pages listing led to uneditable revision display
* Change : Raise minimum WP version to 3.0

= 1.0.7 - 21 June 2010 =
* Fixed : Revisionary prevented the normal scheduling of drafts for first-time publishing

= 1.0.6 - 18 June 2010 =
* Compat : CForms conflict broke TinyMCE edit form in Revisions Manager 

= 1.0.5 - 7 May 2010 =
* Compat : WP 3.0 Multisite menu items had invalid link

= 1.0.4 - 6 May 2010 =
* Fixed : Pending Revision Approval email used invalid permalink if permalink structure changed since original post storage
* Fixed : Schedule Revision Publication email used invalid permalink if permalink structure changed since original post storage

= 1.0.3 - 6 May 2010 =
* Compat : WP 3.0 elimination of page.php, edit-pages.php, page-new.php broke many aspects of page filtering
* Fixed : Trash link did not work for revisions in Edit Posts/Pages listing
* Change : Administrators and Editors now retain Quick Edit link for non-revisions in Edit Pages, Edit Posts listing
* Fixed : "Publishers to Notify" metabox was included even if no eligible recipients are designated

= 1.0.2 - 11 Mar 2010 =
* Fixed : Email notification caused error if Role Scoper was not activated
* Fixed : Database error message (nuisance) in non-MU installations (SELECT meta_key, meta_value FROM WHERE site_id...)
* Fixed : Publish Now link on Scheduled Revision preview did not work
* Fixed : With WP > 2.9, newly published revisions also remained listed as a Pending or Scheduled revision
* Fixed : With WP > 2.9, revision date selection UI showed "undefined" caption next to new date selection
* Fixed : Link for viewing Scheduled Revisions was captioned as "Pending Revisions" (since 1.0.1) 
* Compat : WMPL plugin

= 1.0.1 - 6 Feb 2010 =
* Fixed : 	Submitting a Pending Revision to a published Post failed with Fatal Error
* Fixed : 	PHP short tag caused Parse Error on servers which were not configured to support it
* Compat :  Support TinyMCE Advanced and WP Super Edit for custom editor buttons on Revision Management form
* Feature : Revision preview bar can be styled via CSS file
* Lang 	 : 	Fixed several string formatting issues for better translation support
* Change : 	Use https link for Revisionary css and js files if ssl is being used / forced for the current uri

= 1.0 - 30 Dec 2009 =
* Feature : Use Blog Title and Admin Email as from address in revision notices, instead of "WordPress <wordpress@>"
* Fixed : Revision Approval / Publication Notices used p=ID link instead of normal post permalink
* Compat : Display workaround instructions for FolioPress conflict with visual revision display

= 1.0.RC1 - 12 Dec 2009 =
Initial release.  Feature Changes and Bug Fixes are vs. Pending Revisions function in Role Scoper 1.0.8

* Feature : Scheduled Revisions - submitter can specify a desired publication date for a revision
* Feature : Any user with the delete_published_ and edit_published capabilities for a post/page can administer its revisions (must include those caps in RS Editor definitions and assign that role)
* Feature : Scheduled Publishing and Email notification is processed asynchronously
* Feature : Dedicated Revisions Manager provides more meaningful captions, classified by Past / Pending / Scheduled
* Feature : RS Revision Manager form displays visually via TinyMCE, supports editing of content, title and date
* Feature : Revisions Manager supports individual or bulk deletion
* Feature : Users can view their own Pending and Scheduled Revisions
* Feature : Users can delete their own Pending Revisions until approval
* Feature : Preview a Pending Revision, with top link to publish / schedule it
* Feature : Preview a Scheduled Revision, with top link fo publish it now
* Feature : Preview a Past Revision, with top link for restore it
* Feature : Pending and Scheduled revisions are included in Edit Posts / Pages list for all qualified users
* Feature : Delete, View links on revisions in Edit Posts / Pages list redirect to RS Revisions Manager
* Feature : Add pending posts and pages total to Dashboard Right Now list (includes both new post submissions and Pending Revisions)
* Feature : Metaboxes in Edit Post/Page form for Pending / Scheduled Revisions
* Fixed : Multiple Pending Revions created by autosave
* Fixed : Users cannot preview their changes before submitting a Pending Revision on a published post/page
* Fixed : Pending Post Revisions were not visible to Administrator in Edit Posts list
* Fixed : Both Pending Page Revisions and Pending Post Revisions were visible to Administator in Edit Pages list
* Fixed : Pending Revisions were not included in list for restoration
* Fixed : Bulk Deletion attempt failed when pending / scheduled revisions were included in selection 
* Feature : Optional email (to editors or post author) on Pending Revision submission
* Feature : Optional email (to editors, post author, or revisor) on Pending Revision approval
* Feature : Optional email (to editors, post author, or revisor) on Scheduled Revision publication
* Feature : If Role Scoper is active, Editors notification group can be customized via User Group
