<?php
/**
 * Шаблон за списък с ревюта
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// Template variables are local scope, not global


$product_id = intval($atts['product_id']);
$limit = intval($atts['limit']);

// Whitelist validation for orderby parameter
$allowed_orderby = array('created_at' => 'created_at', 'date' => 'created_at', 'rating' => 'rating', 'name' => 'name', 'id' => 'id');
$orderby_raw = isset($atts['orderby']) ? sanitize_key($atts['orderby']) : 'created_at';
$orderby = isset($allowed_orderby[$orderby_raw]) ? $allowed_orderby[$orderby_raw] : 'created_at';

// Validate order direction
$order_raw = isset($atts['order']) ? sanitize_key($atts['order']) : 'DESC';
$order = strtoupper($order_raw) === 'ASC' ? 'ASC' : 'DESC';

$show_images = $atts['show_images'] === 'yes';
$show_videos = $atts['show_videos'] === 'yes';

// Проверяваме дали ревютата трябва да се показват
$settings = get_option('reviewxpress_settings', array());
$show_reviews = !empty($settings['show_reviews']);
$show_reviews_section = !empty($settings['show_reviews_section']);
$reviews_display_type = isset($settings['reviews_display_type']) ? $settings['reviews_display_type'] : 'woocommerce_tab';
$template = isset($settings['reviews_template']) ? $settings['reviews_template'] : 'default';

// Параметър за принудително показване (използва се когато се извиква от таба)
$force_display = isset($atts['force_display']) && $atts['force_display'] === 'yes';

// Не показваме ревютата ако:
// 1. show_reviews е изключено (освен ако не е force_display)
// 2. show_reviews_section е изключено (освен ако не е force_display)
// 3. reviews_display_type е 'shortcode' (трябва да се показват само чрез шорткод, освен ако не е force_display)
// Note: При 'woocommerce_tab' режим shortcode-ът се извиква в таба и трябва да се показва
if (!$force_display && (!$show_reviews || !$show_reviews_section || $reviews_display_type === 'shortcode')) {
    // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain
    return '<p>' . __('Displaying reviews is disabled by administrator.', 'reviewxpress') . '</p>';
}

$database = new ReviewXpress_Database();
$reviews = $database->get_reviews($product_id, array(
    'status' => 'approved',
    'limit' => $limit,
    'orderby' => $orderby,
    'order' => $order
));


$stats = $database->get_product_stats($product_id);

?>

<div class="reviewxpress-list-container" 
     id="reviewxpress-list-<?php echo esc_attr($product_id); ?>"
     data-product-id="<?php echo esc_attr($product_id); ?>"
     data-orderby="<?php echo esc_attr($orderby); ?>"
     data-order="<?php echo esc_attr($order); ?>"
     data-total-reviews="<?php echo esc_attr(count($reviews)); ?>"
     data-reviews-per-page="<?php echo esc_attr(isset($settings['reviews_per_page']) ? intval($settings['reviews_per_page']) : 5); ?>">
    <?php if ($stats->total_reviews > 0): ?>
    <!-- Статистики за рейтинга -->
    <div class="rx-rating-summary">
        <?php echo wp_kses_post(ReviewXpress_Frontend::render_rating_stats($product_id)); ?>
    </div>
    
    <!-- Сортиране -->
    <div class="rx-sorting-container">
        <?php echo wp_kses_post(ReviewXpress_Frontend::render_sorting($orderby, $order)); ?>
    </div>
    <?php endif; ?>
    
    <!-- Списък с ревюта -->
    <?php
    // Get integration settings
    $settings = get_option('reviewxpress_settings', array());
    $custom_css_enabled = !empty($settings['custom_css_enabled']);
    $custom_css_class = $custom_css_enabled ? $settings['custom_css_class'] ?? '' : '';
    $custom_css_id = $custom_css_enabled ? $settings['custom_css_id'] ?? '' : '';
    
    // Build classes
    $classes = array('rx-reviews-list', 'reviewxpress-reviews');
    if ($template === 'side_by_side') {
        $classes[] = 'side-by-side';
    }
    if (!empty($custom_css_class)) {
        $classes[] = sanitize_html_class($custom_css_class);
    }
    
    // Build ID
    $container_id = !empty($custom_css_id) ? sanitize_html_class($custom_css_id) : 'rx-reviews-list';
    ?>
    <div class="<?php echo esc_attr(implode(' ', $classes)); ?>" id="<?php echo esc_attr($container_id); ?>">
        <?php if (empty($reviews)): ?>
        <div class="rx-no-reviews">
            <?php // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain ?>
            <p><?php echo ReviewXpress_Frontend::esc_text_for_output($settings['tr_label_no_reviews'] ?? __('No reviews for this product yet.', 'reviewxpress')); ?></p>
        </div>
        <?php else: ?>
        <?php foreach ($reviews as $review): ?>
        <?php if ($template === 'side_by_side'): ?>
        <!-- Страничен темплейт -->
        <div class="rx-review-item rx-review-side-by-side" data-review-id="<?php echo esc_attr($review->id); ?>">
            <div class="review-content">
                <div class="review-header">
                    <?php if (!empty($review->avatar_url)): ?>
                        <img class="review-avatar rx-clickable-image" src="<?php echo esc_url($review->avatar_url); ?>" alt="Avatar" data-full-image="<?php echo esc_url($review->avatar_url); ?>" />
                    <?php endif; ?>
                    <div class="review-author"><?php 
                    // fix_utf8_display() вече обработва encoding-а - не правим допълнителни конверсии
                    echo ReviewXpress_Frontend::esc_text_for_output($review->name);
                    ?></div>
                    <div class="review-rating">
                        <?php echo wp_kses_post(ReviewXpress_Frontend::render_stars($review->rating)); ?>
                    </div>
                </div>
                
                <?php if (!empty($review->review_text)): ?>
                <div class="review-text">
                    <?php 
                    echo nl2br(ReviewXpress_Frontend::esc_text_for_output($review->review_text));
                    ?>
                </div>
                <?php endif; ?>
                
                <div class="review-date">
                    <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($review->created_at))); ?>
                </div>
                
                <div class="review-actions">
                    <?php 
                    // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain
                    $helpful_label = !empty($settings['tr_label_helpful']) ? $settings['tr_label_helpful'] : __('Helpful', 'reviewxpress');
                    $helpful_count = $database->get_helpful_count($review->id);
                    $remote_addr = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR'])) : '';
                    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_USER_AGENT'])) : '';
                    $user_key = md5($remote_addr . $user_agent . $review->id);
                    $user_voted = $database->has_user_voted($review->id, $user_key);
                    $is_helpful = $user_voted === 1;
                    ?>
                    <button type="button" class="rx-helpful-btn <?php echo esc_attr($is_helpful ? 'rx-helpful-active' : ''); ?>" data-review-id="<?php echo esc_attr($review->id); ?>">
                        <span class="rx-helpful-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($helpful_label); ?></span>
                        <span class="rx-helpful-count">(<?php echo esc_html($helpful_count); ?>)</span>
                    </button>
                </div>
            </div>
            
            <?php if (!empty($review->media) && ($show_images || $show_videos)): ?>
            <div class="review-media">
                <?php 
                $filtered_media = array();
                foreach ($review->media as $media) {
                    if (($media['type'] === 'image' && $show_images) || 
                        ($media['type'] === 'video' && $show_videos)) {
                        $filtered_media[] = $media;
                    }
                }
                echo wp_kses_post(ReviewXpress_Frontend::render_media($filtered_media, $template));
                ?>
            </div>
            <?php endif; ?>
        </div>
        <?php elseif ($template === 'modern'): ?>
        <!-- Модерен темплейт -->
        <div class="rx-review-item rx-review-modern" data-review-id="<?php echo esc_attr($review->id); ?>">
            <div class="rx-review-modern-content">
                <div class="rx-review-modern-text">
                    <div class="rx-review-header">
                        <div class="rx-review-author">
                            <?php if (!empty($review->avatar_url)): ?>
                                <img class="rx-avatar rx-clickable-image" src="<?php echo esc_url($review->avatar_url); ?>" alt="Avatar" data-full-image="<?php echo esc_url($review->avatar_url); ?>" />
                            <?php endif; ?>
                            <div class="rx-author-info">
                                <strong><?php 
                                // fix_utf8_display() вече обработва encoding-а - не правим допълнителни конверсии
                                echo ReviewXpress_Frontend::esc_text_for_output($review->name);
                                ?></strong>
                                <div class="rx-review-rating">
                                    <?php echo wp_kses_post(ReviewXpress_Frontend::render_stars($review->rating)); ?>
                                </div>
                            </div>
                        </div>
                        <div class="rx-review-date">
                            <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($review->created_at))); ?>
                        </div>
                    </div>
                    
                    <?php if (!empty($review->review_text)): ?>
                    <div class="rx-review-content">
                        <?php 
                        echo nl2br(ReviewXpress_Frontend::esc_text_for_output($review->review_text));
                        ?>
                    </div>
                    <?php endif; ?>
                    
                    <div class="rx-review-actions">
                        <?php 
                    // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain
                    $helpful_label_modern = !empty($settings['tr_label_helpful']) ? $settings['tr_label_helpful'] : __('Helpful', 'reviewxpress');
                        $helpful_count = $database->get_helpful_count($review->id);
                        $remote_addr = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR'])) : '';
                        $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_USER_AGENT'])) : '';
                        $user_key = md5($remote_addr . $user_agent . $review->id);
                        $user_voted = $database->has_user_voted($review->id, $user_key);
                        $is_helpful = $user_voted === 1;
                        ?>
                        <button type="button" class="rx-helpful-btn <?php echo esc_attr($is_helpful ? 'rx-helpful-active' : ''); ?>" data-review-id="<?php echo esc_attr($review->id); ?>">
                            <span class="rx-helpful-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($helpful_label_modern); ?></span>
                            <span class="rx-helpful-count">(<?php echo esc_html($helpful_count); ?>)</span>
                        </button>
                    </div>
                </div>
                
                <?php if (!empty($review->media) && ($show_images || $show_videos)): ?>
                <div class="rx-review-modern-media">
                    <?php 
                    $filtered_media = array();
                    foreach ($review->media as $media) {
                        if (($media['type'] === 'image' && $show_images) || 
                            ($media['type'] === 'video' && $show_videos)) {
                            $filtered_media[] = $media;
                        }
                    }
                    echo wp_kses_post(ReviewXpress_Frontend::render_media($filtered_media, $template));
                    ?>
                    <?php if (count($filtered_media) > 1): ?>
                    <div class="rx-media-indicator">
                        <span class="rx-media-count">+<?php echo count($filtered_media) - 1; ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php else: ?>
        <!-- Основен темплейт - Нов Layout -->
        <div class="rx-review-item rx-review-new-layout" data-review-id="<?php echo esc_attr($review->id); ?>">
            <!-- Ред 1: Аватар + Име отляво, Рейтинг отдясно -->
            <div class="rx-review-header-row">
                <div class="rx-review-author-info">
                    <?php if (!empty($review->avatar_url)): ?>
                        <img class="rx-avatar rx-clickable-image" src="<?php echo esc_url($review->avatar_url); ?>" alt="Avatar" data-full-image="<?php echo esc_url($review->avatar_url); ?>" />
                    <?php endif; ?>
                    <strong class="rx-author-name"><?php 
                    // fix_utf8_display() вече обработва encoding-а - не правим допълнителни конверсии
                    echo ReviewXpress_Frontend::esc_text_for_output($review->name);
                    ?></strong>
                </div>
                <div class="rx-review-rating-header">
                    <?php echo wp_kses_post(ReviewXpress_Frontend::render_stars($review->rating)); ?>
                </div>
            </div>
            
            <!-- Ред 2: Коментар отляво, Снимка отдясно -->
            <div class="rx-review-content-row">
                <div class="rx-review-text-side">
                    <?php if (!empty($review->review_text)): ?>
                    <div class="rx-review-content">
                        <?php 
                        echo nl2br(ReviewXpress_Frontend::esc_text_for_output($review->review_text));
                        ?>
                    </div>
                    <?php endif; ?>
                </div>
                <?php if (!empty($review->media) && ($show_images || $show_videos)): ?>
                <div class="rx-review-media-side">
                    <?php 
                    $filtered_media = array();
                    foreach ($review->media as $media) {
                        if (($media['type'] === 'image' && $show_images) || 
                            ($media['type'] === 'video' && $show_videos)) {
                            $filtered_media[] = $media;
                        }
                    }
                    if (!empty($filtered_media)) {
                        echo wp_kses_post(ReviewXpress_Frontend::render_media($filtered_media, $template));
                    }
                    ?>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Ред 3: Дата и Полезно вот -->
            <div class="rx-review-footer-row">
                <div class="rx-review-date">
                    <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($review->created_at))); ?>
                </div>
                <div class="rx-review-actions">
                    <?php 
                    // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain
                    $helpful_label_default = !empty($settings['tr_label_helpful']) ? $settings['tr_label_helpful'] : __('Helpful', 'reviewxpress');
                    $helpful_count = $database->get_helpful_count($review->id);
                    $remote_addr = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field(wp_unslash($_SERVER['REMOTE_ADDR'])) : '';
                    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_USER_AGENT'])) : '';
                    $user_key = md5($remote_addr . $user_agent . $review->id);
                    $user_voted = $database->has_user_voted($review->id, $user_key);
                    $is_helpful = $user_voted === 1;
                    ?>
                    <button type="button" class="rx-helpful-btn <?php echo esc_attr($is_helpful ? 'rx-helpful-active' : ''); ?>" data-review-id="<?php echo esc_attr($review->id); ?>">
                        <span class="rx-helpful-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($helpful_label_default); ?></span>
                        <span class="rx-helpful-count">(<?php echo esc_html($helpful_count); ?>)</span>
                    </button>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php endforeach; ?>
        <?php endif; ?>
    </div>
    
    <!-- Зареждане на още ревюта -->
    <?php if (count($reviews) === $limit): ?>
    <div class="rx-load-more-container">
        <button type="button" class="rx-load-more-btn" id="rx-load-more">
            <?php // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain ?>
            <?php echo ReviewXpress_Frontend::esc_text_for_output($settings['tr_label_load_more'] ?? __('Load More Reviews', 'reviewxpress')); ?>
        </button>
    </div>
    <?php endif; ?>
</div>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

