<?php
/**
 * Шаблон за форма за ревю
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// Template variables are local scope, not global

$product_id = intval($atts['product_id']);
$show_title = $atts['show_title'] === 'yes';

$settings = get_option('reviewxpress_settings', array());
$max_images = !empty($settings['max_images']) ? intval($settings['max_images']) : 5;
$max_video_size = !empty($settings['max_video_size']) ? intval($settings['max_video_size']) : 50;
$allowed_image_types = !empty($settings['allowed_image_types']) ? $settings['allowed_image_types'] : 'jpg,jpeg,png';

// Проверяваме дали формата трябва да се показва
$show_form_in_reviews_section = !empty($settings['show_form_in_reviews_section']);
$form_display_type = isset($settings['form_display_type']) ? $settings['form_display_type'] : 'position';

// Не показваме формата ако show_form_in_reviews_section е изключено
if (!$show_form_in_reviews_section) {
    return '<p>' . __('Review form is disabled by administrator.', 'reviewxpress') . '</p>';
}
?>

<div class="reviewxpress-form-container" id="reviewxpress-form-<?php echo esc_attr($product_id); ?>">
    <?php if ($show_title): ?>
    <h3 class="reviewxpress-form-title"><?php echo ReviewXpress_Frontend::esc_text_for_output($settings['tr_label_submit'] ?? __('Leave a Review', 'reviewxpress')); ?></h3>
    <?php endif; ?>
    
    <?php
    // Get integration settings (вече са заредени по-горе, но уверяваме се че са налични)
    if (empty($settings)) {
    $settings = get_option('reviewxpress_settings', array());
    }
    $custom_css_enabled = !empty($settings['custom_css_enabled']);
    $custom_css_class = $custom_css_enabled ? $settings['custom_css_class'] ?? '' : '';
    $custom_css_id = $custom_css_enabled ? $settings['custom_css_id'] ?? '' : '';
    
    // Build classes
    $classes = array('reviewxpress-form', 'rx-review-form');
    if (!empty($custom_css_class)) {
        $classes[] = sanitize_html_class($custom_css_class);
    }
    
    // Build ID
    $form_id = !empty($custom_css_id) ? sanitize_html_class($custom_css_id . '-form') : 'reviewxpress-form';
    ?>
    <form class="<?php echo esc_attr(implode(' ', $classes)); ?>" id="<?php echo esc_attr($form_id); ?>" data-product-id="<?php echo esc_attr($product_id); ?>">
        <?php wp_nonce_field('reviewxpress_nonce', 'reviewxpress_nonce'); ?>
        <input type="hidden" name="product_id" value="<?php echo esc_attr($product_id); ?>">
        
        <div class="rx-avatar-and-fields">
            <div class="rx-avatar-section">
                <div class="rx-form-group">
                    <?php 
                    $label_avatar = !empty($settings['tr_label_avatar']) ? $settings['tr_label_avatar'] : __('Profile Picture (Avatar)', 'reviewxpress');
                    $text_drag_image = !empty($settings['tr_label_drag_image']) ? $settings['tr_label_drag_image'] : __('Drag an image here or click to select', 'reviewxpress');
                    $text_avatar_help = !empty($settings['tr_label_avatar_help']) ? $settings['tr_label_avatar_help'] : __('One image. Recommended 200x200px, JPG/PNG.', 'reviewxpress');
                    ?>
                    <label for="rx-avatar" class="rx-avatar-label"><?php echo ReviewXpress_Frontend::esc_text_for_output($label_avatar); ?></label>
                    <div class="rx-upload-area rx-upload-area-small" id="rx-avatar-upload">
                        <div class="rx-upload-placeholder">
                            <span class="rx-upload-icon">&#128100;</span>
                            <p><?php echo ReviewXpress_Frontend::esc_text_for_output($text_drag_image); ?></p>
                            <small><?php echo ReviewXpress_Frontend::esc_text_for_output($text_avatar_help); ?></small>
                        </div>
                        <input type="file" id="rx-avatar" name="avatar_file" accept="image/*" style="display: none;">
                    </div>
                    <div class="rx-uploaded-avatar" id="rx-uploaded-avatar"></div>
                </div>
            </div>
            
            <div class="rx-fields-section">
                <div class="rx-form-group">
                    <label for="rx-name">
                        <?php 
                        $label_name = !empty($settings['tr_label_name']) ? $settings['tr_label_name'] : __('Name', 'reviewxpress');
                        ?>
                        <span class="rx-label-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($label_name); ?></span>
                        <span class="rx-required-asterisk">*</span>
                    </label>
                    <input type="text" id="rx-name" name="name" required>
                </div>
                
                <div class="rx-form-group">
                    <label for="rx-email">
                        <?php 
                        $label_email = !empty($settings['tr_label_email']) ? $settings['tr_label_email'] : __('Email', 'reviewxpress');
                        ?>
                        <span class="rx-label-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($label_email); ?></span>
                        <span class="rx-required-asterisk">*</span>
                    </label>
                    <input type="email" id="rx-email" name="email" required>
                    <?php 
                    $text_email_help = !empty($settings['tr_label_email_help']) ? $settings['tr_label_email_help'] : __('Email must match an order in WooCommerce.', 'reviewxpress');
                    ?>
                    <small class="rx-form-help"><?php echo ReviewXpress_Frontend::esc_text_for_output($text_email_help); ?></small>
                </div>
                
                <div class="rx-form-group">
                    <label>
                        <?php 
                        $label_rating = !empty($settings['tr_label_rating']) ? $settings['tr_label_rating'] : __('Rating', 'reviewxpress');
                        ?>
                        <span class="rx-label-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($label_rating); ?></span>
                        <span class="rx-required-asterisk">*</span>
                    </label>
                    <div class="rx-rating-input">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <input type="radio" id="rx-rating-<?php echo esc_attr($i); ?>" name="rating" value="<?php echo esc_attr($i); ?>">
                            <label for="rx-rating-<?php echo esc_attr($i); ?>" class="rx-star-label">&#9733;</label>
                        <?php endfor; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="rx-form-group">
            <?php 
            $label_review = !empty($settings['tr_label_review']) ? $settings['tr_label_review'] : __('Review', 'reviewxpress');
            ?>
            <label for="rx-review-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($label_review); ?></label>
            <?php 
            $review_placeholder = !empty($settings['tr_label_review_placeholder']) ? $settings['tr_label_review_placeholder'] : __('Share your opinion about the product...', 'reviewxpress');
            ?>
            <textarea id="rx-review-text" name="review_text" rows="5" placeholder="<?php echo esc_attr($review_placeholder); ?>"></textarea>
        </div>
        
        <!-- Медия секция с toggle -->
        <div class="rx-media-section">
            <div class="rx-media-toggle">
                <button type="button" class="rx-toggle-btn" data-target="rx-media-content">
                    <span class="rx-toggle-icon">&#128206;</span>
                    <span class="rx-toggle-text"><?php esc_html_e('Add Media (Optional)', 'reviewxpress'); ?></span>
                    <span class="rx-toggle-arrow">&#9660;</span>
                </button>
            </div>
            
            <div class="rx-media-content" id="rx-media-content" style="display: none;">
                <div class="rx-media-tabs">
                    <button type="button" class="rx-tab-btn active" data-tab="images"><?php esc_html_e('Images', 'reviewxpress'); ?></button>
                    <button type="button" class="rx-tab-btn" data-tab="youtube"><?php esc_html_e('YouTube', 'reviewxpress'); ?></button>
                    <button type="button" class="rx-tab-btn" data-tab="video"><?php esc_html_e('Video File', 'reviewxpress'); ?></button>
                </div>
                
                <div class="rx-tab-content">
                    <!-- Снимки таб -->
                    <div class="rx-tab-pane active" id="rx-tab-images">
                        <div class="rx-upload-area" id="rx-image-upload" data-max-images="<?php echo intval($max_images); ?>">
                            <div class="rx-upload-placeholder">
                                <span class="rx-upload-icon">&#128247;</span>
                                <p><?php esc_html_e('Drag images here or click to select', 'reviewxpress'); ?></p>
                                <small><?php 
                                // translators: %1$d is the maximum number of images, %2$s is the allowed file types
                                printf(esc_html__('Maximum %1$d images. Allowed formats: %2$s', 'reviewxpress'), esc_html($max_images), esc_html($allowed_image_types)); 
                                ?></small>
                            </div>
                            <input type="file" id="rx-images" name="images[]" multiple accept="image/*" style="display: none;">
                        </div>
                        <div class="rx-uploaded-images" id="rx-uploaded-images"></div>
                    </div>
                    
                    <!-- YouTube таб -->
                    <div class="rx-tab-pane" id="rx-tab-youtube">
                        <div class="rx-form-group">
                            <label for="rx-video-url"><?php esc_html_e('YouTube Link', 'reviewxpress'); ?></label>
                            <input type="url" id="rx-video-url" name="video_url" placeholder="https://www.youtube.com/watch?v=...">
                            <small class="rx-form-help"><?php esc_html_e('Enter the full YouTube URL', 'reviewxpress'); ?></small>
                        </div>
                    </div>
                    
                    <!-- Видео файл таб -->
                    <div class="rx-tab-pane" id="rx-tab-video">
                        <div class="rx-upload-area" id="rx-video-upload">
                            <div class="rx-upload-placeholder">
                                <span class="rx-upload-icon">&#127909;</span>
                                <p><?php esc_html_e('Drag video here or click to select', 'reviewxpress'); ?></p>
                                <small><?php 
                                // translators: %d is the maximum video size in MB
                                printf(esc_html__('Maximum size: %d MB. Allowed formats: MP4, MOV, AVI', 'reviewxpress'), esc_html($max_video_size)); 
                                ?></small>
                            </div>
                            <input type="file" id="rx-video" name="video_file" accept="video/*" style="display: none;">
                        </div>
                        <div class="rx-uploaded-video" id="rx-uploaded-video"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="rx-form-actions">
            <div class="rx-brand">
                <a href="https://wpsupporting.com/plugins/reviewxpress/" target="_blank" rel="noopener" class="rx-brand-link">
                    <span class="rx-brand-text">ReviewXpress</span>
                    <span class="rx-brand-by">by wpsupporting.com</span>
                </a>
            </div>
            <?php 
            // Уверяваме се че settings се зареждат правилно
            $submit_text = !empty($settings['tr_label_submit']) ? $settings['tr_label_submit'] : __('Submit Review', 'reviewxpress');
            
            // Ако все още е празно, използваме fallback
            if (empty($submit_text)) {
                $submit_text = 'Submit Review';
            }
            ?>
            <button type="submit" class="rx-submit-btn" data-original-text="<?php echo esc_attr($submit_text); ?>">
                <span class="rx-btn-text"><?php echo ReviewXpress_Frontend::esc_text_for_output($submit_text); ?></span>
                <span class="rx-btn-loading" style="display: none;"><?php esc_html_e('Submitting...', 'reviewxpress'); ?></span>
            </button>
        </div>
        
        <div class="rx-form-message" id="rx-form-message" style="display: none;"></div>
    </form>
</div>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

