<?php
/**
 * Оптимизиран шаблон за настройки в админ панела
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// Template variables are local scope, not global

$settings = get_option('reviewxpress_settings', array());
?>

<div class="wrap">
    <h1><?php esc_html_e('ReviewXpress Настройки', 'reviewxpress'); ?></h1>
    
    <?php 
    // Check for success/error messages with nonce verification
    // If rx_saved is provided, nonce must be present and valid, otherwise ignore rx_saved
    $rx_saved = '';
    if (isset($_GET['rx_saved'])) {
        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'reviewxpress_settings_nonce')) {
            // If nonce is missing or invalid, ignore rx_saved (don't show notice)
            $rx_saved = '';
        } else {
            $rx_saved = sanitize_text_field(wp_unslash($_GET['rx_saved']));
        }
    }
    
    if ($rx_saved === '1'): ?>
        <div class="notice notice-success is-dismissible">
            <p><?php esc_html_e('Настройките са запазени успешно!', 'reviewxpress'); ?></p>
        </div>
    <?php endif; ?>
    
    <?php if ($rx_saved === '0'): ?>
        <div class="notice notice-error is-dismissible">
            <p><?php esc_html_e('Възникна грешка при запазване на настройките.', 'reviewxpress'); ?></p>
        </div>
    <?php endif; ?>
    
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
        <?php wp_nonce_field('reviewxpress_settings', 'reviewxpress_settings_nonce'); ?>
        <input type="hidden" name="action" value="reviewxpress_save_settings">
        <input type="hidden" name="rx_section" value="general">
        
        <table class="form-table">
            <tr>
                <th scope="row"><?php esc_html_e('Автоматично одобряване', 'reviewxpress'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="auto_approve" value="1" <?php checked(isset($settings['auto_approve']) ? $settings['auto_approve'] : 0, 1); ?>>
                        <?php esc_html_e('Автоматично одобряване на ревюта', 'reviewxpress'); ?>
                    </label>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Изисква WooCommerce поръчка', 'reviewxpress'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="require_woocommerce_order" value="1" <?php checked(isset($settings['require_woocommerce_order']) ? $settings['require_woocommerce_order'] : 1, 1); ?>>
                        <?php esc_html_e('Изисква WooCommerce поръчка за ревю', 'reviewxpress'); ?>
                    </label>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Позволи гост ревюта', 'reviewxpress'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="allow_guest_reviews" value="1" <?php checked(isset($settings['allow_guest_reviews']) ? $settings['allow_guest_reviews'] : 0, 1); ?>>
                        <?php esc_html_e('Позволи ревюта от гости', 'reviewxpress'); ?>
                    </label>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Максимални изображения', 'reviewxpress'); ?></th>
                <td>
                    <input type="number" name="max_images" value="<?php echo esc_attr(isset($settings['max_images']) ? $settings['max_images'] : 5); ?>" min="1" max="10">
                    <p class="description"><?php esc_html_e('Максимален брой изображения на ревю', 'reviewxpress'); ?></p>
                </td>
            </tr>
            
            <tr>
                <th scope="row"><?php esc_html_e('Максимален размер на видео', 'reviewxpress'); ?></th>
                <td>
                    <input type="number" name="max_video_size" value="<?php echo esc_attr(isset($settings['max_video_size']) ? $settings['max_video_size'] : 50); ?>" min="1" max="100">
                    <p class="description"><?php esc_html_e('Максимален размер на видео файл в MB', 'reviewxpress'); ?></p>
                </td>
            </tr>
        </table>
        
        <?php submit_button(esc_html__('Запази настройките', 'reviewxpress')); ?>
    </form>
</div>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
