<?php
/**
 * Настройки за преводи
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Get English default value for translation settings
 * This ensures English is always shown as default, regardless of WordPress language
 */
function reviewxpress_get_default_translation($key) {
    $defaults = array(
        'tr_label_name' => 'Name',
        'tr_label_email' => 'Email',
        'tr_label_rating' => 'Rating',
        'tr_label_review' => 'Review',
        'tr_label_submit' => 'Submit Review',
        'tr_label_media' => 'Images/Video',
        'tr_label_avatar' => 'Profile Picture (Avatar)',
        'tr_label_drag_image' => 'Drag an image here or click to select',
        'tr_label_avatar_help' => 'One image. Recommended 200x200px, JPG/PNG.',
        'tr_label_email_help' => 'Email must match an order in WooCommerce.',
        'tr_label_review_placeholder' => 'Share your opinion about the product...',
        'tr_label_helpful' => 'Helpful',
        'tr_label_load_more' => 'Load More Reviews',
        'tr_label_sort_by' => 'Sort by',
        'tr_label_no_reviews' => 'No reviews for this product',
        'tr_label_rating_summary' => 'Overall Rating',
        'tr_label_reviews_count' => 'reviews',
        'tr_msg_success' => 'Review submitted successfully!',
        'tr_msg_error' => 'An error occurred while submitting the review.',
        'tr_msg_required' => 'Please fill in all required fields.',
        'tr_msg_duplicate' => 'You have already left a review for this product.',
        'tr_msg_moderation' => 'Your review will be reviewed before publication.',
        'tr_msg_woocommerce_required' => 'You must have purchased the product to leave a review.',
        'tr_msg_thank_you' => 'Thank you for leaving a review!',
        'tr_msg_review_submitted' => 'Your review has been submitted for approval. Thank you for your feedback!',
        'tr_status_pending' => 'Pending Approval',
        'tr_status_approved' => 'Approved',
        'tr_status_rejected' => 'Rejected',
        'tr_label_anonymous' => 'Anonymous User',
    );
    return isset($defaults[$key]) ? $defaults[$key] : '';
}
?>

<div id="rx-settings">
    <div class="rx-wrap">
        <h1 class="title"><?php esc_html_e('Translations & Design Settings', 'reviewxpress'); ?></h1>
        <p class="subtitle"><?php esc_html_e('Customize the texts and design of the form and emails.', 'reviewxpress'); ?></p>

        <!-- Tabs Navigation -->
        <div class="rx-tabs">
            <button type="button" class="rx-tab-button active" data-tab="translations"><?php esc_html_e('Translations', 'reviewxpress'); ?></button>
            <button type="button" class="rx-tab-button" data-tab="form-design"><?php esc_html_e('Form Design', 'reviewxpress'); ?></button>
            <button type="button" class="rx-tab-button" data-tab="email-design"><?php esc_html_e('Email Design', 'reviewxpress'); ?></button>
        </div>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('reviewxpress_settings', 'reviewxpress_settings_nonce'); ?>
            <input type="hidden" name="action" value="reviewxpress_save_settings">
            <input type="hidden" name="rx_section" value="translations">

            <!-- Tab: Преводи -->
            <div class="rx-tab-content active" id="translations-tab">
            <!-- Етикети за формата за ревю -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Review Form Labels', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-columns">
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_label_name"><?php esc_html_e('Name Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_name" name="tr_label_name" value="<?php echo esc_attr($settings['tr_label_name'] ?? reviewxpress_get_default_translation('tr_label_name')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_name')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the "Name" field in the form', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_email"><?php esc_html_e('Email Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_email" name="tr_label_email" value="<?php echo esc_attr($settings['tr_label_email'] ?? reviewxpress_get_default_translation('tr_label_email')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_email')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the "Email" field in the form', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_rating"><?php esc_html_e('Rating Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_rating" name="tr_label_rating" value="<?php echo esc_attr($settings['tr_label_rating'] ?? reviewxpress_get_default_translation('tr_label_rating')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_rating')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the "Rating" field in the form', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                    
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_label_review"><?php esc_html_e('Review Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_review" name="tr_label_review" value="<?php echo esc_attr($settings['tr_label_review'] ?? reviewxpress_get_default_translation('tr_label_review')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_review')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the "Review" field in the form', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_review_placeholder"><?php esc_html_e('Review Placeholder Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_review_placeholder" name="tr_label_review_placeholder" value="<?php echo esc_attr($settings['tr_label_review_placeholder'] ?? reviewxpress_get_default_translation('tr_label_review_placeholder')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_review_placeholder')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('Placeholder text shown in the review textarea', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_submit"><?php esc_html_e('Submit Button Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_submit" name="tr_label_submit" value="<?php echo esc_attr($settings['tr_label_submit'] ?? reviewxpress_get_default_translation('tr_label_submit')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_submit')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for the submit button', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_media"><?php esc_html_e('Media Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_media" name="tr_label_media" value="<?php echo esc_attr($settings['tr_label_media'] ?? reviewxpress_get_default_translation('tr_label_media')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_media')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the media section', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_avatar"><?php esc_html_e('Avatar Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_avatar" name="tr_label_avatar" value="<?php echo esc_attr($settings['tr_label_avatar'] ?? reviewxpress_get_default_translation('tr_label_avatar')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_avatar')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the avatar/profile picture field', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_drag_image"><?php esc_html_e('Drag Image Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_drag_image" name="tr_label_drag_image" value="<?php echo esc_attr($settings['tr_label_drag_image'] ?? reviewxpress_get_default_translation('tr_label_drag_image')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_drag_image')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('Text shown in the drag and drop area', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_avatar_help"><?php esc_html_e('Avatar Help Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_avatar_help" name="tr_label_avatar_help" value="<?php echo esc_attr($settings['tr_label_avatar_help'] ?? reviewxpress_get_default_translation('tr_label_avatar_help')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_avatar_help')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('Help text below the avatar upload area', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_email_help"><?php esc_html_e('Email Help Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_email_help" name="tr_label_email_help" value="<?php echo esc_attr($settings['tr_label_email_help'] ?? reviewxpress_get_default_translation('tr_label_email_help')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_email_help')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('Help text below the email field', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Етикети за списъка с ревюта -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Review List Labels', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-columns">
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_label_helpful"><?php esc_html_e('"Helpful" Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_helpful" name="tr_label_helpful" value="<?php echo esc_attr($settings['tr_label_helpful'] ?? reviewxpress_get_default_translation('tr_label_helpful')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_helpful')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for the "Helpful" button', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_load_more"><?php esc_html_e('"Load More" Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_load_more" name="tr_label_load_more" value="<?php echo esc_attr($settings['tr_label_load_more'] ?? reviewxpress_get_default_translation('tr_label_load_more')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_load_more')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for the "Load More" button', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_sort_by"><?php esc_html_e('Sort Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_sort_by" name="tr_label_sort_by" value="<?php echo esc_attr($settings['tr_label_sort_by'] ?? reviewxpress_get_default_translation('tr_label_sort_by')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_sort_by')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the sort dropdown', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                    
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_label_no_reviews"><?php esc_html_e('No Reviews Text', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_no_reviews" name="tr_label_no_reviews" value="<?php echo esc_attr($settings['tr_label_no_reviews'] ?? reviewxpress_get_default_translation('tr_label_no_reviews')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_no_reviews')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text when there are no reviews', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_rating_summary"><?php esc_html_e('Rating Summary Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_rating_summary" name="tr_label_rating_summary" value="<?php echo esc_attr($settings['tr_label_rating_summary'] ?? reviewxpress_get_default_translation('tr_label_rating_summary')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_rating_summary')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The label for the rating summary', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_reviews_count"><?php esc_html_e('Reviews Count Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_reviews_count" name="tr_label_reviews_count" value="<?php echo esc_attr($settings['tr_label_reviews_count'] ?? reviewxpress_get_default_translation('tr_label_reviews_count')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_reviews_count')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for the reviews count (e.g., "5 reviews")', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Съобщения и уведомления -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Messages and Notifications', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-columns">
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_msg_success"><?php esc_html_e('Success Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_success" name="tr_msg_success" value="<?php echo esc_attr($settings['tr_msg_success'] ?? reviewxpress_get_default_translation('tr_msg_success')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_success')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message when review is submitted successfully', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_msg_error"><?php esc_html_e('Error Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_error" name="tr_msg_error" value="<?php echo esc_attr($settings['tr_msg_error'] ?? reviewxpress_get_default_translation('tr_msg_error')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_error')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message when an error occurs', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_msg_required"><?php esc_html_e('Required Fields Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_required" name="tr_msg_required" value="<?php echo esc_attr($settings['tr_msg_required'] ?? reviewxpress_get_default_translation('tr_msg_required')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_required')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message for required fields', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                    
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_msg_duplicate"><?php esc_html_e('Duplicate Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_duplicate" name="tr_msg_duplicate" value="<?php echo esc_attr($settings['tr_msg_duplicate'] ?? reviewxpress_get_default_translation('tr_msg_duplicate')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_duplicate')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message when attempting to duplicate', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_msg_moderation"><?php esc_html_e('Moderation Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_moderation" name="tr_msg_moderation" value="<?php echo esc_attr($settings['tr_msg_moderation'] ?? reviewxpress_get_default_translation('tr_msg_moderation')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_moderation')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message for moderation', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_msg_woocommerce_required"><?php esc_html_e('WooCommerce Order Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_woocommerce_required" name="tr_msg_woocommerce_required" value="<?php echo esc_attr($settings['tr_msg_woocommerce_required'] ?? reviewxpress_get_default_translation('tr_msg_woocommerce_required')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_woocommerce_required')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message for order requirement', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_msg_thank_you"><?php esc_html_e('Thank You Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_thank_you" name="tr_msg_thank_you" value="<?php echo esc_attr($settings['tr_msg_thank_you'] ?? reviewxpress_get_default_translation('tr_msg_thank_you')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_thank_you')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The main thank you message after submitting a review', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_msg_review_submitted"><?php esc_html_e('Review Submitted Message', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_msg_review_submitted" name="tr_msg_review_submitted" value="<?php echo esc_attr($settings['tr_msg_review_submitted'] ?? reviewxpress_get_default_translation('tr_msg_review_submitted')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_msg_review_submitted')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The message shown after review submission (Free version - no promo code)', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Статуси на ревюта -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Review Statuses', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-columns">
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_status_pending"><?php esc_html_e('"Pending" Status', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_status_pending" name="tr_status_pending" value="<?php echo esc_attr($settings['tr_status_pending'] ?? reviewxpress_get_default_translation('tr_status_pending')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_status_pending')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for "Pending" status', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_status_approved"><?php esc_html_e('"Approved" Status', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_status_approved" name="tr_status_approved" value="<?php echo esc_attr($settings['tr_status_approved'] ?? reviewxpress_get_default_translation('tr_status_approved')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_status_approved')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for "Approved" status', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                    
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="tr_status_rejected"><?php esc_html_e('"Rejected" Status', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_status_rejected" name="tr_status_rejected" value="<?php echo esc_attr($settings['tr_status_rejected'] ?? reviewxpress_get_default_translation('tr_status_rejected')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_status_rejected')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for "Rejected" status', 'reviewxpress'); ?></div>
                        </div>

                        <div class="rx-form-group">
                            <label for="tr_label_anonymous"><?php esc_html_e('Anonymous Review Label', 'reviewxpress'); ?></label>
                            <input type="text" id="tr_label_anonymous" name="tr_label_anonymous" value="<?php echo esc_attr($settings['tr_label_anonymous'] ?? reviewxpress_get_default_translation('tr_label_anonymous')); ?>" placeholder="<?php echo esc_attr(reviewxpress_get_default_translation('tr_label_anonymous')); ?>">
                            <div class="rx-form-help"><?php esc_html_e('The text for anonymous reviews', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Преглед на промените -->
            <section class="rx-preview-section">
                <h4><?php esc_html_e('Preview Changes', 'reviewxpress'); ?></h4>
                <p><?php esc_html_e('Here is how the form will look with your settings:', 'reviewxpress'); ?></p>
                
                <div class="rx-preview">
                    <h5><?php esc_html_e('Review Form', 'reviewxpress'); ?></h5>
                    <p><strong><?php esc_html_e('Name:', 'reviewxpress'); ?></strong> <span id="preview_name"><?php echo esc_html($settings['tr_label_name'] ?? reviewxpress_get_default_translation('tr_label_name')); ?></span></p>
                    <p><strong><?php esc_html_e('Email:', 'reviewxpress'); ?></strong> <span id="preview_email"><?php echo esc_html($settings['tr_label_email'] ?? reviewxpress_get_default_translation('tr_label_email')); ?></span></p>
                    <p><strong><?php esc_html_e('Rating:', 'reviewxpress'); ?></strong> <span id="preview_rating"><?php echo esc_html($settings['tr_label_rating'] ?? reviewxpress_get_default_translation('tr_label_rating')); ?></span></p>
                    <p><strong><?php esc_html_e('Review:', 'reviewxpress'); ?></strong> <span id="preview_review"><?php echo esc_html($settings['tr_label_review'] ?? reviewxpress_get_default_translation('tr_label_review')); ?></span></p>
                    <p><strong><?php esc_html_e('Button:', 'reviewxpress'); ?></strong> <span id="preview_submit"><?php echo esc_html($settings['tr_label_submit'] ?? reviewxpress_get_default_translation('tr_label_submit')); ?></span></p>
                </div>
            </section>
            </div>
            <!-- End Tab: Преводи -->

            <!-- Tab: Дизайн форми -->
            <div class="rx-tab-content" id="form-design-tab">
                <section class="rx-form-section">
                    <h3><?php esc_html_e('Review Submission', 'reviewxpress'); ?></h3>
                    <p style="color: var(--muted); margin-bottom: 20px;"><?php esc_html_e('Customize the colors, fonts, and style of the review submission form.', 'reviewxpress'); ?></p>
                    
                    <div class="rx-form-columns">
                        <div class="rx-form-column">
                            <div class="rx-form-group">
                                <label for="form_background_color"><?php esc_html_e('Background Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="form_background_color" name="form_background_color" value="<?php echo esc_attr($settings['form_background_color'] ?? '#ffffff'); ?>">
                                    <input type="text" class="color-hex" id="form_background_color_hex" value="<?php echo esc_attr($settings['form_background_color'] ?? '#ffffff'); ?>" placeholder="#ffffff">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The background color of the form', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="form_text_color"><?php esc_html_e('Text Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="form_text_color" name="form_text_color" value="<?php echo esc_attr($settings['form_text_color'] ?? '#111111'); ?>">
                                    <input type="text" class="color-hex" id="form_text_color_hex" value="<?php echo esc_attr($settings['form_text_color'] ?? '#111111'); ?>" placeholder="#111111">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The text color in the form', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="form_border_color"><?php esc_html_e('Border Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="form_border_color" name="form_border_color" value="<?php echo esc_attr($settings['form_border_color'] ?? '#e5e7eb'); ?>">
                                    <input type="text" class="color-hex" id="form_border_color_hex" value="<?php echo esc_attr($settings['form_border_color'] ?? '#e5e7eb'); ?>" placeholder="#e5e7eb">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The border color of the form', 'reviewxpress'); ?></div>
                            </div>
                        </div>
                        
                        <div class="rx-form-column">
                            <div class="rx-form-group">
                                <label for="form_button_color"><?php esc_html_e('Button Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="form_button_color" name="form_button_color" value="<?php echo esc_attr($settings['form_button_color'] ?? '#ffd600'); ?>">
                                    <input type="text" class="color-hex" id="form_button_color_hex" value="<?php echo esc_attr($settings['form_button_color'] ?? '#ffd600'); ?>" placeholder="#ffd600">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The color of the submit button', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="form_button_text_color"><?php esc_html_e('Button Text Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="form_button_text_color" name="form_button_text_color" value="<?php echo esc_attr($settings['form_button_text_color'] ?? '#161616'); ?>">
                                    <input type="text" class="color-hex" id="form_button_text_color_hex" value="<?php echo esc_attr($settings['form_button_text_color'] ?? '#161616'); ?>" placeholder="#161616">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The text color of the button', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="form_border_radius"><?php esc_html_e('Border Radius (px)', 'reviewxpress'); ?></label>
                                <input type="number" id="form_border_radius" name="form_border_radius" value="<?php echo esc_attr($settings['form_border_radius'] ?? '8'); ?>" min="0" max="50">
                                <div class="rx-form-help"><?php esc_html_e('Border radius of the form (in pixels)', 'reviewxpress'); ?></div>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Review List Display -->
                <section class="rx-form-section">
                    <h3><?php esc_html_e('Review List Display', 'reviewxpress'); ?></h3>
                    <p style="color: var(--muted); margin-bottom: 20px;"><?php esc_html_e('Customize the colors, fonts, and style of the review list.', 'reviewxpress'); ?></p>
                    
                    <div class="rx-form-columns">
                        <div class="rx-form-column">
                            <div class="rx-form-group">
                                <label for="reviews_background_color"><?php esc_html_e('Background Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="reviews_background_color" name="reviews_background_color" value="<?php echo esc_attr($settings['reviews_background_color'] ?? '#ffffff'); ?>">
                                    <input type="text" class="color-hex" id="reviews_background_color_hex" value="<?php echo esc_attr($settings['reviews_background_color'] ?? '#ffffff'); ?>" placeholder="#ffffff">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The background color of the review list', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="reviews_text_color"><?php esc_html_e('Text Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="reviews_text_color" name="reviews_text_color" value="<?php echo esc_attr($settings['reviews_text_color'] ?? '#111111'); ?>">
                                    <input type="text" class="color-hex" id="reviews_text_color_hex" value="<?php echo esc_attr($settings['reviews_text_color'] ?? '#111111'); ?>" placeholder="#111111">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The text color in the review list', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="reviews_border_color"><?php esc_html_e('Border Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="reviews_border_color" name="reviews_border_color" value="<?php echo esc_attr($settings['reviews_border_color'] ?? '#e5e7eb'); ?>">
                                    <input type="text" class="color-hex" id="reviews_border_color_hex" value="<?php echo esc_attr($settings['reviews_border_color'] ?? '#e5e7eb'); ?>" placeholder="#e5e7eb">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The border color of the review list', 'reviewxpress'); ?></div>
                            </div>
                        </div>
                        
                        <div class="rx-form-column">
                            <div class="rx-form-group">
                                <label for="reviews_button_color"><?php esc_html_e('Button Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="reviews_button_color" name="reviews_button_color" value="<?php echo esc_attr($settings['reviews_button_color'] ?? '#ffd600'); ?>">
                                    <input type="text" class="color-hex" id="reviews_button_color_hex" value="<?php echo esc_attr($settings['reviews_button_color'] ?? '#ffd600'); ?>" placeholder="#ffd600">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The color of buttons in the review list', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="reviews_button_text_color"><?php esc_html_e('Button Text Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="reviews_button_text_color" name="reviews_button_text_color" value="<?php echo esc_attr($settings['reviews_button_text_color'] ?? '#161616'); ?>">
                                    <input type="text" class="color-hex" id="reviews_button_text_color_hex" value="<?php echo esc_attr($settings['reviews_button_text_color'] ?? '#161616'); ?>" placeholder="#161616">
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The text color of buttons', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="reviews_border_radius"><?php esc_html_e('Border Radius (px)', 'reviewxpress'); ?></label>
                                <input type="number" id="reviews_border_radius" name="reviews_border_radius" value="<?php echo esc_attr($settings['reviews_border_radius'] ?? '8'); ?>" min="0" max="50">
                                <div class="rx-form-help"><?php esc_html_e('Border radius of the review list (in pixels)', 'reviewxpress'); ?></div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- End Tab: Form Design -->

            <!-- Tab: Email Design -->
            <div class="rx-tab-content" id="email-design-tab">
                <section class="rx-form-section" style="position: relative; opacity: 0.6;">
                    <div style="position: absolute; top: 10px; right: 10px; background: #ffd600; color: #161616; padding: 4px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                        <?php esc_html_e('Pro Version', 'reviewxpress'); ?>
                    </div>
                    <h3><?php esc_html_e('Email Design Settings', 'reviewxpress'); ?></h3>
                    <p style="color: var(--muted); margin-bottom: 20px;"><?php esc_html_e('Customize the colors, fonts, and style of sent emails.', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></p>
                    
                    <div class="rx-form-columns">
                        <div class="rx-form-column">
                            <div class="rx-form-group">
                                <label for="email_background_color" style="opacity: 0.7;"><?php esc_html_e('Background Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="email_background_color" name="email_background_color" value="#ffffff" disabled>
                                    <input type="text" class="color-hex" id="email_background_color_hex" value="#ffffff" placeholder="#ffffff" disabled>
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The background color of the email', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="email_text_color" style="opacity: 0.7;"><?php esc_html_e('Text Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="email_text_color" name="email_text_color" value="#111111" disabled>
                                    <input type="text" class="color-hex" id="email_text_color_hex" value="#111111" placeholder="#111111" disabled>
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The text color in the email', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="email_header_color" style="opacity: 0.7;"><?php esc_html_e('Header Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="email_header_color" name="email_header_color" value="#0a0a0a" disabled>
                                    <input type="text" class="color-hex" id="email_header_color_hex" value="#0a0a0a" placeholder="#0a0a0a" disabled>
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The header color in the email', 'reviewxpress'); ?></div>
                            </div>
                        </div>
                        
                        <div class="rx-form-column">
                            <div class="rx-form-group">
                                <label for="email_button_color" style="opacity: 0.7;"><?php esc_html_e('Button Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="email_button_color" name="email_button_color" value="#ffd600" disabled>
                                    <input type="text" class="color-hex" id="email_button_color_hex" value="#ffd600" placeholder="#ffd600" disabled>
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The button color in the email', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="email_button_text_color" style="opacity: 0.7;"><?php esc_html_e('Button Text Color', 'reviewxpress'); ?></label>
                                <div class="rx-color-wrapper">
                                    <input type="color" id="email_button_text_color" name="email_button_text_color" value="#161616" disabled>
                                    <input type="text" class="color-hex" id="email_button_text_color_hex" value="#161616" placeholder="#161616" disabled>
                                </div>
                                <div class="rx-form-help"><?php esc_html_e('The button text color', 'reviewxpress'); ?></div>
                            </div>

                            <div class="rx-form-group">
                                <label for="email_font_family" style="opacity: 0.7;"><?php esc_html_e('Font', 'reviewxpress'); ?></label>
                                <select id="email_font_family" name="email_font_family" disabled>
                                    <option value="Arial" selected>Arial</option>
                                    <option value="Helvetica">Helvetica</option>
                                    <option value="Georgia">Georgia</option>
                                    <option value="Times New Roman">Times New Roman</option>
                                    <option value="Verdana">Verdana</option>
                                </select>
                                <div class="rx-form-help"><?php esc_html_e('The font for the text in the email', 'reviewxpress'); ?></div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- End Tab: Email Design -->

            <div class="rx-submit-section">
                <button type="submit" class="btn primary"><?php esc_html_e('Save Settings', 'reviewxpress'); ?></button>
            </div>
        </form>
    </div>
</div>
