<?php
/**
 * Настройки за шорткодове
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// Template variables are local scope, not global
?>

<div id="rx-settings">
    <div class="rx-wrap">
        <h1 class="title"><?php esc_html_e('Shortcode Settings', 'reviewxpress'); ?></h1>
        <p class="subtitle"><?php esc_html_e('Customize the styles and default settings for shortcodes.', 'reviewxpress'); ?></p>

        <!-- Shortcode Generator -->
        <section class="rx-generator-section">
            <h3><?php esc_html_e('Shortcode Generator', 'reviewxpress'); ?></h3>
            <p><?php esc_html_e('Select a product and generate a shortcode for leaving a review', 'reviewxpress'); ?></p>
            
            <div class="rx-generator-form">
                <div class="rx-form-group">
                    <label for="generator_product"><?php esc_html_e('Select Product', 'reviewxpress'); ?></label>
                    <select id="generator_product" class="rx-product-select">
                        <option value=""><?php esc_html_e('-- Select Product --', 'reviewxpress'); ?></option>
                        <?php
                        // Вземаме продуктите от WooCommerce
                        $products = get_posts(array(
                            'post_type' => 'product',
                            'posts_per_page' => -1,
                            'post_status' => 'publish',
                            'orderby' => 'title',
                            'order' => 'ASC'
                        ));
                        
                        foreach ($products as $product) {
                            $product_obj = wc_get_product($product->ID);
                            if ($product_obj) {
                                echo '<option value="' . esc_attr($product->ID) . '">' . esc_html($product->post_title) . ' (ID: ' . esc_html($product->ID) . ')</option>';
                            }
                        }
                        ?>
                    </select>
                    <div class="rx-form-help"><?php esc_html_e('Select a product from your store', 'reviewxpress'); ?></div>
                </div>
                
                <div class="rx-form-group">
                    <label for="generator_type"><?php esc_html_e('Shortcode Type', 'reviewxpress'); ?></label>
                    <select id="generator_type" class="rx-product-select">
                        <option value="form"><?php esc_html_e('Review Form', 'reviewxpress'); ?></option>
                        <option value="list"><?php esc_html_e('Review List', 'reviewxpress'); ?></option>
                    </select>
                    <div class="rx-form-help"><?php esc_html_e('Select what type of shortcode to generate', 'reviewxpress'); ?></div>
                </div>
            </div>
            
            <div class="rx-generator-options" id="generator_options" style="display: none;">
                <div class="rx-form-group">
                    <label for="generator_limit"><?php esc_html_e('Review Limit', 'reviewxpress'); ?></label>
                    <input type="number" id="generator_limit" value="10" min="1" max="100" class="rx-product-select">
                    <div class="rx-form-help"><?php esc_html_e('Maximum number of reviews to display (list only)', 'reviewxpress'); ?></div>
                </div>
                
                <div class="rx-form-group">
                    <label for="generator_orderby"><?php esc_html_e('Sort By', 'reviewxpress'); ?></label>
                    <select id="generator_orderby" class="rx-product-select">
                        <option value="date"><?php esc_html_e('Date', 'reviewxpress'); ?></option>
                        <option value="rating"><?php esc_html_e('Rating', 'reviewxpress'); ?></option>
                        <option value="helpful"><?php esc_html_e('Helpfulness', 'reviewxpress'); ?></option>
                    </select>
                    <div class="rx-form-help"><?php esc_html_e('How to sort reviews (list only)', 'reviewxpress'); ?></div>
                </div>
            </div>
            
            <div class="rx-generator-result" id="generator_result" style="display: none;">
                <h4><?php esc_html_e('Generated Shortcode:', 'reviewxpress'); ?></h4>
                <div class="rx-shortcode-output" id="generated_shortcode"></div>
                <button type="button" class="rx-copy-btn" id="copy_shortcode"><?php esc_html_e('Copy Shortcode', 'reviewxpress'); ?></button>
            </div>
        </section>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('reviewxpress_settings', 'reviewxpress_settings_nonce'); ?>
            <input type="hidden" name="action" value="reviewxpress_save_settings">
            <input type="hidden" name="rx_section" value="defaults">

            <!-- Налични шорткодове -->
            <section class="rx-shortcode-section">
                <h4><?php esc_html_e('Available Shortcodes', 'reviewxpress'); ?></h4>
                <p><?php esc_html_e('Here is how to use the shortcodes:', 'reviewxpress'); ?></p>
                
                <div class="rx-shortcode-item">
                    <strong><?php esc_html_e('Review Form:', 'reviewxpress'); ?></strong><br>
                    <code>[reviewxpress_form product_id="123"]</code>
                    <p><?php esc_html_e('Displays the review form for product with ID 123', 'reviewxpress'); ?></p>
                </div>
                
                <div class="rx-shortcode-item">
                    <strong><?php esc_html_e('Review List:', 'reviewxpress'); ?></strong><br>
                    <code>[reviewxpress_list product_id="123" limit="10" orderby="date" order="DESC"]</code>
                    <p><?php esc_html_e('Displays the review list for product with ID 123', 'reviewxpress'); ?></p>
                </div>
            </section>

            <!-- Аватар по подразбиране -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Default Avatar', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-columns">
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="default_avatar_id"><?php esc_html_e('Avatar ID from Media Library', 'reviewxpress'); ?></label>
                            <input type="number" id="default_avatar_id" name="default_avatar_id" value="<?php echo esc_attr($settings['default_avatar_id'] ?? 0); ?>" min="0" placeholder="0">
                            <div class="rx-form-help"><?php esc_html_e('ID of an image from WordPress media library', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                    
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="default_avatar_url"><?php esc_html_e('Avatar URL', 'reviewxpress'); ?></label>
                            <input type="url" id="default_avatar_url" name="default_avatar_url" value="<?php echo esc_attr($settings['default_avatar_url'] ?? ''); ?>" placeholder="https://example.com/avatar.jpg">
                            <div class="rx-form-help"><?php esc_html_e('Full URL to an image for default avatar', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Style Information -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Shortcode Styles', 'reviewxpress'); ?></h3>
                <p style="color: var(--muted); margin-bottom: 0;">
                    <?php esc_html_e('Shortcode styles are managed from the "Translations & Design" → "Form Design" and "Email Design" sections.', 'reviewxpress'); ?>
                </p>
                <p style="color: var(--muted); margin-top: 8px;">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=reviewxpress-settings-translations')); ?>" style="color: var(--accent); text-decoration: underline;">
                        <?php esc_html_e('Go to Design Settings →', 'reviewxpress'); ?>
                    </a>
                </p>
            </section>

            <div class="rx-submit-section">
                <button type="submit" class="btn primary"><?php esc_html_e('Save Settings', 'reviewxpress'); ?></button>
            </div>
        </form>
    </div>
</div>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
?>
