<?php
/**
 * Общи настройки
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div id="rx-settings">
    <div class="rx-wrap">
        <h1 class="title"><?php esc_html_e('General Settings', 'reviewxpress'); ?></h1>
        <p class="subtitle"><?php esc_html_e('Configure the basic settings for the review system.', 'reviewxpress'); ?></p>


        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('reviewxpress_settings', 'reviewxpress_settings_nonce'); ?>
            <input type="hidden" name="action" value="reviewxpress_save_settings">
            <input type="hidden" name="rx_section" value="general">

            <!-- Интеграции -->
            <section class="rx-form-section">
                <h3><?php esc_html_e('Integrations', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-group">
                    <label for="page_builder"><?php esc_html_e('Page Builder / Theme', 'reviewxpress'); ?></label>
                    <select id="page_builder" name="page_builder">
                        <option value="default" <?php selected($settings['page_builder'] ?? 'default', 'default'); ?>><?php esc_html_e('Standard WooCommerce', 'reviewxpress'); ?></option>
                        <option value="divi" <?php selected($settings['page_builder'] ?? 'default', 'divi'); ?>><?php esc_html_e('Divi Theme Builder', 'reviewxpress'); ?></option>
                        <option value="elementor" <?php selected($settings['page_builder'] ?? 'default', 'elementor'); ?>><?php esc_html_e('Elementor (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="flatsome" <?php selected($settings['page_builder'] ?? 'default', 'flatsome'); ?>><?php esc_html_e('Flatsome (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="beaver" <?php selected($settings['page_builder'] ?? 'default', 'beaver'); ?>><?php esc_html_e('Beaver Builder (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="avada" <?php selected($settings['page_builder'] ?? 'default', 'avada'); ?>><?php esc_html_e('Avada (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="storefront" <?php selected($settings['page_builder'] ?? 'default', 'storefront'); ?>><?php esc_html_e('Storefront (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="astra" <?php selected($settings['page_builder'] ?? 'default', 'astra'); ?>><?php esc_html_e('Astra (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="generatepress" <?php selected($settings['page_builder'] ?? 'default', 'generatepress'); ?>><?php esc_html_e('GeneratePress (Coming Soon)', 'reviewxpress'); ?></option>
                        <option value="oceanwp" <?php selected($settings['page_builder'] ?? 'default', 'oceanwp'); ?>><?php esc_html_e('OceanWP (Coming Soon)', 'reviewxpress'); ?></option>
                    </select>
                    <div class="rx-form-help"><?php esc_html_e('Choose your page builder or theme. Divi Theme Builder and standard WooCommerce are fully supported. The rest are under development.', 'reviewxpress'); ?></div>
                </div>

                <div class="rx-form-group">
                    <div class="rx-checkbox-group">
                        <input type="checkbox" id="custom_css_enabled" name="custom_css_enabled" value="1" <?php checked(!empty($settings['custom_css_enabled'])); ?>>
                        <label for="custom_css_enabled"><?php esc_html_e('Customize CSS', 'reviewxpress'); ?></label>
                    </div>
                    <div class="rx-form-help"><?php esc_html_e('Allows adding custom CSS classes and code for better integration', 'reviewxpress'); ?></div>
                </div>

                <div class="rx-form-group custom-css-group">
                    <label for="custom_css_class"><?php esc_html_e('CSS Class for Reviews', 'reviewxpress'); ?></label>
                    <input type="text" id="custom_css_class" name="custom_css_class" value="<?php echo esc_attr($settings['custom_css_class'] ?? ''); ?>" placeholder="my-custom-reviews">
                    <div class="rx-form-help"><?php esc_html_e('Additional CSS class for the reviews container', 'reviewxpress'); ?></div>
                </div>

                <div class="rx-form-group custom-css-group">
                    <label for="custom_css_id"><?php esc_html_e('CSS ID for Reviews', 'reviewxpress'); ?></label>
                    <input type="text" id="custom_css_id" name="custom_css_id" value="<?php echo esc_attr($settings['custom_css_id'] ?? ''); ?>" placeholder="my-reviews-section">
                    <div class="rx-form-help"><?php esc_html_e('Unique CSS ID for the reviews container', 'reviewxpress'); ?></div>
                </div>

                <!-- Custom CSS Code functionality is available in Pro version only -->
            </section>

            <!-- Режим на ревюта и Лимити за файлове -->
            <div class="rx-sections-grid">
                <section class="rx-form-section">
                    <h3><?php esc_html_e('Review Mode', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <label><?php esc_html_e('How should reviews be displayed?', 'reviewxpress'); ?></label>
                        <div class="rx-radio-group">
                            <div class="rx-radio-item">
                                <input type="radio" id="review_mode_disabled" name="review_mode" value="disabled" <?php checked($settings['review_mode'] ?? 'disabled', 'disabled'); ?>>
                                <label for="review_mode_disabled">
                                    <strong><?php esc_html_e('Disabled', 'reviewxpress'); ?></strong>
                                    <br><small><?php esc_html_e('The review system is disabled', 'reviewxpress'); ?></small>
                                </label>
                            </div>
                            <div class="rx-radio-item">
                                <input type="radio" id="review_mode_manual" name="review_mode" value="manual_approve" <?php checked($settings['review_mode'] ?? 'disabled', 'manual_approve'); ?>>
                                <label for="review_mode_manual">
                                    <strong><?php esc_html_e('Manual Approval', 'reviewxpress'); ?></strong>
                                    <br><small><?php esc_html_e('Reviews are displayed after administrator approval', 'reviewxpress'); ?></small>
                                </label>
                            </div>
                            <div class="rx-radio-item">
                                <input type="radio" id="review_mode_auto" name="review_mode" value="auto_approve" <?php checked($settings['review_mode'] ?? 'disabled', 'auto_approve'); ?>>
                                <label for="review_mode_auto">
                                    <strong><?php esc_html_e('Automatic Approval', 'reviewxpress'); ?></strong>
                                    <br><small><?php esc_html_e('Reviews are displayed immediately', 'reviewxpress'); ?></small>
                                </label>
                            </div>
                            <div class="rx-radio-item">
                                <input type="radio" id="review_mode_hidden" name="review_mode" value="hidden_auto" <?php checked($settings['review_mode'] ?? 'disabled', 'hidden_auto'); ?>>
                                <label for="review_mode_hidden">
                                    <strong><?php esc_html_e('Hidden Automatic', 'reviewxpress'); ?></strong>
                                    <br><small><?php esc_html_e('Reviews are approved automatically, but not displayed', 'reviewxpress'); ?></small>
                                </label>
                            </div>
                        </div>
                    </div>
                </section>

                <section class="rx-form-section">
                    <h3><?php esc_html_e('File Limits', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <label for="max_images"><?php esc_html_e('Maximum Number of Images', 'reviewxpress'); ?></label>
                        <input type="number" id="max_images" name="max_images" value="<?php echo esc_attr($settings['max_images'] ?? 5); ?>" min="1" max="20">
                    </div>

                    <div class="rx-form-group">
                        <label for="max_image_size"><?php esc_html_e('Maximum Image Size (MB)', 'reviewxpress'); ?></label>
                        <input type="number" id="max_image_size" name="max_image_size" value="<?php echo esc_attr($settings['max_image_size'] ?? 5); ?>" min="1" max="100">
                    </div>

                    <div class="rx-form-group">
                        <label for="max_video_size"><?php esc_html_e('Maximum Video Size (MB)', 'reviewxpress'); ?></label>
                        <input type="number" id="max_video_size" name="max_video_size" value="<?php echo esc_attr($settings['max_video_size'] ?? 50); ?>" min="1" max="500">
                    </div>

                    <div class="rx-form-group">
                        <label for="allowed_image_types"><?php esc_html_e('Allowed Image Types', 'reviewxpress'); ?></label>
                        <input type="text" id="allowed_image_types" name="allowed_image_types" value="<?php echo esc_attr($settings['allowed_image_types'] ?? 'jpg,jpeg,png'); ?>" placeholder="jpg,jpeg,png,gif,webp">
                        <div class="rx-form-help"><?php esc_html_e('Separated by comma (jpg,jpeg,png)', 'reviewxpress'); ?></div>
                    </div>
                </section>
            </div>

            <!-- Позициониране на формата и Показване на ревюта -->
            <div class="rx-sections-grid">
                <section class="rx-form-section">
                    <h3><?php esc_html_e('Form Positioning', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <div class="rx-checkbox-group">
                            <input type="checkbox" id="show_form_in_reviews_section" name="show_form_in_reviews_section" value="1" <?php checked(!empty($settings['show_form_in_reviews_section'])); ?>>
                            <label for="show_form_in_reviews_section"><?php esc_html_e('Show review form in the review section', 'reviewxpress'); ?></label>
                        </div>
                        <div class="rx-form-help"><?php esc_html_e('If disabled, the form will only be displayed via shortcode', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group">
                        <label for="form_display_type"><?php esc_html_e('How should the form be displayed?', 'reviewxpress'); ?></label>
                        <select id="form_display_type" name="form_display_type">
                            <option value="position" <?php selected(isset($settings['form_display_type']) ? $settings['form_display_type'] : 'position', 'position'); ?>><?php esc_html_e('Automatic Positioning', 'reviewxpress'); ?></option>
                            <option value="shortcode" <?php selected(isset($settings['form_display_type']) ? $settings['form_display_type'] : 'position', 'shortcode'); ?>><?php esc_html_e('Shortcode Only', 'reviewxpress'); ?></option>
                        </select>
                    </div>

                    <div class="rx-form-group">
                        <label for="form_placement"><?php esc_html_e('Where should the form be displayed?', 'reviewxpress'); ?></label>
                        <select id="form_placement" name="form_placement">
                            <option value="before_tab" <?php selected($settings['form_placement'] ?? 'after_tab', 'before_tab'); ?>><?php esc_html_e('Before Tabs', 'reviewxpress'); ?></option>
                            <option value="after_tab" <?php selected($settings['form_placement'] ?? 'after_tab', 'after_tab'); ?>><?php esc_html_e('After Tabs', 'reviewxpress'); ?></option>
                            <option value="with_reviews" <?php selected($settings['form_placement'] ?? 'after_tab', 'with_reviews'); ?>><?php esc_html_e('Automatically with Reviews', 'reviewxpress'); ?></option>
                        </select>
                        <div class="rx-form-help"><?php esc_html_e('"Automatically with Reviews" displays the form right below the reviews', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group">
                        <label for="form_page_url"><?php esc_html_e('Form Page URL', 'reviewxpress'); ?></label>
                        <input type="url" id="form_page_url" name="form_page_url" value="<?php echo esc_attr($settings['form_page_url'] ?? ''); ?>" placeholder="https://yoursite.com/review-form">
                        <div class="rx-form-help"><?php esc_html_e('The page must contain the shortcode [reviewxpress_form]', 'reviewxpress'); ?></div>
                    </div>
                </section>

                <section class="rx-form-section">
                    <h3><?php esc_html_e('Display Reviews', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <div class="rx-checkbox-group">
                            <input type="checkbox" id="show_reviews_section" name="show_reviews_section" value="1" <?php checked(!empty($settings['show_reviews_section'])); ?>>
                            <label for="show_reviews_section"><?php esc_html_e('Show review section', 'reviewxpress'); ?></label>
                        </div>
                    </div>

                    <div class="rx-form-group">
                        <label for="reviews_display_type"><?php esc_html_e('How should reviews be displayed?', 'reviewxpress'); ?></label>
                        <select id="reviews_display_type" name="reviews_display_type">
                            <option value="woocommerce_tab" <?php selected(isset($settings['reviews_display_type']) ? $settings['reviews_display_type'] : 'woocommerce_tab', 'woocommerce_tab'); ?>><?php esc_html_e('WooCommerce Tab', 'reviewxpress'); ?></option>
                            <option value="position" <?php selected(isset($settings['reviews_display_type']) ? $settings['reviews_display_type'] : 'woocommerce_tab', 'position'); ?>><?php esc_html_e('Automatic Positioning', 'reviewxpress'); ?></option>
                            <option value="shortcode" <?php selected(isset($settings['reviews_display_type']) ? $settings['reviews_display_type'] : 'woocommerce_tab', 'shortcode'); ?>><?php esc_html_e('Shortcode Only', 'reviewxpress'); ?></option>
                        </select>
                    </div>

                    <div class="rx-form-group" id="reviews_position_group">
                        <label for="reviews_position"><?php esc_html_e('Where should reviews be displayed?', 'reviewxpress'); ?></label>
                        <select id="reviews_position" name="reviews_position">
                            <option value="before_tab" <?php selected(isset($settings['reviews_position']) ? $settings['reviews_position'] : 'after_description', 'before_tab'); ?>><?php esc_html_e('Before Tabs', 'reviewxpress'); ?></option>
                            <option value="after_tab" <?php selected(isset($settings['reviews_position']) ? $settings['reviews_position'] : 'after_description', 'after_tab'); ?>><?php esc_html_e('After Tabs', 'reviewxpress'); ?></option>
                            <option value="before_description" <?php selected(isset($settings['reviews_position']) ? $settings['reviews_position'] : 'after_description', 'before_description'); ?>><?php esc_html_e('Before Description', 'reviewxpress'); ?></option>
                            <option value="after_description" <?php selected(isset($settings['reviews_position']) ? $settings['reviews_position'] : 'after_description', 'after_description'); ?>><?php esc_html_e('After Description', 'reviewxpress'); ?></option>
                        </select>
                        <div class="rx-form-help"><?php esc_html_e('Choose where to display reviews on the product page', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group" id="reviews_style_group">
                        <label for="reviews_template"><?php esc_html_e('Section Template', 'reviewxpress'); ?></label>
                        <select id="reviews_template" name="reviews_template">
                            <option value="default" <?php selected(isset($settings['reviews_template']) ? $settings['reviews_template'] : 'default', 'default'); ?>><?php esc_html_e('Default Template', 'reviewxpress'); ?></option>
                            <option value="side_by_side" <?php selected(isset($settings['reviews_template']) ? $settings['reviews_template'] : 'default', 'side_by_side'); ?>><?php esc_html_e('Side-by-Side Template', 'reviewxpress'); ?></option>
                        </select>
                        <div class="rx-form-help"><?php esc_html_e('Default: vertical layout | Side-by-Side: text on one side, images on the other', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group">
                        <label for="reviews_per_page"><?php esc_html_e('Reviews Per Page', 'reviewxpress'); ?></label>
                        <select id="reviews_per_page" name="reviews_per_page">
                            <option value="3" <?php selected(isset($settings['reviews_per_page']) ? $settings['reviews_per_page'] : '5', '3'); ?>>3 <?php esc_html_e('reviews', 'reviewxpress'); ?></option>
                            <option value="5" <?php selected(isset($settings['reviews_per_page']) ? $settings['reviews_per_page'] : '5', '5'); ?>>5 <?php esc_html_e('reviews', 'reviewxpress'); ?></option>
                            <option value="10" <?php selected(isset($settings['reviews_per_page']) ? $settings['reviews_per_page'] : '5', '10'); ?>>10 <?php esc_html_e('reviews', 'reviewxpress'); ?></option>
                            <option value="15" <?php selected(isset($settings['reviews_per_page']) ? $settings['reviews_per_page'] : '5', '15'); ?>>15 <?php esc_html_e('reviews', 'reviewxpress'); ?></option>
                            <option value="20" <?php selected(isset($settings['reviews_per_page']) ? $settings['reviews_per_page'] : '5', '20'); ?>>20 <?php esc_html_e('reviews', 'reviewxpress'); ?></option>
                            <option value="25" <?php selected(isset($settings['reviews_per_page']) ? $settings['reviews_per_page'] : '5', '25'); ?>>25 <?php esc_html_e('reviews', 'reviewxpress'); ?></option>
                        </select>
                        <div class="rx-form-help"><?php esc_html_e('Choose how many reviews to display per page. The rest will be shown on subsequent pages.', 'reviewxpress'); ?></div>
                    </div>

                    <!-- Скрито поле за show_reviews - се задава автоматично въз основа на review_mode -->
                    <input type="hidden" id="show_reviews" name="show_reviews" value="<?php echo esc_attr($settings['show_reviews'] ?? 0); ?>">
                </section>
            </div>

            <!-- Модерация и WooCommerce интеграция -->
            <div class="rx-sections-grid">
                <section class="rx-form-section">
                    <h3><?php esc_html_e('Content Moderation', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <label for="content_moderation"><?php esc_html_e('Moderation Level', 'reviewxpress'); ?></label>
                        <select id="content_moderation" name="content_moderation">
                            <option value="none" <?php selected($settings['content_moderation'] ?? 'standard', 'none'); ?>><?php esc_html_e('No Moderation', 'reviewxpress'); ?></option>
                            <option value="standard" <?php selected($settings['content_moderation'] ?? 'standard', 'standard'); ?>><?php esc_html_e('Standard Moderation', 'reviewxpress'); ?></option>
                            <option value="strict" <?php selected($settings['content_moderation'] ?? 'standard', 'strict'); ?>><?php esc_html_e('Strict Moderation', 'reviewxpress'); ?></option>
                        </select>
                        <div class="rx-form-help"><?php esc_html_e('Automatic check for spam and inappropriate content', 'reviewxpress'); ?></div>
                    </div>
                </section>

                <section class="rx-form-section">
                    <h3><?php esc_html_e('WooCommerce Integration', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <div class="rx-checkbox-group">
                            <input type="checkbox" id="require_woocommerce_order" name="require_woocommerce_order" value="1" <?php checked(!empty($settings['require_woocommerce_order'])); ?>>
                            <label for="require_woocommerce_order"><?php esc_html_e('Require WooCommerce Order for Review', 'reviewxpress'); ?></label>
                        </div>
                        <div class="rx-form-help"><?php esc_html_e('Only customers with completed orders can leave a review', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group">
                        <div class="rx-checkbox-group">
                            <input type="checkbox" id="allow_guest_reviews" name="allow_guest_reviews" value="1" <?php checked(!empty($settings['allow_guest_reviews'])); ?>>
                            <label for="allow_guest_reviews"><?php esc_html_e('Allow Guest Reviews', 'reviewxpress'); ?></label>
                        </div>
                        <div class="rx-form-help"><?php esc_html_e('Unregistered users can leave a review', 'reviewxpress'); ?></div>
                    </div>
                </section>
            </div>


            <!-- Купони за награди и Имейли -->
            <div class="rx-sections-grid">
                <section class="rx-form-section" style="position: relative; opacity: 0.6;">
                    <div style="position: absolute; top: 10px; right: 10px; background: #ffd600; color: #161616; padding: 4px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                        <?php esc_html_e('Pro Version', 'reviewxpress'); ?>
                    </div>
                    <h3><?php esc_html_e('Reward Coupons', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <div class="rx-checkbox-group">
                            <input type="checkbox" id="reward_coupon_enabled" name="reward_coupon_enabled" value="1" disabled>
                            <label for="reward_coupon_enabled" style="opacity: 0.7;"><?php esc_html_e('Enable Reward Coupons', 'reviewxpress'); ?></label>
                        </div>
                        <div class="rx-form-help"><?php esc_html_e('Automatically generate coupons for customers who leave reviews', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></div>
                    </div>

                    <div class="rx-form-group">
                        <label for="reward_coupon_type" style="opacity: 0.7;"><?php esc_html_e('Coupon Type', 'reviewxpress'); ?></label>
                        <select id="reward_coupon_type" name="reward_coupon_type" disabled>
                            <option value="percent" selected><?php esc_html_e('Percentage Discount', 'reviewxpress'); ?></option>
                            <option value="fixed_cart"><?php esc_html_e('Fixed Amount', 'reviewxpress'); ?></option>
                        </select>
                    </div>

                    <div class="rx-form-group">
                        <label for="reward_coupon_amount" style="opacity: 0.7;"><?php esc_html_e('Coupon Value', 'reviewxpress'); ?></label>
                        <input type="number" id="reward_coupon_amount" name="reward_coupon_amount" value="10" min="1" max="100" step="0.01" disabled>
                        <div class="rx-form-help"><?php esc_html_e('For percentage: 10 = 10%, For fixed amount: 10 = $10', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group">
                        <label for="reward_coupon_days" style="opacity: 0.7;"><?php esc_html_e('Validity (days)', 'reviewxpress'); ?></label>
                        <input type="number" id="reward_coupon_days" name="reward_coupon_days" value="7" min="1" max="365" disabled>
                    </div>

                    <div class="rx-form-group">
                        <label for="reward_coupon_prefix" style="opacity: 0.7;"><?php esc_html_e('Coupon Prefix', 'reviewxpress'); ?></label>
                        <input type="text" id="reward_coupon_prefix" name="reward_coupon_prefix" value="REVIEW-" placeholder="REVIEW-" disabled>
                        <div class="rx-form-help"><?php esc_html_e('The prefix will be added before the coupon code', 'reviewxpress'); ?></div>
                    </div>
                </section>

                <section class="rx-form-section" style="position: relative; opacity: 0.6;">
                    <div style="position: absolute; top: 10px; right: 10px; background: #ffd600; color: #161616; padding: 4px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                        <?php esc_html_e('Pro Version', 'reviewxpress'); ?>
                    </div>
                    <h3><?php esc_html_e('Automatic Emails', 'reviewxpress'); ?></h3>
                    
                    <div class="rx-form-group">
                        <div class="rx-checkbox-group">
                            <input type="checkbox" id="auto_email_customer" name="auto_email_customer" value="1" disabled>
                            <label for="auto_email_customer" style="opacity: 0.7;"><?php esc_html_e('Send Automatic Review Emails', 'reviewxpress'); ?></label>
                        </div>
                        <div class="rx-form-help"><?php esc_html_e('Emails are sent after completed orders', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></div>
                    </div>


                    <div class="rx-form-group">
                        <label for="email_delay_days" style="opacity: 0.7;"><?php esc_html_e('Review Request Delay (days)', 'reviewxpress'); ?></label>
                        <input type="number" id="email_delay_days" name="email_delay_days" value="7" min="0" max="30" disabled>
                        <div class="rx-form-help"><?php esc_html_e('How many days after order completion to send review request (0 = immediately)', 'reviewxpress'); ?></div>
                    </div>

                    <div class="rx-form-group">
                        <label for="reward_coupon_delay_days" style="opacity: 0.7;"><?php esc_html_e('Coupon Sending Delay (days)', 'reviewxpress'); ?></label>
                        <input type="number" id="reward_coupon_delay_days" name="reward_coupon_delay_days" value="0" min="0" max="30" disabled>
                        <div class="rx-form-help"><?php esc_html_e('How many days after review to send coupon (0 = immediately)', 'reviewxpress'); ?></div>
                    </div>
                </section>
            </div>

            <div class="rx-submit-section">
                <button type="submit" class="btn primary"><?php esc_html_e('Save Settings', 'reviewxpress'); ?></button>
            </div>
    </form>
</div>
</div>
