<?php
/**
 * Настройки за имейли
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.WP.I18n.TextDomainMismatch -- 'reviewxpress' is the correct text domain
?>

<div id="rx-settings">
    <div class="rx-wrap">
        <h1 class="title"><?php esc_html_e('Email Settings', 'reviewxpress'); ?></h1>
        <p class="subtitle"><?php esc_html_e('Configure emails for review requests and reward coupons.', 'reviewxpress'); ?></p>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
            <?php wp_nonce_field('reviewxpress_settings', 'reviewxpress_settings_nonce'); ?>
            <input type="hidden" name="action" value="reviewxpress_save_settings">
            <input type="hidden" name="rx_section" value="emails">

            <!-- SMTP настройки -->
            <section class="rx-form-section" style="position: relative; opacity: 0.6;">
                <div style="position: absolute; top: 10px; right: 10px; background: #ffd600; color: #161616; padding: 4px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                    <?php esc_html_e('Pro Version', 'reviewxpress'); ?>
                </div>
                <h3><?php esc_html_e('SMTP Settings', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-group">
                    <div class="rx-checkbox-group">
                        <input type="checkbox" id="smtp_enabled" name="smtp_enabled" value="1" disabled>
                        <label for="smtp_enabled" style="opacity: 0.7;"><?php esc_html_e('Enable SMTP', 'reviewxpress'); ?></label>
                    </div>
                    <div class="rx-form-help">
                        <?php esc_html_e('Use SMTP server to send emails instead of the standard PHP function', 'reviewxpress'); ?>
                        <br><strong style="color: #6b7280;">○ <?php esc_html_e('Available in Pro version', 'reviewxpress'); ?></strong>
                    </div>
                </div>

                <div class="rx-form-columns">
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="smtp_host" style="opacity: 0.7;"><?php esc_html_e('SMTP Host', 'reviewxpress'); ?></label>
                            <input type="text" id="smtp_host" name="smtp_host" value="" placeholder="smtp.gmail.com" disabled>
                            <div class="rx-form-help"><?php esc_html_e('The SMTP server address', 'reviewxpress'); ?></div>
                        </div>
                        
                        <div class="rx-form-group">
                            <label for="smtp_port" style="opacity: 0.7;"><?php esc_html_e('SMTP Port', 'reviewxpress'); ?></label>
                            <input type="number" id="smtp_port" name="smtp_port" value="587" placeholder="587" disabled>
                            <div class="rx-form-help"><?php esc_html_e('The SMTP server port (587 for TLS, 465 for SSL)', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                    
                    <div class="rx-form-column">
                        <div class="rx-form-group">
                            <label for="smtp_username" style="opacity: 0.7;"><?php esc_html_e('SMTP Username', 'reviewxpress'); ?></label>
                            <input type="text" id="smtp_username" name="smtp_username" value="" placeholder="your-email@gmail.com" disabled>
                            <div class="rx-form-help"><?php esc_html_e('The username for SMTP', 'reviewxpress'); ?></div>
                        </div>
                        
                        <div class="rx-form-group">
                            <label for="smtp_password" style="opacity: 0.7;"><?php esc_html_e('SMTP Password', 'reviewxpress'); ?></label>
                            <input type="password" id="smtp_password" name="smtp_password" value="" placeholder="••••••••" disabled>
                            <div class="rx-form-help"><?php esc_html_e('The password for SMTP (or App Password for Gmail)', 'reviewxpress'); ?></div>
                        </div>
                    </div>
                </div>

                <div class="rx-form-group">
                    <label for="smtp_encryption" style="opacity: 0.7;"><?php esc_html_e('Encryption', 'reviewxpress'); ?></label>
                    <select id="smtp_encryption" name="smtp_encryption" disabled>
                        <option value="none"><?php esc_html_e('No encryption', 'reviewxpress'); ?></option>
                        <option value="tls" selected><?php esc_html_e('TLS', 'reviewxpress'); ?></option>
                        <option value="ssl"><?php esc_html_e('SSL', 'reviewxpress'); ?></option>
                    </select>
                    <div class="rx-form-help"><?php esc_html_e('The encryption type for the SMTP connection', 'reviewxpress'); ?></div>
                </div>
            </section>

            <!-- Имейл за молба за ревю -->
            <section class="rx-form-section" style="position: relative; opacity: 0.6;">
                <div style="position: absolute; top: 10px; right: 10px; background: #ffd600; color: #161616; padding: 4px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                    <?php esc_html_e('Pro Version', 'reviewxpress'); ?>
                </div>
                <h3><?php esc_html_e('Email for Review Request', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-group">
                    <label for="email_request_subject" style="opacity: 0.7;"><?php esc_html_e('Email Subject', 'reviewxpress'); ?></label>
                    <input type="text" id="email_request_subject" name="email_request_subject" value="" placeholder="<?php esc_attr_e('Please leave a review for {product}', 'reviewxpress'); ?>" disabled>
                    <div class="rx-form-help"><?php esc_html_e('Available variables: {name}, {product}, {review_url}', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></div>
                </div>

                <div class="rx-form-group">
                    <label for="email_request_body" style="opacity: 0.7;"><?php esc_html_e('Email Content', 'reviewxpress'); ?></label>
                    <textarea id="email_request_body" name="email_request_body" rows="8" placeholder="<?php esc_attr_e('Hello, {name}!

Thank you for your order! Now that you have received your product, we would like to hear your opinion on {product}.

Your review will help other customers make an informed decision.

Leave a review: {review_url}

Best regards,
The Team', 'reviewxpress'); ?>" disabled></textarea>
                    <div class="rx-form-help"><?php esc_html_e('Available variables: {name}, {product}, {review_url}', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></div>
                </div>
            </section>

            <!-- Имейл за купон за награда -->
            <section class="rx-form-section" style="position: relative; opacity: 0.6;">
                <div style="position: absolute; top: 10px; right: 10px; background: #ffd600; color: #161616; padding: 4px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px;">
                    <?php esc_html_e('Pro Version', 'reviewxpress'); ?>
                </div>
                <h3><?php esc_html_e('Email for Reward Coupon', 'reviewxpress'); ?></h3>
                
                <div class="rx-form-group">
                    <label for="email_coupon_subject" style="opacity: 0.7;"><?php esc_html_e('Email Subject', 'reviewxpress'); ?></label>
                    <input type="text" id="email_coupon_subject" name="email_coupon_subject" value="" placeholder="<?php esc_attr_e('Thank you for your review! Your promo code', 'reviewxpress'); ?>" disabled>
                    <div class="rx-form-help"><?php esc_html_e('Available variables: {name}, {code}, {discount}, {days}', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></div>
                </div>

                <div class="rx-form-group">
                    <label for="email_coupon_body" style="opacity: 0.7;"><?php esc_html_e('Email Content', 'reviewxpress'); ?></label>
                    <textarea id="email_coupon_body" name="email_coupon_body" rows="8" placeholder="<?php esc_attr_e('Hello, {name}!

Thank you for leaving a review. As a token of appreciation, we are sending you a one-time promo code:

{code}

Discount: {discount}
Validity: {days} days

The coupon can be used only once and only for the email address you used to submit the review.

Happy shopping!

Best regards,
The Team', 'reviewxpress'); ?>" disabled></textarea>
                    <div class="rx-form-help"><?php esc_html_e('Available variables: {name}, {code}, {discount}, {days}', 'reviewxpress'); ?> <strong style="color: #6b7280;">(<?php esc_html_e('Available in Pro version', 'reviewxpress'); ?>)</strong></div>
                </div>
            </section>

            <div class="rx-submit-section">
                <button type="submit" class="btn primary"><?php esc_html_e('Save Settings', 'reviewxpress'); ?></button>
            </div>
        </form>
    </div>
</div>
