<?php
/**
 * Шаблон за списък с ревюта в админ панела
 */

if (!defined('ABSPATH')) {
    exit;
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
// Template variables are local scope, not global
?>

<div id="rx-list">
    <div class="rx-wrap">
    <div class="headbar">
        <div class="left">
            <span class="badge-title">ReviewXpress • Админ</span>
        </div>
        <div class="right">
            <a href="https://wpsupporting.com/" target="_blank" class="btn" style="background: var(--accent); color: #161616; text-decoration: none;">
                <span style="margin-right: 6px;">🚀</span>
                wpsupporting.com
            </a>
            <button class="btn"><?php esc_html_e('Export', 'reviewxpress'); ?></button>
            <button class="btn primary"><?php esc_html_e('New Review', 'reviewxpress'); ?></button>
        </div>
    </div>
    <h1 class="title"><?php esc_html_e('All Reviews', 'reviewxpress'); ?></h1>
    <p class="subtitle"><?php esc_html_e('Modern two-column view, compatible with previous style (black + yellow accents).', 'reviewxpress'); ?></p>

    <!-- Stats -->
    <section class="stats">
        <div class="stat">
            <small><?php esc_html_e('Total Reviews', 'reviewxpress'); ?></small>
            <b><?php echo esc_html($stats->total); ?></b>
        </div>
        <div class="stat">
            <small><?php esc_html_e('Pending Approval', 'reviewxpress'); ?></small>
            <b><?php echo esc_html($stats->pending); ?></b>
        </div>
        <div class="stat">
            <small><?php esc_html_e('Approved', 'reviewxpress'); ?></small>
            <b><?php echo esc_html($stats->approved); ?></b>
            <?php if ($stats->approved > 0): ?>
            <span class="trend">+100% this month</span>
            <?php endif; ?>
        </div>
        <div class="stat">
            <small><?php esc_html_e('Rejected', 'reviewxpress'); ?></small>
            <b><?php echo esc_html($stats->rejected); ?></b>
        </div>
        <div class="stat">
            <small><?php esc_html_e('Average Rating', 'reviewxpress'); ?></small>
            <b><?php echo esc_html($stats->average_rating ? round($stats->average_rating, 1) : '0.0'); ?> &#9733;</b>
        </div>
        <div class="stat">
            <small><?php esc_html_e('Review Images', 'reviewxpress'); ?></small>
            <b>0</b>
        </div>
    </section>
    
    <!-- Filters -->
    <section class="filters">
        <form id="rx-filters-form" method="get" action="" role="search">
            <input type="hidden" name="page" value="reviewxpress">
            
            <select name="status" class="select">
                <option value="all" <?php selected($status, 'all'); ?>><?php esc_html_e('All Statuses', 'reviewxpress'); ?></option>
                <option value="pending" <?php selected($status, 'pending'); ?>><?php esc_html_e('Pending', 'reviewxpress'); ?></option>
                <option value="approved" <?php selected($status, 'approved'); ?>><?php esc_html_e('Approved', 'reviewxpress'); ?></option>
                <option value="rejected" <?php selected($status, 'rejected'); ?>><?php esc_html_e('Rejected', 'reviewxpress'); ?></option>
            </select>
            
            <select name="product_id" class="select">
                <option value="0"><?php esc_html_e('All Products', 'reviewxpress'); ?></option>
                <?php
                $products = get_posts(array(
                    'post_type' => 'product',
                    'posts_per_page' => -1,
                    'post_status' => 'publish'
                ));
                foreach ($products as $product) {
                    echo '<option value="' . esc_attr($product->ID) . '" ' . selected($product_id, $product->ID, false) . '>' . esc_html($product->post_title) . '</option>';
                }
                ?>
            </select>
            
            <input type="text" name="s" class="input" value="<?php echo esc_attr($search); ?>" placeholder="<?php esc_html_e('Search by author, email, product...', 'reviewxpress'); ?>" style="min-width:280px" />
            
            <button id="rx-reset-btn" type="button" class="btn"><?php esc_html_e('Reset', 'reviewxpress'); ?></button>
            <button type="submit" class="btn primary"><?php esc_html_e('Filter', 'reviewxpress'); ?></button>
        </form>
    </section>
    
    <!-- Table -->
    <section class="rx-card">
        <table>
            <thead>
                <tr>
                    <th class="chk"><input type="checkbox" /></th>
                    <th><?php esc_html_e('ID', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Product', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Author', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Email', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Rating', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Review', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Media', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Status', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Date', 'reviewxpress'); ?></th>
                    <th><?php esc_html_e('Actions', 'reviewxpress'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($reviews)): ?>
                <tr>
                    <td colspan="11" class="no-items"><?php esc_html_e('No reviews found.', 'reviewxpress'); ?></td>
                </tr>
                <?php else: ?>
                <?php foreach ($reviews as $review): ?>
                <tr data-review-id="<?php echo esc_attr($review->id); ?>">
                    <td class="chk"><input type="checkbox" /></td>
                    <td><?php echo esc_html($review->id); ?></td>
                    <td>
                        <?php if (!empty($review->product_name)): ?>
                        <a class="pill" href="<?php echo esc_url(get_edit_post_link($review->product_id)); ?>" target="_blank">
                            <?php echo esc_html($review->product_name); ?>
                        </a>
                        <?php else: ?>
                        <span class="pill"><?php echo esc_html($review->product_id); ?></span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo esc_html($review->name); ?></td>
                    <td><?php echo esc_html($review->email); ?></td>
                    <td>
                        <span class="rating">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <i class="star <?php echo esc_attr($i <= $review->rating ? 'on' : ''); ?>"></i>
                            <?php endfor; ?>
                        </span>
                        <small><?php echo esc_html($review->rating); ?></small>
                    </td>
                    <td>
                        <?php if (!empty($review->review_text)): ?>
                        <?php echo esc_html(wp_trim_words($review->review_text, 20)); ?>
                        <?php else: ?>
                        <span class="muted"><?php esc_html_e('No text', 'reviewxpress'); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if (!empty($review->media)): ?>
                        <div class="rx-media-preview">
                            <?php 
                            $image_count = 0;
                            $video_count = 0;
                            $media_html = '';
                            foreach ($review->media as $media) {
                                if ($media['type'] === 'image') {
                                    $image_count++;
                                    $media_html .= '<img src="' . esc_url($media['url']) . '" alt="Review image" class="rx-media-thumb" style="width: 30px; height: 30px; object-fit: cover; border-radius: 4px; margin-right: 5px;">';
                                }
                                if ($media['type'] === 'video') {
                                    $video_count++;
                                    $media_html .= '<div class="rx-video-thumb" style="width: 30px; height: 30px; background: #f3f4f6; border-radius: 4px; display: inline-flex; align-items: center; justify-content: center; margin-right: 5px; font-size: 12px;">&#127909;</div>';
                                }
                            }
                            echo wp_kses_post($media_html);
                            if ($image_count > 0) echo '<span style="font-size: 11px; color: #6b7280;">&#128247; ' . esc_html($image_count) . '</span>';
                            if ($video_count > 0) echo '<span style="font-size: 11px; color: #6b7280;">&#127909; ' . esc_html($video_count) . '</span>';
                            ?>
                        </div>
                        <?php else: ?>
                        <span class="muted"><?php esc_html_e('No media', 'reviewxpress'); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="badge <?php echo esc_attr($review->status === 'approved' ? 'ok' : ($review->status === 'pending' ? 'pend' : 'den')); ?>">
                            <?php
                            switch ($review->status) {
                                case 'pending':
                                    esc_html_e('PENDING', 'reviewxpress');
                                    break;
                                case 'approved':
                                    esc_html_e('APPROVED', 'reviewxpress');
                                    break;
                                case 'rejected':
                                    esc_html_e('REJECTED', 'reviewxpress');
                                    break;
                            }
                            ?>
                        </span>
                    </td>
                    <td><?php echo esc_html(date_i18n('d M Y', strtotime($review->created_at))); ?></td>
                    <td class="actions">
                        <?php if ($review->status === 'pending'): ?>
                        <button type="button" class="btn xs rx-approve-btn" data-review-id="<?php echo esc_attr($review->id); ?>">
                            <?php esc_html_e('Approve', 'reviewxpress'); ?>
                        </button>
                        <button type="button" class="btn xs rx-reject-btn" data-review-id="<?php echo esc_attr($review->id); ?>">
                            <?php esc_html_e('Reject', 'reviewxpress'); ?>
                        </button>
                        <?php endif; ?>
                        
                        <button type="button" class="btn xs rx-view-btn" data-review-id="<?php echo esc_attr($review->id); ?>">
                            <?php esc_html_e('View', 'reviewxpress'); ?>
                        </button>
                        
                        <button type="button" class="btn xs danger rx-delete-btn" data-review-id="<?php echo esc_attr($review->id); ?>">
                            <?php esc_html_e('Delete', 'reviewxpress'); ?>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="table-foot">
            <div class="muted" style="font-size:12px;">
                <?php 
                $start = ($stats->total > 0) ? (($current_page - 1) * $per_page + 1) : 0;
                $end   = ($stats->total > 0) ? min($current_page * $per_page, $stats->total) : 0;
                // translators: %1$d is the start number, %2$d is the end number, %3$d is the total number
                printf(esc_html__('Showing %1$d–%2$d of %3$d', 'reviewxpress'), esc_html($start), esc_html($end), esc_html($stats->total));
                ?>
            </div>
            <div class="pagination">
                <?php
                $total_pages = ceil($stats->total / $per_page);
                if ($current_page > 1) {
                    echo '<a href="' . esc_url(add_query_arg('paged', $current_page - 1)) . '" class="page">‹</a>';
                }
                for ($i = max(1, $current_page - 2); $i <= min($total_pages, $current_page + 2); $i++) {
                    $active = $i == $current_page ? 'active' : '';
                    echo '<a href="' . esc_url(add_query_arg('paged', $i)) . '" class="page ' . esc_attr($active) . '">' . esc_html($i) . '</a>';
                }
                if ($current_page < $total_pages) {
                    echo '<a href="' . esc_url(add_query_arg('paged', $current_page + 1)) . '" class="page">›</a>';
                }
                ?>
            </div>
        </div>
    </section>
    </div>
</div>

<!-- Review Details Modal -->
<div id="rx-review-modal" class="rx-modal">
    <div class="rx-modal-content">
        <div class="rx-modal-header">
            <h2><?php esc_html_e('Review Details', 'reviewxpress'); ?></h2>
            <button type="button" class="rx-modal-close">&times;</button>
        </div>
        <div class="rx-modal-body" id="rx-modal-body">
            <!-- Content will be loaded here -->
        </div>
    </div>
</div>
<?php
// phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

