<?php if (!defined('ABSPATH')) { exit; } ?>
<div id="rx-admin">
  <div class="about-wrap">
    <!-- Hero Section -->
    <section class="hero" role="banner" aria-label="Plugin introduction">
      <h1>ReviewXpress</h1>
      <div class="tagline">Effortless Review Management for WordPress</div>
      <p>
        ReviewXpress helps you gather, manage, and showcase customer reviews with ease. Designed to integrate seamlessly with your WordPress site, it offers powerful features to boost engagement and trust.
      </p>
    </section>

    <!-- Info Cards: Mission, Vision, Values -->
    <section class="info-cards" aria-label="Our mission, vision and values">
      <article class="rx-card" role="region" aria-labelledby="mission-title">
        <h3 id="mission-title">Mission</h3>
        <p>
          To empower website owners with simple yet effective tools to capture authentic customer feedback and enhance their online reputation.
        </p>
      </article>
      <article class="rx-card" role="region" aria-labelledby="vision-title">
        <h3 id="vision-title">Vision</h3>
        <p>
          To become the leading WordPress review management solution by prioritizing usability, reliability, and customer satisfaction.
        </p>
      </article>
      <article class="rx-card" role="region" aria-labelledby="values-title">
        <h3 id="values-title">Values</h3>
        <p>
          Transparency, innovation, and dedication to helping our users succeed in building trust with their audiences.
        </p>
      </article>
    </section>

    <!-- Features Grid -->
    <section class="features-grid" aria-label="Plugin features">
      <article class="rx-card feature-card" role="region" aria-labelledby="feature-1">
        <div class="icon" aria-hidden="true">&#9733;</div>
        <div class="name" id="feature-1">Easy Review Collection</div>
      </article>
      <article class="rx-card feature-card" role="region" aria-labelledby="feature-2">
        <div class="icon" aria-hidden="true">⚙</div>
        <div class="name" id="feature-2">Customizable Templates</div>
      </article>
      <article class="rx-card feature-card" role="region" aria-labelledby="feature-3">
        <div class="icon" aria-hidden="true">📊</div>
        <div class="name" id="feature-3">Detailed Analytics</div>
      </article>
      <article class="rx-card feature-card" role="region" aria-labelledby="feature-4">
        <div class="icon" aria-hidden="true">🔔</div>
        <div class="name" id="feature-4">Automated Notifications</div>
      </article>
      <article class="rx-card feature-card" role="region" aria-labelledby="feature-5">
        <div class="icon" aria-hidden="true">🌐</div>
        <div class="name" id="feature-5">Multilingual Support</div>
      </article>
      <article class="rx-card feature-card" role="region" aria-labelledby="feature-6">
        <div class="icon" aria-hidden="true">🔒</div>
        <div class="name" id="feature-6">Secure & GDPR Compliant</div>
      </article>
    </section>

    <!-- Technical Info + Support Side-by-Side -->
    <section class="side-by-side" aria-label="Technical information and support">
      <article class="rx-card" role="region" aria-labelledby="technical-info-title">
        <h3 id="technical-info-title">Technical Info</h3>
        <p><strong>Version:</strong> 1.0.0</p>
        <p><strong>WordPress Compatibility:</strong> Tested up to 6.9 (compatible with 5.0 and above)</p>
        <p><strong>PHP Version:</strong> 7.2 or higher recommended</p>
        <p><strong>Last Updated:</strong> December 2025</p>
      </article>
      <article class="rx-card" role="region" aria-labelledby="support-title">
        <h3 id="support-title">Support</h3>
        <p>
          Need help? Visit our <a href="https://wpsupporting.com/contact-us/" target="_blank" rel="noopener noreferrer">Support Center</a> or email us at <a href="mailto:support@wpsupporting.com">support@wpsupporting.com</a>.
        </p>
        <p>
          We are committed to providing timely assistance and regular updates to ensure your experience is smooth and productive.
        </p>
      </article>
    </section>

    <!-- Roadmap + News Side-by-Side -->
    <section class="side-by-side" aria-label="Roadmap and news updates">
      <article class="rx-card" role="region" aria-labelledby="roadmap-title">
        <h3 id="roadmap-title">Roadmap</h3>
        <ul>
          <li><strong>Q4 2025:</strong> Divi Builder support</li>
          <li><strong>Q1 2026:</strong> Elementor integration - Coming soon</li>
          <li><strong>Q1 2026:</strong> Flatsome integration - Coming soon</li>
        </ul>
      </article>
      <article class="rx-card" role="region" aria-labelledby="news-title">
        <h3 id="news-title">News</h3>
        <ul>
          <li><strong>Version 1.0:</strong> Stable release with full WooCommerce integration</li>
          <li><strong>Version 1.1:</strong> Divi Builder support - Coming in Q4 2025</li>
          <li><strong>Version 1.2:</strong> Elementor and Flatsome - Coming soon</li>
        </ul>
      </article>
    </section>

    <!-- Footer -->
    <footer class="rx-footer" role="contentinfo">
      <p>© 2025 ReviewXpress. All rights reserved.</p>
      <p>Contact us: <a href="mailto:support@wpsupporting.com">support@wpsupporting.com</a> | <a href="https://wpsupporting.com" target="_blank" rel="noopener noreferrer">www.wpsupporting.com</a></p>
    </footer>
  </div>
</div>

