<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
/**
 * Plugin Name: ReviewXpress
 * Plugin URI: https://wpsupporting.com/
 * Description: Powerful review management plugin with WooCommerce integration, drag & drop uploader and admin panel.
 * Version: 1.0.3
 * Author: wpsupporting
 * License: GPL v2 or later
 * Text Domain: reviewxpress
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.5
 */

// Константи
define('REVIEWXPRESS_VERSION', '1.0.3');
define('REVIEWXPRESS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('REVIEWXPRESS_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('REVIEWXPRESS_PLUGIN_BASENAME', plugin_basename(__FILE__));


// Проверяваме дали WooCommerce е активен и е правилната версия
add_action('admin_init', 'reviewxpress_check_woocommerce');

if (!function_exists('reviewxpress_check_woocommerce')) {
    function reviewxpress_check_woocommerce() {
        if (!class_exists('WooCommerce')) {
            add_action('admin_notices', 'reviewxpress_woocommerce_notice');
            return;
        }
        
        // Проверяваме версията на WooCommerce
        if (version_compare(WC()->version, '5.0', '<')) {
            add_action('admin_notices', 'reviewxpress_woocommerce_version_notice');
        }
    }
}

if (!function_exists('reviewxpress_woocommerce_notice')) {
    function reviewxpress_woocommerce_notice() {
        echo '<div class="notice notice-error"><p>';
        echo esc_html__('ReviewXpress requires WooCommerce plugin to be active!', 'reviewxpress');
        echo '</p></div>';
    }
}

if (!function_exists('reviewxpress_woocommerce_version_notice')) {
    function reviewxpress_woocommerce_version_notice() {
        echo '<div class="notice notice-error"><p>';
        echo esc_html__('ReviewXpress requires WooCommerce version 5.0 or newer!', 'reviewxpress');
        echo '</p></div>';
    }
}

// Зареждаме основните класове
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress.php';
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-database.php';
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-woocommerce.php';
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-admin.php';
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-frontend.php';
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-ajax.php';
require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-integrations.php';

// Инициализираме плъгина
if (!function_exists('reviewxpress_init')) {
    function reviewxpress_init() {
        $reviewxpress = ReviewXpress::get_instance();
        $reviewxpress->init();
    }
}
add_action('plugins_loaded', 'reviewxpress_init');

// WooCommerce compatibility
add_action('before_woocommerce_init', function() {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
    }
});

// Активация на плъгина
register_activation_hook(__FILE__, 'reviewxpress_activate');
if (!function_exists('reviewxpress_activate')) {
    function reviewxpress_activate() {
        // Уверяваме се че класовете са заредени
        if (!class_exists('ReviewXpress_Database')) {
            require_once REVIEWXPRESS_PLUGIN_PATH . 'includes/class-reviewxpress-database.php';
        }
        
        // Създаваме таблиците в базата данни
        $database = new ReviewXpress_Database();
        $database->create_tables();
        
        // Създаваме опциите по подразбиране (само ако не съществуват)
        if (get_option('reviewxpress_settings') === false) {
            add_option('reviewxpress_settings', array(
                'auto_approve' => 0,
                'require_woocommerce_order' => 1,
                'allow_guest_reviews' => 0,
                'max_images' => 5,
                'max_video_size' => 50, // MB
                'allowed_image_types' => 'jpg,jpeg,png',
                'auto_email_customer' => 1,
                'email_template' => 'default'
            ));
        }
        
        // Flush rewrite rules
        flush_rewrite_rules();
    }
}

// Деактивация на плъгина
register_deactivation_hook(__FILE__, 'reviewxpress_deactivate');
if (!function_exists('reviewxpress_deactivate')) {
    function reviewxpress_deactivate() {
        flush_rewrite_rules();
    }
}
