<?php

/**
 * Template for displaying the Google Review Wall shortcode.
 */

defined('ABSPATH') || exit;

// Get DB instance
$db = Review_Wall_Helper::get_db_instance();

// Get reviews
$reviews = $db->get_google_reviews();

// Get global settings
$google_average_rating = get_option('review_wall_google_average_rating');
$google_total_reviews  = get_option('review_wall_google_total_reviews');
$google_reviews_link   = get_option('review_wall_google_reviews_link');

// get rating for stars
$rating     = floatval($google_average_rating);
$full_stars = floor($rating);
$decimal    = round($rating - $full_stars, 2);

// determine partial star type based on decimal value (9 levels of precision)
$partial_star_type = '';
if ($decimal >= 0.05 && $decimal < 0.15) {
    $partial_star_type = '10';
} elseif ($decimal >= 0.15 && $decimal < 0.25) {
    $partial_star_type = '20';
} elseif ($decimal >= 0.25 && $decimal < 0.35) {
    $partial_star_type = '30';
} elseif ($decimal >= 0.35 && $decimal < 0.45) {
    $partial_star_type = '40';
} elseif ($decimal >= 0.45 && $decimal < 0.55) {
    $partial_star_type = '50';
} elseif ($decimal >= 0.55 && $decimal < 0.65) {
    $partial_star_type = '60';
} elseif ($decimal >= 0.65 && $decimal < 0.75) {
    $partial_star_type = '70';
} elseif ($decimal >= 0.75 && $decimal < 0.85) {
    $partial_star_type = '80';
} elseif ($decimal >= 0.85 && $decimal < 0.95) {
    $partial_star_type = '90';
}

$has_partial = !empty($partial_star_type);
$empty_stars = 5 - $full_stars - ($has_partial ? 1 : 0);

// Get widget settings
$review_wall_widget_title                = get_option('review_wall_widget_title');
$review_wall_widget_btn_text             = get_option('review_wall_widget_btn_text');
$review_wall_widget_btn_link             = get_option('review_wall_widget_btn_link');
$review_wall_widget_read_more_text       = get_option('review_wall_widget_read_more_text');
$review_wall_widget_bg_color             = get_option('review_wall_widget_bg_color');
$review_wall_widget_btn_text_color       = get_option('review_wall_widget_btn_text_color');
$review_wall_widget_btn_bg_color         = get_option('review_wall_widget_btn_bg_color');
$review_wall_widget_btn_hover_text_color = get_option('review_wall_widget_btn_hover_text_color');
$review_wall_widget_btn_hover_bg_color   = get_option('review_wall_widget_btn_hover_bg_color');

?>

<?php if (!empty($reviews)) : ?>
    <div class="remodal rw-google-review-modal" data-remodal-id="rw-google-review" data-remodal-options="hashTracking: false">
        <button data-remodal-action="close" class="rw-google-review__close"></button>
    </div>

    <div class="rw-google-widget"
        style="
        --widget-bg-color: <?php echo esc_attr($review_wall_widget_bg_color); ?>;
        --widget-btn-text-color: <?php echo esc_attr($review_wall_widget_btn_text_color); ?>;
        --widget-btn-bg-color: <?php echo esc_attr($review_wall_widget_btn_bg_color); ?>;
        --widget-btn-hover-text-color: <?php echo esc_attr($review_wall_widget_btn_hover_text_color); ?>;
        --widget-btn-hover-bg-color: <?php echo esc_attr($review_wall_widget_btn_hover_bg_color); ?>;
     ">

        <div class="rw-google-widget__top">
            <div class="rw-google-widget__title"><?php echo esc_html($review_wall_widget_title); ?></div>

            <div class="rw-google-widget__arrows">
                <div class="rw-google-widget__arrow-prev swiper-button-prev">
                    <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8.5 15L1.5 8L8.5 1" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </div>
                <div class="rw-google-widget__arrow-next swiper-button-next">
                    <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8.5 15L1.5 8L8.5 1" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </div>
            </div>
        </div>

        <div class="rw-google-widget__info">
            <div class="rw-google-widget__info-item">
                <a href="<?php echo esc_url($google_reviews_link); ?>">
                    <div class="rw-google-widget__average-rating"><?php echo esc_html($google_average_rating); ?></div>

                    <div class="rw-google-widget__total-reviews">
                        <p class="rw-google-widget__subtitle"><?php esc_html_e('Google reviews', 'review-wall'); ?></p>

                        <div class="rw-google-widget__total-item">
                            <div class="rw-google-widget__stars">
                                <?php for ($i = 0; $i < $full_stars; $i++) : ?>
                                    <span class="rw-google-widget__star full">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#FDBF01" />
                                        </svg>
                                    </span>
                                <?php endfor; ?>

                                <?php if ($has_partial) : ?>
                                    <span class="rw-google-widget__star partial partial-<?php echo esc_attr($partial_star_type); ?>">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <defs>
                                                <linearGradient id="partial-gradient-<?php echo esc_attr($partial_star_type); ?>" x1="0%" y1="0%" x2="100%" y2="0%">
                                                    <stop offset="<?php echo esc_attr($partial_star_type); ?>%" style="stop-color:#FDBF01;stop-opacity:1" />
                                                    <stop offset="<?php echo esc_attr($partial_star_type); ?>%" style="stop-color:#C3C3C3;stop-opacity:1" />
                                                </linearGradient>
                                            </defs>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="url(#partial-gradient-<?php echo esc_attr($partial_star_type); ?>)" />
                                        </svg>
                                    </span>
                                <?php endif; ?>

                                <?php for ($i = 0; $i < $empty_stars; $i++) : ?>
                                    <span class="rw-google-widget__star empty">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#C3C3C3" />
                                        </svg>
                                    </span>
                                <?php endfor; ?>
                            </div>

                            <div class="rw-google-widget__total"><?php echo '(' . $google_total_reviews . ')'; ?></div>
                        </div>
                    </div>
                </a>
            </div>

            <a class="rw-google-widget__button" href="<?php echo esc_url(!empty($review_wall_widget_btn_link) ? $review_wall_widget_btn_link : $google_reviews_link); ?>" target="_blank">
                <?php echo esc_html($review_wall_widget_btn_text); ?>
            </a>
        </div>

        <div class="rw-google-widget__swiper swiper">
            <div class="swiper-wrapper">
                <?php foreach ($reviews as $review) : ?>
                    <div class="swiper-slide">
                        <div class="rw-google-card">
                            <div class="rw-google-card__top">
                                <?php if (!empty($review->review_author_photo)) :
                                    $photo_url = Review_Wall_Helper::get_photo_url($review->review_author_photo);
                                    if ($photo_url) : ?>
                                        <div class="rw-google-card__photo">
                                            <img src="<?php echo esc_url($photo_url); ?>" alt="<?php echo esc_attr($review->review_author); ?>">
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <p class="rw-google-card__author">
                                    <?php echo esc_html($review->review_author); ?>
                                </p>
                            </div>

                            <div class="rw-google-card__item">
                                <?php if ($review->review_rating > 0) : ?>
                                    <div class="rw-google-card__rating">
                                        <?php for ($i = 0; $i < 5; $i++) : ?>
                                            <?php if ($i < $review->review_rating) : ?>
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#FDBF01" />
                                                </svg>
                                            <?php else : ?>
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#C3C3C3" />
                                                </svg>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>
                                <?php endif; ?>

                                <?php if ($review->review_content) : ?>
                                    <?php
                                    $content      = wp_strip_all_tags($review->review_content);
                                    $limit        = 15;
                                    $words        = explode(' ', $content);
                                    $truncated    = implode(' ', array_slice($words, 0, $limit));
                                    $is_truncated = count($words) > $limit;
                                    ?>
                                    <p class="rw-google-card__content">
                                        <?php echo esc_html($truncated . ($is_truncated ? '...' : '')); ?>
                                        <?php if ($is_truncated) : ?>
                                            <a class="rw-google-card__read-more" href="#"
                                                data-remodal-target="rw-google-review"
                                                data-author="<?php echo esc_attr($review->review_author); ?>"
                                                data-rating="<?php echo esc_attr($review->review_rating); ?>"
                                                data-content="<?php echo esc_attr($review->review_content); ?>"
                                                <?php if (!empty($review->review_author_photo)) :
                                                    $photo_url = Review_Wall_Helper::get_photo_url($review->review_author_photo);
                                                ?>
                                                data-photo="<?php echo esc_url($photo_url); ?>"
                                                <?php endif; ?>>
                                                <?php echo esc_html($review_wall_widget_read_more_text); ?>
                                            </a>
                                        <?php endif; ?>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>