<?php

/**
 * 
 * This template is used to display the review wall page.
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

get_header();

// Get the URL key from URL with proper sanitization
$url_key = isset($_GET['id']) ? sanitize_text_field(wp_unslash($_GET['id'])) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

// Get DB instance
$db = Review_Wall_Helper::get_db_instance();

// Get URL info if key exists
$url_data = $db->get_url_by_key($url_key);

// Get URL link
$url_link = $url_data ? $url_data->url_link : get_option('review_wall_default_url');

// Get URL name
$url_name = $url_data ? $url_data->url_name : 'Default Google Review URL';

// Get logo and rating threshold
$logo             = get_option('review_wall_logo');
$rating_threshold = get_option('review_wall_rating_threshold');

// Get text settings
// Step 1
$title_step_1       = get_option('review_wall_title_step_1');
$description_step_1 = get_option('review_wall_description_step_1');
$btn_step_1         = get_option('review_wall_btn_step_1');

// Step 2
$title_step_2       = get_option('review_wall_title_step_2');
$description_step_2 = get_option('review_wall_description_step_2');
$comment_label      = get_option('review_wall_comment_label');
$email_label        = get_option('review_wall_email_label');
$btn_step_2         = get_option('review_wall_btn_step_2');

// Step 3
$title_step_3       = get_option('review_wall_title_step_3');
$btn_step_3         = get_option('review_wall_btn_step_3');

?>

<div class="review-wall">
    <div class="review-wall__container">
        <?php if ($url_link): ?>
            <div class="review-wall__wrapper">
                <?php if (!empty($logo)): ?>
                    <div class="review-wall__logo">
                        <a href="<?php echo esc_url(home_url()); ?>">
                            <?php echo wp_get_attachment_image($logo, 'medium', false, ['alt' => get_bloginfo('name')]); ?>
                        </a>
                    </div>
                <?php endif; ?>

                <div class="review-wall-form" data-rating-threshold="<?php echo esc_attr($rating_threshold); ?>" data-url="<?php echo esc_attr($url_link); ?>" data-url-name="<?php echo esc_attr($url_name); ?>">
                    <div class="review-wall-form__step step-1">
                        <h1 class="review-wall-form__title">
                            <?php echo esc_html($title_step_1); ?>
                        </h1>

                        <p class="review-wall-form__description">
                            <?php echo esc_html($description_step_1); ?>
                        </p>

                        <div class="review-wall-form__rating">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <span class="review-wall-star" data-rating="<?php echo esc_attr($i); ?>"></span>
                            <?php endfor; ?>
                        </div>

                        <button class="review-wall-form__btn" type="button" role="button">
                            <?php echo esc_html($btn_step_1); ?>
                        </button>
                    </div>

                    <div class="review-wall-form__step step-2" style="display: none;">
                        <h1 class="review-wall-form__title">
                            <?php echo esc_html($title_step_2); ?>
                        </h1>

                        <p class="review-wall-form__description">
                            <?php echo esc_html($description_step_2); ?>
                        </p>

                        <div class="review-wall-form__textarea">
                            <label for="review_wall_comment"><?php echo esc_html($comment_label); ?></label>
                            <textarea name="review_wall_comment" required></textarea>
                        </div>

                        <div class="review-wall-form__email">
                            <label for="review_wall_email"><?php echo esc_html($email_label); ?></label>
                            <input name="review_wall_email" type="email" required></input>
                        </div>

                        <button class="review-wall-form__btn" type="button" role="button">
                            <?php echo esc_html($btn_step_2); ?>
                        </button>
                    </div>

                    <div class="review-wall-form__step step-3" style="display: none;">
                        <h1 class="review-wall-form__title">
                            <?php echo esc_html($title_step_3); ?>
                        </h1>

                        <a class="review-wall-form__btn" href="<?php echo esc_url(home_url()); ?>">
                            <?php echo esc_html($btn_step_3); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="review-wall-error">
                <p><?php esc_html_e('Invalid review link. Please check the URL and try again or contact the administrator.', 'review-wall'); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php get_footer(); ?>