<?php

/**
 * Admin template for Google Reviews shortcode management and preview.
 *
 * Shows shortcode usage instructions, a copy shortcode button,
 * and a live preview of the reviews slider that shortcode will render on frontend.
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get DB instance
$db = Review_Wall_Helper::get_db_instance();

// Get reviews
$reviews = $db->get_google_reviews();

?>

<div class="review-wall-section review-wall-section-google">
    <div class="google-reviews-shortcode">
        <h2><?php esc_html_e('Google Reviews Shortcode', 'review-wall'); ?></h2>

        <p><?php esc_html_e('Use the shortcode below to display the reviews slider anywhere on your site.', 'review-wall'); ?></p>

        <div class="google-reviews-shortcode__item">
            <input type="text" readonly value="[review_wall_google_widget]" class="regular-text" id="review_shortcode" />

            <button type="button" class="button" id="copy_shortcode_button"><?php esc_html_e('Copy Shortcode', 'review-wall'); ?></button>
        </div>
    </div>

    <?php if (!empty($reviews)) : ?>
        <div class="google-reviews">
            <div class="google-reviews__top">
                <h3><?php esc_html_e('Added Reviews', 'review-wall'); ?></h3>

                <div class="google-reviews__arrows">
                    <div class="google-reviews__arrow-prev swiper-button-prev">
                        <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M8.5 15L1.5 8L8.5 1" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </div>
                    <div class="google-reviews__arrow-next swiper-button-next">
                        <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M8.5 15L1.5 8L8.5 1" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </div>
                </div>
            </div>

            <div class="google-reviews__swiper swiper">
                <div class="swiper-wrapper">
                    <?php foreach ($reviews as $review) : ?>
                        <div class="swiper-slide">
                            <div class="google-review-card">
                                <button class="google-review-card__delete-review button" data-review-id="<?php echo esc_attr($review->id); ?>">
                                    <?php esc_html_e('Delete', 'review-wall'); ?>
                                </button>

                                <div class="google-review-card__top">
                                    <?php if (!empty($review->review_author_photo)) : ?>
                                        <div class="google-review-card__photo">
                                            <?php echo wp_get_attachment_image($review->review_author_photo, 'medium', false, ['alt' => $review->review_author]); ?>
                                        </div>
                                    <?php endif; ?>

                                    <p class="google-review-card__author">
                                        <?php echo esc_html($review->review_author); ?>
                                    </p>
                                </div>

                                <div class="google-review-card__item">
                                    <?php if ($review->review_rating > 0) : ?>
                                        <div class="google-review-card__rating">
                                            <?php for ($i = 0; $i < 5; $i++) : ?>
                                                <?php if ($i < $review->review_rating) : ?>
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#FDBF01" />
                                                    </svg>
                                                <?php else : ?>
                                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M19.959 8.57966L15.8899 7.98865C15.6596 7.95965 15.4592 7.81464 15.353 7.60063L13.5387 3.94053C13.5357 3.93653 13.5337 3.93253 13.5318 3.92753C13.365 3.61652 13.106 3.35551 12.7934 3.18851C11.9527 2.7575 10.9096 3.08951 10.466 3.94053L8.6498 7.59964C8.54262 7.81364 8.34015 7.95965 8.10096 7.98965L4.04074 8.57966C3.64772 8.63866 3.30333 8.81467 3.04727 9.08666C2.73166 9.41567 2.56294 9.84968 2.57187 10.3077C2.5808 10.7657 2.7664 11.1907 3.09193 11.5047L6.03661 14.3608C6.20037 14.5148 6.27679 14.7498 6.23709 14.9788L5.54136 18.9969C5.48182 19.372 5.54533 19.759 5.71802 20.079C5.93439 20.489 6.29465 20.788 6.73333 20.924C6.89907 20.975 7.06879 21 7.23652 21C7.51242 21 7.78536 20.932 8.03248 20.799L11.6649 18.9069C11.8753 18.7939 12.1284 18.7939 12.3438 18.9089L15.9584 20.793C16.2829 20.973 16.6531 21.038 17.0431 20.978C17.9751 20.824 18.6132 19.934 18.4614 18.9889L17.7667 14.9788C17.726 14.7428 17.8014 14.5118 17.9731 14.3458L20.9088 11.5047C21.1838 11.2377 21.3644 10.8807 21.414 10.4997C21.5361 9.56767 20.8821 8.70567 19.959 8.57966Z" fill="#C3C3C3" />
                                                    </svg>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                    <?php endif; ?>

                                    <?php if ($review->review_content) : ?>
                                        <p class="google-review-card__content">
                                            <?php echo esc_html($review->review_content); ?>
                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>