<?php

/**
 * Admin template for manually adding a Google review.
 */

if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="review-wall-section">
    <h2><?php esc_html_e('Add Google Review', 'review-wall'); ?></h2>

    <form method="post" action="" class="review-wall-form">
        <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
        <input type="hidden" name="review_wall_submit_action" value="add_manual_google_review">

        <table class="form-table">
            <tr>
                <th><label for="review_author"><?php esc_html_e('Author Name', 'review-wall'); ?></label></th>
                <td>
                    <input type="text" name="review_author" id="review_author" class="regular-text" required />
                    <p class="description">
                        <?php esc_html_e('Full name of the reviewer.', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th><label for="review_author_photo"><?php esc_html_e('User Photo', 'review-wall'); ?></label></th>
                <td>
                    <input type="hidden" id="review_author_photo" name="review_author_photo" value="">
                    <button type="button" class="button" id="upload_author_photo_button"><?php esc_html_e('Upload Photo', 'review-wall'); ?></button>
                    <button type="button" class="button" id="remove_author_photo_button" style="display:none;"><?php esc_html_e('Remove Photo', 'review-wall'); ?></button>
                    <div id="author_photo_preview" style="margin-top:10px;"></div>
                    <p class="description">
                        <?php esc_html_e('Optional photo of the reviewer.', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th><label for="review_rating"><?php esc_html_e('Rating', 'review-wall'); ?></label></th>
                <td>
                    <input type="number" name="review_rating" id="review_rating" min="1" max="5" step="1" required class="small-text" />
                    <p class="description">
                        <?php esc_html_e('Rating from 1 to 5 stars.', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th><label for="review_content"><?php esc_html_e('Review Text', 'review-wall'); ?></label></th>
                <td>
                    <textarea name="review_content" id="review_content" rows="4" class="large-text" required></textarea>
                    <p class="description">
                        <?php esc_html_e('Full content of the user review.', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
        </table>

        <?php submit_button(__('Add Review', 'review-wall')); ?>
    </form>
</div>