<?php

/**
 * Main admin page template for Review Wall plugin.
 */

// Ensure WordPress environment
if (!defined('ABSPATH')) {
    exit;
}

// Process form submissions
Review_Wall_Form_Handler::process_form_submission();

// Get DB instance to interact with URLs
$db = Review_Wall_Helper::get_db_instance();

// Get all URLs
$urls = $db->get_urls();

// Get global settings
$logo             = get_option('review_wall_logo');
$rating_threshold = get_option('review_wall_rating_threshold');
$default_url      = get_option('review_wall_default_url');

?>

<div class="wrap review-wall-admin-wrap">
    <h1><?php esc_html_e('Review Wall Settings', 'review-wall'); ?></h1>

    <div class="review-wall-admin-container">
        <!-- Global settings section -->
        <?php Review_Wall::load_template('admin/components/global-settings.php', ['logo' => $logo, 'rating_threshold' => $rating_threshold, 'default_url' => $default_url]); ?>

        <!-- Text settings section -->
        <?php Review_Wall::load_template('admin/components/text-settings.php'); ?>

        <!-- Add new URL section -->
        <?php Review_Wall::load_template('admin/components/add-url.php'); ?>

        <!-- Existing URLs section -->
        <?php Review_Wall::load_template('admin/components/urls-list.php', ['urls' => $urls]); ?>
    </div>

    <!-- Modals -->
    <?php Review_Wall::load_template('admin/components/edit-url-modal.php'); ?>
    <?php Review_Wall::load_template('admin/components/delete-url-modal.php'); ?>
</div>