<?php

/**
 * Admin page template for managing Google Reviews in the Review Wall plugin.
 *
 * This page includes three sections:
 * 1. Global Google Reviews settings (average rating, total reviews, etc.)
 * 2. Manual review submission form
 * 3. List of added reviews with shortcode display
 */

if (!defined('ABSPATH')) {
    exit;
}

// Process form submissions
Review_Wall_Form_Handler::process_form_submission();

// Get DB instance
$db = Review_Wall_Helper::get_db_instance();

// Get reviews
$reviews = $db->get_google_reviews();

?>

<div class="wrap review-wall-admin-wrap">
    <h1><?php esc_html_e('Google Reviews', 'review-wall'); ?></h1>

    <div class="review-wall-admin-container">
        <?php Review_Wall::load_template('admin/sections/google-reviews-settings.php'); ?>

        <?php Review_Wall::load_template('admin/sections/google-review-add-manual.php'); ?>

        <?php if (!empty($reviews)) : ?>
            <?php Review_Wall::load_template('admin/sections/google-reviews-shortcode.php'); ?>
        <?php endif; ?>
    </div>
</div>