<?php

/**
 * URLs list template.
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="review-wall-section">
    <h2><?php esc_html_e('Existing URLs', 'review-wall'); ?></h2>

    <?php if (empty($urls)): ?>
        <p><?php esc_html_e('No URLs have been created yet.', 'review-wall'); ?></p>
    <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php esc_html_e('ID', 'review-wall'); ?></th>
                    <th><?php esc_html_e('Name', 'review-wall'); ?></th>
                    <th><?php esc_html_e('URL Key', 'review-wall'); ?></th>
                    <th><?php esc_html_e('Google Review URL', 'review-wall'); ?></th>
                    <th><?php esc_html_e('Created', 'review-wall'); ?></th>
                    <th><?php esc_html_e('Actions', 'review-wall'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($urls as $url): ?>
                    <tr>
                        <td><?php echo esc_html($url->id); ?></td>
                        <td>
                            <?php echo esc_html($url->url_name); ?>
                            <div class="row-actions">
                                <span class="view">
                                    <a href="<?php echo esc_url(home_url('/' . Review_Wall_Page_Manager::PAGE_SLUG . '/?id=' . $url->url_key)); ?>" target="_blank"><?php esc_html_e('View', 'review-wall'); ?></a>
                                </span>
                            </div>
                        </td>
                        <td><?php echo esc_html($url->url_key); ?></td>
                        <td>
                            <a href="<?php echo esc_url($url->url_link); ?>" target="_blank"><?php echo esc_url($url->url_link); ?></a>
                        </td>
                        <td><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($url->created_at))); ?></td>
                        <td>
                            <a href="#" class="edit-url"
                                data-id="<?php echo esc_attr($url->id); ?>"
                                data-name="<?php echo esc_attr($url->url_name); ?>"
                                data-key="<?php echo esc_attr($url->url_key); ?>"
                                data-url="<?php echo esc_url($url->url_link); ?>">
                                <?php esc_html_e('Edit', 'review-wall'); ?>
                            </a> |
                            <a href="#" class="delete-url"
                                data-id="<?php echo esc_attr($url->id); ?>">
                                <?php esc_html_e('Delete', 'review-wall'); ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>