<?php

/**
 * Global settings form template.
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

?>

<div class="review-wall-section">
    <h2><?php esc_html_e('Global Settings', 'review-wall'); ?></h2>

    <form method="post" action="" class="review-wall-form">
        <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
        <input type="hidden" name="review_wall_submit_action" value="save_global_settings">

        <table class="form-table">
            <!-- Logo Field -->
            <tr>
                <th scope="row">
                    <label for="review_wall_logo"><?php esc_html_e('Logo', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="hidden" id="review_wall_logo" name="review_wall_logo" value="<?php echo esc_attr($logo); ?>">
                    <button type="button" class="button" id="upload_logo_button"><?php esc_html_e('Upload Logo', 'review-wall'); ?></button>

                    <?php if (!empty($logo)): ?>
                        <button type="button" class="button" id="remove_logo_button"><?php esc_html_e('Remove Logo', 'review-wall'); ?></button>
                    <?php endif; ?>

                    <div id="logo_preview">
                        <?php if (!empty($logo)): ?>
                            <?php echo wp_get_attachment_image($logo, 'medium', false, ['style' => 'max-width: 200px;']); ?>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>

            <!-- Rating Threshold Field -->
            <tr>
                <th scope="row">
                    <label for="review_wall_rating_threshold"><?php esc_html_e('Rating Threshold', 'review-wall'); ?></label>
                </th>
                <td>
                    <select name="review_wall_rating_threshold" id="review_wall_rating_threshold">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                            <option value="<?php echo esc_attr($i); ?>" <?php selected($rating_threshold, $i); ?>><?php echo esc_html($i); ?></option>
                        <?php endfor; ?>
                    </select>
                    <p class="description"><?php esc_html_e('Redirect to Google Review at or above this rating.', 'review-wall'); ?></p>
                </td>
            </tr>

            <!-- Default URL Field -->
            <tr>
                <th scope="row">
                    <label for="review_wall_default_url"><?php esc_html_e('Default Google Review URL', 'review-wall'); ?></label>
                </th>
                <td>
                    <input type="url" name="review_wall_default_url" id="review_wall_default_url" class="regular-text" value="<?php echo esc_attr($default_url); ?>" required>
                    <p class="description">
                        <?php esc_html_e('If you have only one Google review account, simply enter its URL here.', 'review-wall'); ?>
                        <br>
                        <?php esc_html_e('Additionally, this URL will be used as a fallback when accessing an invalid review link if multiple URLs are added in the "Existing URLs" section below.', 'review-wall'); ?>
                        <br>
                        <?php esc_html_e('Example: https://www.google.com/maps/place/YourBusiness/reviews', 'review-wall'); ?>
                    </p>
                </td>
            </tr>
        </table>

        <p class="submit">
            <input type="submit" name="submit" class="button button-primary" value="<?php esc_html_e('Save Settings', 'review-wall'); ?>">
        </p>
    </form>
</div>