<?php

/**
 * Edit Modal template.
 */

// Security check
if (!defined('ABSPATH')) {
    exit;
}

?>

<!-- Edit Modal -->
<div id="edit-url-modal" class="review-wall-modal">
    <div class="review-wall-modal-content">
        <span class="review-wall-modal-close">&times;</span>
        <h2><?php esc_html_e('Edit URL', 'review-wall'); ?></h2>

        <form method="post" action="" class="review-wall-form">
            <?php wp_nonce_field('review_wall_action', 'review_wall_nonce'); ?>
            <input type="hidden" name="review_wall_submit_action" value="update_url">
            <input type="hidden" name="url_id" id="edit_url_id">

            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="edit_url_name"><?php esc_html_e('Name', 'review-wall'); ?></label>
                    </th>
                    <td>
                        <input type="text" name="url_name" id="edit_url_name" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="edit_url_key"><?php esc_html_e('URL Key', 'review-wall'); ?></label>
                    </th>
                    <td>
                        <input type="text" name="url_key" id="edit_url_key" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="edit_url_link"><?php esc_html_e('Google Review URL', 'review-wall'); ?></label>
                    </th>
                    <td>
                        <input type="url" name="url_link" id="edit_url_link" class="regular-text" required>
                    </td>
                </tr>
            </table>

            <p class="submit">
                <input type="submit" name="submit" class="button button-primary" value="<?php esc_html_e('Update URL', 'review-wall'); ?>">
            </p>
        </form>
    </div>
</div>